;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Ieee/vectors.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jul  6 14:18:49 1992                          */
;*    Last change :  Tue Dec 28 14:17:36 1993 (serrano)                */
;*                                                                     */
;*    6.8. Vectors (page 26, r4)                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_vectors_6_8
   (foreign (define bool c-vector?       (obj)              "VECTORP")
	    (bvector     c-make-vector   (bint obj)         "make_vector")
	    (define bint c-vector-length (bvector)          "VECTOR_LENGTH")
	    (define obj  c-vector-ref    (bvector bint)     "VECTOR_REF")
	    (define obj  c-vector-set!   (bvector bint obj) "VECTOR_SET")
	    (define bool vector-bound-check? (bint bint)    "BOUND_CHECK"))
   (export  (inline vector?        obj)
	    (inline make-vector    int . obj)
	    (inline vector         . args)
	    (inline vector-length  vector)
	    (inline vector-ref     vector int)
	    (inline vector-set!    vector int obj)
	    (inline vector-ref-ur  vector int) 
	    (inline vector-set-ur! vector int obj)
	    (vector->list          vector)
	    (list->vector          list)
	    (vector-fill!          vector fill))
   (pragma  (c-vector? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-vector-length _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-vector-ref _no_side_effect_ _no_mutation_ _imbricable_)))
   
;*---------------------------------------------------------------------*/
;*    vector? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (vector? obj)
   (c-vector? obj))

;*---------------------------------------------------------------------*/
;*    make-vector ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (make-vector int . fill)
   (if (null? fill)
       (c-make-vector int '())
       (c-make-vector int (car fill))))

;*---------------------------------------------------------------------*/
;*    vector . args ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (vector . args)
   (list->vector args))

;*---------------------------------------------------------------------*/
;*    vector-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (vector-length vector)
   (c-vector-length vector))

;*---------------------------------------------------------------------*/
;*    vector-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (vector-ref vector k)
   (if (vector-bound-check? k (vector-length vector))
       (c-vector-ref vector k)
       (error "vector-ref" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    vector-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (vector-set! vector k obj)
   (if (vector-bound-check? k (vector-length vector))
       (c-vector-set! vector k obj)
       (error "vector-set!" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    vector-ref-ur ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (vector-ref-ur vector k)
   (c-vector-ref vector k))

;*---------------------------------------------------------------------*/
;*    vector-set-ur! ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (vector-set-ur! vector k obj)
   (c-vector-set! vector k obj))

;*---------------------------------------------------------------------*/
;*    vector->list ...                                                 */
;*---------------------------------------------------------------------*/
(define (vector->list vector)
   (let ((vlen (vector-length vector)))
      (if (=fx vlen 0)
	  '()
	  (let loop ((i   (-fx vlen 1))
		     (acc '()))
	     (if (=fx i 0)
		 (cons (vector-ref-ur vector i) acc)
		 (loop (-fx i 1) (cons (vector-ref-ur vector i) acc)))))))

;*---------------------------------------------------------------------*/
;*    list->vector ...                                                 */
;*---------------------------------------------------------------------*/
(define (list->vector list)
   (let* ((len (length list))
	  (vec (make-vector len '())))
      (let loop ((i 0)
		 (l list))
	 (if (=fx i len)
	     vec
	     (begin
		(vector-set-ur! vec i (car l))
		(loop (+fx i 1) (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    vector-fill! ...                                                 */
;*---------------------------------------------------------------------*/
(define (vector-fill! vector fill)
   (let loop ((i (-fx (c-vector-length vector) 1)))
      (if (>=fx i 0)
	  (begin
	     (vector-set-ur! vector i fill)
	     (loop (-fx i 1))))))
