;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloos/recette/case.scm ...                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 18 15:16:39 1992                          */
;*    Last change :  Tue Nov  3 15:13:50 1992  (serrano)               */
;*                                                                     */
;*    On test le case.                                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module case
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-case)))

;*---------------------------------------------------------------------*/
;*    test 1.                                                          */
;*---------------------------------------------------------------------*/
(define (test1 x)
   (case x
      ((tutu) 'tutu)
      ((toto) 'toto)
      (else
       'dummy
       'else)))

;*---------------------------------------------------------------------*/
;*    test 2.                                                          */
;*---------------------------------------------------------------------*/
(define (test2 x)
   (case (begin 1 2 x)
      ((tete tutu tyty) 1)
      ((toto) 2)
      ((tata) 3)))

;*---------------------------------------------------------------------*/
;*    test 3.                                                          */
;*---------------------------------------------------------------------*/
(define (test3 x)
   (case (begin 2 3 x)
      ((1 2 3 4) 1)
      ((5 6 7 8) 5)
      (else      0)))

;*---------------------------------------------------------------------*/
;*    test 4.                                                          */
;*---------------------------------------------------------------------*/
(define (test4 x)
   (case x
      ((tutu 1) "tutu ou 1")
      ((2 3)    "2 ou 3") 
      (else     "else")))

;*---------------------------------------------------------------------*/
;*    test 5.                                                          */
;*    -------------------------------------------------------------    */
;*    Ce test est important car il permet de tester la compilation     */
;*    des cases qui comportent des symboles qui ont meme nombre de     */
;*    hash                                                             */
;*---------------------------------------------------------------------*/
(define (test5 x)
   (case x
      ((SHOW)
       'show)
      ((compute!)
       'compute!)
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    test 6.                                                          */
;*---------------------------------------------------------------------*/
(define (test6 x)
   (case x
      ((#\o)
       #\o)
      ((#\d)
       #\d)
      ((#\x)
       #\x)))

;*---------------------------------------------------------------------*/
;*    test 7. ...                                                      */
;*---------------------------------------------------------------------*/
(define (test7 x)
   ;; set! et fibo on meme nombre de hash
   (case x
      ((set!)
       'set!)
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    test-case ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-case)
   (test-module "case" "case.scm" #f)
   (test "case symbol" (test1 'tutu) 'tutu)
   (test "case symbol" (test1 'toto) 'toto)
   (test "case symbol" (test1 'tata) 'else)
   (test "case symbol" (test1 5) 'else)
   (test "case symbol" (test2 'tutu) 1)
   (test "case symbol" (test2 'toto) 2)
   (test "case symbol" (test2 'tata) 3)
   (test "case symbol" (test2 5) #f)
   (test "case integer" (test3 (+ 1 2)) 1)
   (test "case integer" (test3 'toto) 0)
   (test "case mixte" (test4 'tutu) "tutu ou 1") 
   (test "case mixte" (test4 1) "tutu ou 1")
   (test "case mixte "(test4 3) "2 ou 3")
   (test "case mixte" (test4 'titi) "else")
   (test "case hash" (test5 'show) 'show)
   (test "case hash" (test5 'compute!) 'compute!)
   (test "case hash" (test5 'toto) 'else)
   (test "case char"  (test6 #\a) #f)
   (test "case char" (test6 #\x) #\x)
   (test "case hash" (test7 'fibo) 'else))
   



   
