;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/examples/Lower/lower.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Oct 19 14:49:54 1992                          */
;*    Last change :  Mon May 10 08:26:33 1993  (serrano)               */
;*                                                                     */
;*    Un petit programme qui prends un fichier `Lisp' et qui           */
;*    convertit tous les symboles en minuscule.                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(MODULE LOWER
   (MAIN MAIN))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(DEFINE (MAIN ARGV)
   (IF (NULL? (CDR ARGV))
       (BEGIN
	  (PRINT "usage: lower [file1] ... [filen]")
	  (exit -1))
       (FOR-EACH LOWERFILE (CDR ARGV))))

;*---------------------------------------------------------------------*/
;*    lowerfile ...                                                    */
;*---------------------------------------------------------------------*/
(DEFINE (LOWERFILE FILENAME)
   (let ((input-port  (open-INPUT-file filename))
	 (output-port (open-output-file (string-append filename "l"))))
      (cond
	 ((not (input-port? input-port))
	  (error "lower" "can't open input file" filename))
	 ((NOT (output-port? output-port))
	  (error "lower"
		 "can't open output file"
		 (string-append filename "l")))
	 (else
	  (lower input-port output-port)))))

;*---------------------------------------------------------------------*/
;*    lower ...                                                        */
;*---------------------------------------------------------------------*/
(define lower
   (let* ((par-open 0)
	  (grammar (regular-grammar ((chiffre (>-< #\0 #\9))
				     (float   (! ((* chiffre) #\. (+ chiffre))
						 ((+ chiffre) #\. (* chiffre))))
				     (lettre  (>-< #\a #\z #\A #\Z))
				     (special (in #\! #\@ #\# #\$ #\%
						  #\^ #\& #\* #\> #\<
						  #\/ #\. #\- #\_ #\+   
						  #\\ #\| #\{ #\= #\?
						  #\} #\: #\~))
				     (quote   (in #\" #\, #\' #\`))
				     (paren   (in #\( #\) #\[ #\]))
				     (blank   (in #\space #\tab #\newline))  
				     (id      (+  (! lettre chiffre special))))
		      ((blank)
		       (the-string))
		      ((#\# #\\ (! lettre
				   chiffre
				   special
				   quote
				   paren
				   ";"))
		       (the-string))
		      ((";" (* (all))) 
		       (the-string))
		      ((uncase "#\newline")
		       (the-string))
		      ((uncase "#\tab")
		       (the-string))
		      ((uncase "#\space")
		       (the-string))
		      ((#\" (* (! (<-> #\")
				  (#\\ #\"))) #\")
		       (the-string))
		      ((eof (#\" (* (! (<-> #\")
				       (#\\ #\")))))
		       (error "read" "Unexpected end-of-file" 'string))
		      ((! (+ chiffre)
			  (#\- (+ chiffre))
			  (#\+ (+ chiffre)))
		       (the-string))
		      (("#o" (! (+ (>-< #\0 #\7))
				((in #\+ #\-)
				 (>-< #\0 #\7))))
		       (the-string))
		      (("#d" (! (+ chiffre)
				((in #\+ #\-)
				 chiffre)))
		       (the-string))
		      (("#x" (! (+ (! chiffre
				      (>-< #\a #\f)
				      (>-< #\A #\F)))
				((in #\+ #\-)
				 (+ (! chiffre
				       (>-< #\a #\f)
				       (>-< #\A #\F))))))
		       (the-string))
		      ((! float
			  ((in #\+ #\-) float)
			  ((! float (+ chiffre))
			   (in #\e #\E) (+ chiffre)) 
			  ((in #\+ #\-) (! float (+ chiffre))
					(in #\e #\E) (+ chiffre))
			  ((! float (+ chiffre)) (in #\e #\E)
						 (in #\+ #\-) (+ chiffre))
			  ((in #\+ #\-) (! float (+ chiffre))
					(in #\e #\E) (in #\+ #\-) (+ chiffre)))
		       (the-string))
		      (pair (#\.)
			    (context)
			    'dot)
		      ((uncase "#t")
		       (the-string))
		      ((uncase "#f")
		       (the-string))
		      ((! id (#\. (+ #\.)))
		       (string-downcase (the-string)))
		      ((#\')
		       (cons 'quote (cons (ignore) '())))
		      ((#\`)
		       (cons 'quasiquote (cons (ignore) '())))
		      ((#\,)
		       (cons 'unquote (cons (ignore) '())))
		      ((#\, #\@)
		       (cons 'unquote-splicing (cons (ignore) '())))
		      ((in #\( #\[)
		       (let ((open-key par-open))
			  (set! par-open (+ 1 par-open))
			  (context 'pair)
			  (let loop-pair ((walk (ignore)))
			     (cond
				((= open-key par-open)
				 '())
				((eq? walk 'dot)
				 (let ((cdr (ignore)))
				    (ignore)
				    (if (= open-key par-open)
					cdr
					(begin
					   (error "read" "illegal pair" cdr)
					   (let loop ()
					      (if (= par-open open-key)
						  (ignore)
						  (begin
						     (ignore)
						     (loop))))))))
				(else
				 (cons walk (loop-pair (ignore))))))))
		      ((in #\) #\])
		       (set! par-open (- par-open 1))
		       (if (< par-open 0)
			   (begin
			      (set! par-open 0)
			      (ignore))
			   #f))
		      ((#\# #\()
		       (let ((car      (ignore)) 
			     (open-key par-open))
			  (set! par-open (+ 1 par-open))
			  (list->vector
			   (let loop-vector ((walk car))
			      (cond
				 ((= open-key par-open)
				  '())
				 (else
				  (cons walk
					(loop-vector (ignore)))))))))
		      (else
		       (let ((char (the-failing-char)))
			  (if (and (eof-object? char) (> par-open 0))
			      (error "read" "Unexpected end-of-file" char)
			      char))))))
      (lambda (input-port output-port)
	 (let loop ((sexp (read/rp grammar input-port)))
	    (if (eof-object? sexp)
		'done
		(begin
		   (display-sexp sexp output-port)
		   (loop (read/rp grammar input-port)))))))) 

;*---------------------------------------------------------------------*/
;*    display-sexp ...                                                 */
;*---------------------------------------------------------------------*/
(define (display-sexp sexp port)
   (cond
      ((pair? sexp)
       (cond
	  ((eq? (car sexp) 'quote)
	   (display "'" port)
	   (display (cadr sexp) port))
	  ((eq? (car sexp) 'unquote)
	   (display "," port)
	   (display (cadr sexp) port))
	  ((eq? (car sexp) 'quasiquote)
	   (display "`" port)
	   (display (cadr sexp) port))
	  ((eq? (car sexp) 'unquote-splicing)
	   (display ",@" port)
	   (display (cadr sexp) port))
	  (else
	   (let ((l sexp))
	      (display "(" port)
	      (for-each (lambda (exp) (display-sexp exp port))
			sexp)
	      (display ")" port)))))
      ((vector? sexp)
       (display "#(" port)
       (let loop ((i 0))
	  (if (= i (vector-length sexp))
	      (display "#)" port)
	      (begin
		 (display (vector-ref sexp i) port)
		 (loop (+ i 1))))))
      (else
       (display sexp port))))

	  
       
