;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Type/bind.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 29 11:22:05 1993                          */
;*    Last change :  Thu Jun  2 11:40:52 1994 (serrano)                */
;*                                                                     */
;*    Le typage des formes `bind-exit'                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_bind-exit
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  type_cast
	    type_expression
	    type_type
	    tools_error
	    tools_shape
	    tools_beta
	    heap_abstract
	    scan_lexical
	    engine_param)
   (export  (type-bind-exit exp to)))

;*---------------------------------------------------------------------*/
;*    type-bind-exit ...                                               */
;*---------------------------------------------------------------------*/
(define (type-bind-exit exp to)
   (let* ((local (car (cadr exp)))
	  (fun   (local-value local)))
      (cond
	 ((and (not (return-escape? fun))
	       (not (eq? (local-access local) 'write)))
	  (type-bind exp to))
	 ((not (eq? (local-access local) 'write))
	  (type-bind/E exp to))
	 (else
	  (type-bind/W exp to)))))

;*---------------------------------------------------------------------*/
;*    type-bind ...                                                    */
;*---------------------------------------------------------------------*/
(define (type-bind exp to)
   (trace type "type-bind: " (shape exp) #\Newline)
   (let ((local (car (cadr exp))))
      (set-car! exp 'block)
      (set-car! (cdr exp) local)
      (set-car! (cddr exp) (car (cddr exp)))
      (set-car! (cddr exp) (type-expression (caddr exp) to))
      exp))

;*---------------------------------------------------------------------*/
;*    type-bind/E ...                                                  */
;*---------------------------------------------------------------------*/
(define (type-bind/E exp to)
   (trace type "type-bind/E: " (shape exp) #\Newline)
   (let ((local (car (cadr exp))))
      (set-car! exp 'block)
      (set-car! (cdr exp) local)
      (let ((val (cdr (car (allocate-local-variables
			    (list 'val)))))
	    (var (cdr (car (allocate-local-functions
			    (list (local-name local)))))))
	 (function-arity-set!   (local-value var) 1)
	 (function-args-set!    (local-value var) (list val))
	 (function-escape?-set! (local-value var) #t)
	 (set-car! (cddr exp)
		   `(labels ((,var (,val) (return-from ,local ,val)))
		       ,(type-expression
			 (beta-reduce (caddr exp) (list (cons local var)))
			 to)))
	 exp)))

;*---------------------------------------------------------------------*/
;*    type-bind/W ...                                                  */
;*---------------------------------------------------------------------*/
(define (type-bind/W exp to)
   (trace type "type-bind/W: " (shape exp) #\Newline)
   (let ((local (car (cadr exp))))
      (set-car! exp 'block)
      (set-car! (cdr exp) local)
      (let ((val (cdr (car (allocate-local-variables
			    (list 'val)))))
	    (new (cdr (car (allocate-local-variables
			    (list (local-name local))))))
	    (var (cdr (car (allocate-local-functions
			    '(fun))))))
	 ;; on dit que la nouvelle est affectee ...
	 (local-access-set!     new 'write)
	 ;; et il ne faut pas oublier de dire que l'ancienne ne l'est plus
	 (local-access-set!     local 'read)
	 (function-arity-set!   (local-value var) 1)
	 (function-args-set!    (local-value var) (list val))
	 (function-escape?-set! (local-value var) #t)
	 (set-car! (cddr exp)
		   `(labels ((,var (,val) (return-from ,local ,val)))
		       (let ((,new (function ,var)))
			  ,(type-expression
			    (beta-reduce (caddr exp) (list (cons local new)))
			    to))))
	 exp)))
  

			
