;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Scan/walk.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 18 19:30:04 1993                          */
;*    Last change :  Wed May 25 09:49:30 1994 (serrano)                */
;*                                                                     */
;*    Les taches effectuees par cette passe sont:                      */
;*       - trouver toutes les formes statiques                         */
;*       - verifier que chaque prototype a trouve sa definition.       */
;*       - on verifie qu'on ne viole pas les prototype.                */
;*       - Regrouper toutes les formes `top-level'.                    */
;*       - Construire l'arbre de syntaxe abstraite.                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_walk
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  tools_speek
	    tools_error
	    tools_progn
	    tools_shape
	    tools_hash
	    tools_args
	    var_declare
	    var_env
	    engine_param
	    scan_definition
	    scan_temporary
	    scan_tree
	    scan_lexical
	    scan_eval
	    scan_labels)
   (export  (scan-walk code)))

;*---------------------------------------------------------------------*/
;*    scan-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (scan-walk code)
   (verbose "   . Scan" #\Newline)
   (start-partial-error "Scan")
   (let ((*top-level* (declare-global-procedure! (initialisation-name)
						 '()
						 *module-name*
						 'export)))
      (let loop  ((code        (if (or (eq? *pass* 'make-heap)
				       (and *unsafe-type*
					    *unsafe-range*
					    *unsafe-struct*
					    *unsafe-arity*))
				   ;; si on n'est pas en train de
				   ;; construire un tas et qu'on n'est pas
				   ;; en mode `unsafe' on test la
				   ;; coherence des modules.
				   code
				   (cons `(check-for-version-soundness!
					   ',*module-name*
					   ,*bigloo-name*
					   ,*bigloo-level*)
					 code)))
		  (definitions '()))
	 (if (null? code)
	     ;; on a calculer toutes les formes, il faut maintenant
	     ;; construire l'arbre definitif
	     (make-final-code *top-level* (cons 0 definitions))
	     (match-case (car code)
		((begin . ?body)
		 (loop (append body (cdr code))
		       definitions))
		((or (and (not (?- . ?-)) ?exp)
		     (begin . ?body))
		 (loop (cdr code)
		       (cons (make-expression-tree (car code) 'read '())
			     definitions)))
		((or (define-inline (?name . ?-) ?-)
		     (define (?name . ?-) ?-))
		 (loop (cdr code)
		       (cons (scan-function-definition (car code))
			     definitions)))
		((define ?var (atom ?val))
		 (loop (cdr code)
		       (cons (scan-atom-definition (car code))
			     definitions)))
		((define ?var ?val)
		 (loop (cdr code)
		       (cons (scan-value-definition (car code))
			     definitions)))
		(else
		 (loop (cdr code)
		       (cons (make-expression-tree (car code) 'read '())
			     definitions))))))))
   
;*---------------------------------------------------------------------*/
;*    make-final-tree ...                                              */
;*    -------------------------------------------------------------    */
;*    Le travail essentiel de cette fonction est de repartir en deux   */
;*    categories les definitions. Il y a celles qui sont effectivement */
;*    des definitions et il y a celles qui doivent etre mises dans la  */
;*    fonction d'initialisation.                                       */
;*---------------------------------------------------------------------*/
(define (make-final-code top-level definitions)
   ;; on a lu toutes les variables temporaires, il faut
   ;; maintenant les mettre dans *Genv*
   (fixe-temporary!)
   ;; maintenant qu'on a tout vu, on peut s'arretter s'il
   ;; y a des erreurs.
   (fail-if-partial-error)
   ;; on ajuste les prototype des fonctions importees
   (fixe-imported!)
   ;; on verifie que chaque global a trouve sa definition
   ;; on supprime la liste la fonction d'initialisation
   (remove-from-remember-list! (initialisation-name))
   (if (not (null? (get-remember-list)))
       (error "scan"
	      "some declared variable aren't defined"
	      (get-remember-list)))
   (let loop ((definitions definitions)
	      (def-forms  '())
	      (init-forms '()))
      (if (null? definitions)
	  ;; on construit la fonction d'initialisation et on retourne
	  (let ((res (cons (make-init-function top-level init-forms)
			   def-forms)))
	     (when-trace '(env init)
			 (lambda ()
			    (fprint *trace-port* "==> Genv (scan): ")
			    (pp-global-environment *trace-port*
						   *Genv*)))
	     (when-trace 'init
			 (lambda ()
			    (fprint *trace-port* #\Newline
				    "_________________________________"
				    #\Newline "==> Tree: ")
			    (for-each (lambda (def)
					 (fprint *trace-port*
						 (shape def)
						 #\Newline))
				      res)))
	     res)
	  (match-case (car definitions)
	     ((define ?global (lambda ?args ?body))
	      (if (eq? (global-class global) 'function)
		  (let ((value (global-value global)))
		     (function-body-set! value body)
		     (function-args-set! value args)
		     (loop (cdr definitions)
			   (cons global def-forms)
			   init-forms))
		  (loop (cdr definitions)
			def-forms
			(cons (define->set! top-level (car definitions))
			      init-forms))))
	     (else
	      (loop (cdr definitions)
		    def-forms
		    (cons (car definitions)
			  init-forms)))))))

;*---------------------------------------------------------------------*/
;*    define->set! ...                                                 */
;*---------------------------------------------------------------------*/
(define (define->set! top-level form)
   (let* ((var   (cadr form))
	  (args  (cadr (caddr form)))
	  (body  (caddr (caddr form)))
	  (name  (get-new-lambda-name (function-arity (global-value var))))
	  (local (cdar (allocate-local-functions (list name)))))
      ;; on prend l'arite de la fonction et ...
      (function-arity-set! (local-value local)
			   (function-arity (global-value var)))
      ;; on efface le champs valueur qui ne sert plus a rien.
      (global-value-set! var '())
      `(set! ,var
	     (labels ((,local ,args ,(make-local-body local body)))
		,local))))
		 
;*---------------------------------------------------------------------*/
;*       make-init-function ...                                        */
;*---------------------------------------------------------------------*/
(define (make-init-function top-level forms)
   (let ((forms (append (eval-initialisation) forms)))
      (function-body-set! (global-value top-level) (normalize-progn forms))
      (function-args-set! (global-value top-level) '())
      top-level))

;*---------------------------------------------------------------------*/
;*    fixe-imported! ...                                               */
;*---------------------------------------------------------------------*/
(define (fixe-imported!)
   (trace init "Dans fixe-imported!" #\Newline)
   (define (walk-on-bucket bucket)
      (if (null? bucket)
	  'done
	  (let ((pr (car bucket)))
	     (if (and (not (eq? *pass* 'make-heap))
		      (eq? (global-import pr) 'import)
		      (eq? (global-class pr) 'function)
		      (null? (global-library? pr))
		      (null? (function-args (global-value pr))))
		 (let* ((arity (function-arity (global-value pr)))
			(proto (if (<fx arity 0)
				   (make-n-proto (negfx arity))
				   (make-n-proto arity))))
		    (trace init (shape pr) " --> " proto #\Newline)
		    (function-args-set! (global-value pr) proto)))
	     (walk-on-bucket (cdr bucket)))))
   (walk-on-hash-table! walk-on-bucket *Genv* 'Genv))
 
 
 
