;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Read/inline.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 17 14:13:57 1992                          */
;*    Last change :  Thu Jan  6 09:21:46 1994 (serrano)                */
;*                                                                     */
;*    On part a la recherche des inlines dans un port                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_inline
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  tools_progn
	    tools_speek
	    var_env)
   (export  (look-for-inline inline port module)))

;*---------------------------------------------------------------------*/
;*    look-for-inline ...                                              */
;*    inlines x port x symbol --> 'done @ error                        */
;*    -------------------------------------------------------------    */
;*    On lit tout le code jusqu'a ce qu'on ait trouve tous les inlines */
;*    oubien qu'on est trouve EOF                                      */
;*---------------------------------------------------------------------*/
(define (look-for-inline inlines port module)
   (trace read "Je recherche dans: " module #\Newline
	        "                 : " inlines)
   (if (null? inlines)
       'done
       (let loop ((exp     (read port))
		  (inlines inlines))
	  (cond
	     ((null? inlines)
	      'done)
	     ((eof-object? exp)
	      (let loop ((inlines inlines))
		 (if (null? (cdr inlines))
		     (error "look-for-inline"
			    "Can't find such inline definition"
			    (string-append
			     (string-append (symbol->string (car inlines))
					    "@")
			     (symbol->string module)))
		     (begin
			(warning
			 "module-declaration"
			 "Can't find such inline definition -- "
			 (string-append
			  (string-append (symbol->string (car inlines))
					 "@")
			  (symbol->string module)))
			(loop (cdr inlines))))))
	     (else
	      (match-case exp
		 ((define-inline (?name . ?args) . ?body)
		  (if (not (memq name inlines))
		      (loop (read port) inlines)
		      (let* ((global (find-in-global-environment name *Genv*))
			     (function (global-value global)))
			 (function-body-set! function (force-progn body))
			 (function-args-set! function args)
			 (loop (read port) (remq! name inlines)))))
		 (else
		  (loop (read port) inlines))))))))
				      
   

				      
   
