;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../integrate.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 29 17:36:25 1993                          */
;*    Last change :  Wed Jul  7 17:04:03 1993  (serrano)               */
;*                                                                     */
;*    Le calcul de la l'integration des fonctions locales.             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_integrate
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    engine_param)
   (export  (integrate! Root G0 Gn)
	    (unmark-bound-integrated! G)))

;*---------------------------------------------------------------------*/
;*    integrate! ...                                                   */
;*---------------------------------------------------------------------*/
(define (integrate! Root G0 Gn)
   (root-call-sons! Root)
   (let _loop_ ((G0 G0)
		(Gn Gn))
      (trace (loop lift) "integrate: " (shape G0) " " (shape Gn) #\Newline)
      (if (null? G0)
	  Gn
	  (let loop ((G0  G0)
		     (Gn  Gn)
		     (new '()))
	     (if (null? G0)
		 (_loop_ new Gn)
		 (let ((new-new (call-sons (car G0))))
		    (loop (cdr G0)
			  (append new-new Gn)
			  (append new-new new))))))))
   
;*---------------------------------------------------------------------*/
;*    unmark-bound-integrated! ...                                     */
;*    -------------------------------------------------------------    */
;*    On marque que seule les fonctions libres doivent etre integrees. */
;*    Les autres auront juste leur definition normale.                 */
;*---------------------------------------------------------------------*/
(define (unmark-bound-integrated! G)
   (let loop ((cto        (lift-cto        (local-info G)))
	      (integrates (lift-integrates (local-info G))))
      (trace (lift loop) "unmark!: " (shape G)
	     #\[ (shape integrates) #\] #\Newline)
      (for-each (lambda (i)
		   (lift-key-set! (local-info i) G))
		integrates)
      (let loop ((fs (list G)))
	 (if (null? fs)
	     'done
	     (let ((f (car fs)))
		(trace (lift loop) "loop.1: " (shape f) #\Newline
		       "     b: " (shape (lift-bind (local-info f)))
		       #\Newline)
		(lift-key-set! (local-info f) #f)
		(if (and (not (eq? (local-class f) 'function))
			 (not (eq? (local-class f) 'return)))
		    (loop (cdr fs))
		    (loop (append (lift-bind (local-info f)) (cdr fs)))))))
      ;; on collecte les fonctions qui sont soient definies par G soient
      ;; appellees depuis G
      (let loop ((integrates integrates)
		 (new        '()))
	 (trace (lift loop) "loop.2: " (shape integrates) #\Newline
		            "   new: " (shape new) #\Newline)
	 (if (null? integrates)
	     (begin
		(trace (lift loop) "------>  " (shape G)
		       #\{ (shape new) #\} #\Newline)
		(lift-integrates-set! (local-info G) new))
	     (let ((f (car integrates)))
		(if (not (eq? (lift-key (local-info f)) G))
		    (begin
		       (lift-integrator-set! (local-info f) '())
		       (loop (cdr integrates)
			     new))
		    (loop (cdr integrates)
			  (cons f new))))))))

;*---------------------------------------------------------------------*/
;*    root-call-sons! ...                                              */
;*---------------------------------------------------------------------*/
(define (root-call-sons! root)
   (let loop ((callee (cond
			 ((local? root)
			  (lift-cto (local-info root)))
			 ((global? root)
			  (global-info root))
			 (else
			  (error "root-call-sons!"
				 "Not a variable"
				 (shape root))))))
      (if (null? callee)
	  'done
	  (let ((c (car callee)))
	     (if (and (not (lift-G? (local-info c)))
		      (null? (lift-integrator (local-info c))))
		 (begin
		    (lift-integrator-set! (local-info c) root)
		    (loop (append (lift-cto (local-info c)) callee)))
		 (loop (cdr callee)))))))

;*---------------------------------------------------------------------*/
;*    call-sons ...                                                    */
;*---------------------------------------------------------------------*/
(define (call-sons Gcaller)
   (let loop ((callee (lift-cto (local-info Gcaller)))
	      (new    '()))
      (if (null? callee)
	  new
	  (let ((c (car callee)))
	     (trace (loop lift) "call-sons: " (shape Gcaller) "." (shape c)
		    "...")
	     (cond
		((lift-G? (local-info c))
		 (trace (loop lift) "[G]" #\Newline)
		 ;; c'est deja globalisee
		 (loop (cdr callee) new))
		((eq? (local-class c) 'return)
		 (trace (loop lift) "[return]" #\Newline)
		 ;; on n'integre pas les blocks lexicaux
		 (lift-G?-set! (local-info c) #t)
		 (loop (cdr callee) (cons c new)))
		((eq? (lift-integrator (local-info c)) Gcaller)
		 (trace (loop lift) "[i:"
			(shape (lift-integrator (local-info c))) "]" #\Newline)
		 ;; c'est bon, la fonction est deja integree dans integrator
		 (loop (cdr callee) new))
		((null? (lift-integrator (local-info c)))
		 (trace (loop lift) "[i:()]" #\Newline)
		 ;; la fonction c n'est integree nulle part
		 (lift-integrator-set! (local-info c) Gcaller)
		 (lift-integrates-set! (local-info Gcaller)
				       (cons c (lift-integrates
						(local-info GCaller))))
		 (loop (append (lift-cto (local-info c)) (cdr callee))
		       new))
		(else
		 (trace (loop lift) "[else]" #\Newline)
		 ;; ca ne va pas mais on regarde si on peut changer les choses
		 ;; si on est en mode -O, on calcule l'integration
		 ;; maximale
		 (if (>fx *optim* 1)
		     (change-integrator! c))
		 (lift-G?-set! (local-info c) #t)
		 (loop (append (lift-cto (local-info c)) (cdr callee))
		       (cons c new))))))))
       
;*---------------------------------------------------------------------*/
;*    change-integrator! ...                                           */
;*---------------------------------------------------------------------*/
(define (change-integrator! local)
   (trace (loop lift) "change-integrator!: " (shape local) #\Newline
	              "    old-integrated: " (shape (lift-integrates
						     (local-info local)))
		      #\Newline)
   ;; toutes les fonctions qui sont des descendants de local changent
   ;; d'integrateur et passe a local
   (let loop ((locals (list local))
	      (which  (lift-cto (local-info local))))
      (if (null? which)
	  'done
	  (let ((fun (car which)))
	     (trace (loop lift) "could-change? : " (shape fun) " : "
		    (could-change-integrator? fun locals) #\newline)
	     (cond
		((eq? (lift-integrator (local-info fun)) local)
		 ;; on a deja change cette fonction
		 (loop locals (cdr which)))
		((could-change-integrator? fun locals)
		 (let ((oi (lift-integrator (local-info fun))))
		    (trace (loop lift) "oi: " (shape oi) #\Newline)
		    (if (local? oi)
			(begin
			   (lift-integrates-set! (local-info oi)
						 (remq! fun (lift-integrates
							     (local-info oi))))
			   (lift-integrator-set! (local-info fun) local)
			   (lift-integrates-set! (local-info local)
						 (cons fun
						       (lift-integrates
							(local-info local))))
			   (loop (cons fun locals)
				 (append (lift-cto (local-info fun)) which)))
			(begin
			   (lift-integrator-set! (local-info fun) local)
			   (lift-integrates-set! (local-info local)
						 (cons fun
						       (lift-integrates
							(local-info local))))
			   (loop (cons fun locals)
				 (append (lift-cto (local-info fun))
					 which))))))
		(else
		 (loop locals (cdr which))))))))

;*---------------------------------------------------------------------*/
;*    could-change-integrator? ...                                     */
;*    -------------------------------------------------------------    */
;*    On peut changer d'integrateur si tous les appelant de `fun' sont */
;*    dans `which'.                                                    */
;*---------------------------------------------------------------------*/
(define (could-change-integrator? fun froms)
   (let loop ((cfrom (lift-cfrom (local-info fun))))
      (cond
	 ((null? cfrom)
	  #t)
	 ((memq (car cfrom) froms)
	  (loop (cdr cfrom)))
	 ((eq? (car cfrom) fun)
	  (loop (cdr cfrom)))
	 (else
	  #f))))
