;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Fuse/walk.scm ...        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 29 07:53:10 1993                          */
;*    Last change :  Fri Feb 25 11:54:11 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'inlining a peut-etre rendu un certain nombre de fonctions      */
;*    globales inutiles. Cette passe se charge de les supprimer de     */
;*    l'arbre de syntaxe abstraite.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module fuse_walk
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_hash
	    var_env
	    fuse_cgraph)
   (export  (fuse-walk tree)))

;*---------------------------------------------------------------------*/
;*    fuse-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (fuse-walk tree)
   (verbose "   . Fuse" #\Newline)
   (let loop ((used (find-export-in-Genv)))
      (cond
	 ((null? used)
	  (truncate-tree! tree))
	 ((eq? (global-info (car used)) 'done)
	  ;; on a deja scanne la definition, on saute
	  (loop (cdr used)))
	 (else
	  (global-info-set! (car used) 'done)
	  (loop (global-find-used! (car used) (cdr used)))))))

;*---------------------------------------------------------------------*/
;*    truncate-tree! ...                                               */
;*---------------------------------------------------------------------*/
(define (truncate-tree! tree)
   (let loop ((tree      tree)
	      (new-tree '()))
      (if (null? tree)
	  new-tree
	  (let ((pr (car tree)))
	     (if (global-info pr)
		 (begin
		    ;; on nettoie le champ `info'
		    (global-info-set! pr '())
		    (loop (cdr tree) (cons pr new-tree)))
		 (begin
		    (unbind-in-global-environment! (global-name pr) *Genv*)
		    (loop (cdr tree) new-tree)))))))
	  
;*---------------------------------------------------------------------*/
;*    find-export-in-Genv ...                                          */
;*    -------------------------------------------------------------    */
;*    On parcour tout l'environnement pour rechercher toutes les       */
;*    fonctions exportees qui vont nous servir de racine dans la       */
;*    recherche de la liste des fonctions atteignables. Par defaut     */
;*    toute fonction exportee est atteignable.                         */
;*---------------------------------------------------------------------*/
(define (find-export-in-Genv)
   (let ((res '()))
      (define (on-bucket! bucket)
	 (if (null? bucket)
	     'done
	     (let ((pr (car bucket)))
		(if (or (eq? (global-import pr) 'export)
			(eq? (global-import pr) 'top-level)
			(and (eq? (global-import pr) 'static)
			     (eq? (global-class pr)  'variable)))
		    (begin
		       (use-global! pr)
		       (set! res (cons pr res)))
		    (unuse-global! pr))
		(on-bucket! (cdr bucket)))))
      (walk-on-hash-table! on-bucket! *Genv* 'Genv)
      res))

;*---------------------------------------------------------------------*/
;*    use-global! ...                                                  */
;*---------------------------------------------------------------------*/
(define (use-global! g)
   (global-info-set! g #t))

;*---------------------------------------------------------------------*/
;*    unuse-global! ...                                                */
;*---------------------------------------------------------------------*/
(define (unuse-global! g)
   (global-info-set! g #f))
