;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../property.scm ...                                             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 29 11:01:40 1993                          */
;*    Last change :  Mon Nov 15 14:29:16 1993 (serrano)                */
;*                                                                     */
;*    Les fonctions font-elles des effets de bords ?                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le modue                                                         */
;*---------------------------------------------------------------------*/
(module effect_property
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Effect/effect.sch")
   (import  var_pragma
	    tools_shape)
   (export  (mutation?    exp)
	    (mutable?     exp)
	    (side-effect? exp)))

;*---------------------------------------------------------------------*/
;*    effect-mutation? ...                                             */
;*---------------------------------------------------------------------*/
(define (effect-mutation? function)
   (or (not (effect? (function-property function)))
       (effect-mutator (function-property function))))

;*---------------------------------------------------------------------*/
;*    effect-seter? ...                                                */
;*---------------------------------------------------------------------*/
(define (effect-seter? function)
   (or (not (effect? (function-property function)))
       (effect-seter (function-property function))))

;*---------------------------------------------------------------------*/
;*    mutation? ...                                                    */
;*    -------------------------------------------------------------    */
;*    Une expression mute-t-elle son argument                          */
;*---------------------------------------------------------------------*/
(define (mutation? exp)
   (define (map-mutation? exp)
      (if (null? exp)
	  #f
	  (if (mutation? (car exp))
	      #t
	      (map-mutation? (cdr exp)))))
   (cond
      ((not (pair? exp))
       #f)
      ((eq? (car exp) 'quote)
       #f)
      ((local? (car exp))
       (if (not (eq? (local-class (car exp)) 'function))
	   #t
	   (if (not (effect-mutation? (local-value (car exp))))
	       (map-mutation? (cdr exp))
	       #t)))
      ((global? (car exp))
       (if (and (not (eq? (global-class (car exp)) 'function))
		(not (eq? (global-class (car exp)) 'foreign)))
	   #t
	   (if (or (pragma-no-mutation? (car exp))
		   (and (function? (global-value (car exp)))
			(not (effect-mutation? (global-value (car exp))))))
	       (map-mutation? (cdr exp))
	       #t)))
      (else
       ;; toujours pour etre tres conservatif on dit ici que toutes
       ;; les formes speciales font des mutation. Si on veut faire
       ;; mieux, il faut bien faire attention a ne pas oublier de cas
       ;; comme funcall, apply, return-from, ...
       #t)))

;*---------------------------------------------------------------------*/
;*    mutable? ...                                                     */
;*    -------------------------------------------------------------    */
;*    Le resultat d'une expression peut-il etre mute ?                 */
;*---------------------------------------------------------------------*/
(define (mutable? exp)
   (cond
      ((not (pair? exp))
       (or (local? exp) (global? exp)))
      ((eq? (car exp) 'quote)
       #t)
      ((local? (car exp))
       #t)
      ((global? (car exp))
       (if (and (not (eq? (global-class (car exp)) 'function))
		(not (eq? (global-class (car exp)) 'foreign)))
	   #t
	   (not (pragma-imutable? (car exp)))))
      (else
       #t)))

;*---------------------------------------------------------------------*/
;*    side-effect? ...                                                 */
;*---------------------------------------------------------------------*/
(define (side-effect? exp)
   (define (map-side-effect? exp)
      (if (null? exp)
	  #f
	  (if (side-effect? (car exp))
	      #t
	      (map-side-effect? (cdr exp)))))
   (cond
      ((not (pair? exp))
       (cond
	  ((local? exp)
	   (eq? (local-access exp) 'write))
	  ((global? exp)
	   #t)
	  (else
	   #f)))
      ((eq? (car exp) 'quote)
       #f)
      ((eq? (car exp) 'pragma)
       #f)
      ((eq? (car exp) 'cif)
       (let ((si (cadr exp))
	     (alors (caddr exp))
	     (sinon (cadddr exp)))
	  (cond
	     ((side-effect? si)
	      #t)
	     ((side-effect? alors)
	      #t)
	     ((side-effect? sinon)
	      #t)
	     (else
	      #f))))
      ((local? (car exp))
       (if (not (eq? (local-class (car exp)) 'function))
	   #t
	   (if (not (effect-seter? (local-value (car exp))))
	       (map-side-effect? (cdr exp))
	       #t)))
      ((global? (car exp))
       (if (and (not (eq? (global-class (car exp)) 'function))
		(not (eq? (global-class (car exp)) 'foreign)))
	   #t
	   (if (or (pragma-no-side-effect? (car exp))
		   (and (function? (global-value (car exp)))
			(not (effect-seter? (global-value (car exp))))))
	       (map-side-effect? (cdr exp))
	       #t)))
      (else
       #t)))
