;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Cnst/module.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  9 15:00:17 1993                          */
;*    Last change :  Fri Nov 26 15:48:22 1993 (serrano)                */
;*                                                                     */
;*    L'initialisation des modules                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_module
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    tools_hash
	    tools_shape
	    tools_module
	    tools_error
	    var_declare
	    var_env)
   (export  (modules-initialisation)
	    (init-cnst-module)
	    (remember-module! module)))

;*---------------------------------------------------------------------*/
;*    L'environment                                                    */
;*---------------------------------------------------------------------*/
(define *module-env*         '())
(define *ordered-module*     '())
(define *local-used-modules* '())

;*---------------------------------------------------------------------*/
;*    init-cnst-module ...                                             */
;*---------------------------------------------------------------------*/
(define (init-cnst-module)
   (trace cnst
	  "*order-init-modules*: " (shape *order-init-modules*) #\Newline
	  "*used-modules*      : " (shape *used-modules*) #\Newline)
   (let ((id (lambda (l) l)))
      (set! *module-env* (make-hash-table 'module
					  'symbol
					  id
					  id
					  id))
      (set! *ordered-module*     (map remember-module! *order-init-modules*))
      (set! *local-used-modules* (map remember-module! *used-modules*))))

;*---------------------------------------------------------------------*/
;*    remember-module! ...                                             */
;*---------------------------------------------------------------------*/
(define (remember-module! module-name)
   (trace cnst "remember-module: " module-name #\Newline)
   (if (and (not (eq? module-name 'top-level))
            (not (eq? module-name *module-name*)))
       (let ((old (find-object module-name *module-env* 'module)))
	  (if (not old)
	      (bind-object! module-name *module-env* 'module)
	      old))))

;*---------------------------------------------------------------------*/
;*    modules-initialisation ...                                       */
;*---------------------------------------------------------------------*/
(define (modules-initialisation)
   (let* ((res '())
	  (proc (lambda (bucket)
		   (let loop ((bucket bucket)
			      (aux    '()))
		      (if (null? bucket)
			  (set! res (append aux res))
			  (let ((init (find-in-global-environment
				       (module-init-name (car bucket))
				       *Genv*)))
			     (if (not (global? init))
				 (partial-error
				  "nowhere"
				  "Unbound module initialisation"
				  (module-init-name (car bucket)))
				 (if (or (memq (car bucket) *ordered-module*)
					 (memq (car bucket)
					       *local-used-modules*))
				     (loop (cdr bucket)
					   aux)
				     (loop (cdr bucket)
					   (cons (list init)
						 aux))))))))))
      (walk-on-hash-table! proc *module-env* 'module)
      (append res (map (lambda (m)
			  (list (find-in-global-environment
				 (module-init-name m)
				*Genv*)))
		       *ordered-module*))))

