;*              Copyright 1992 Digital Equipment Corporation
;*                         All Rights Reserved
;*
;* Permission to use, copy, and modify this software and its documentation is
;* hereby granted only under the following terms and conditions.  Both the
;* above copyright notice and this permission notice must appear in all copies
;* of the software, derivative works or modified versions, and any portions
;* thereof, and both notices must appear in supporting documentation.
;*
;* Users of this software agree to the terms and conditions set forth herein,
;* and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
;* right and license under any changes, enhancements or extensions made to the
;* core functions of the software, including but not limited to those affording
;* compatibility with other hardware or software environments, but excluding
;* applications which incorporate this software.  Users further agree to use
;* their best efforts to return to Digital any such changes, enhancements or
;* extensions that they make and inform Digital of noteworthy uses of this
;* software.  Correspondence should be provided to Digital at:
;*
;*			Director, Cambridge Research Lab
;*			Digital Equipment Corp
;*			One Kendall Square, Bldg 700
;*			Cambridge MA 02139
;*
;* This software may be distributed (but not offered for sale or transferred
;* for compensation) to third parties, provided such third parties agree to
;* abide by the terms and conditions of this notice.
;*
;* THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
;* WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
;* MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
;* CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
;* DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;* PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
;* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
;* SOFTWARE.

; $Id: $

;;; Use a package called (BOB), but also keep a list of known module
;;; variables in !thomas-rep-module-variables in that environment.
;;; (It's called !thomas-rep-module-variables because we're using
;;; thomas-eval.)

(define (empty-bob-environment!)
  (let ((package (name->package '(BOB)))
	(parent (name->package '()))
	(set-package/children!
	 (environment-lookup (->environment '(package))
			     'set-package/children!)))
    (set-package/children! parent
      (delq! package (package/children parent)))
    (package/add-child! parent 'BOB
			(let ((!THOMAS-REP-MODULE-VARIABLES '()))
			  (the-environment)))
    (for-each (lambda (expr) (thomas-eval expr (->environment '(BOB))))
	      bob-preamble)
    unspecific))

(define (bob-rep)
  (cmdl/start
   (make-cmdl
    (nearest-cmdl)			; parent
    (nearest-cmdl/port)			; port
    bob-rep/cmdl-driver			; driver
    false				; state
    '()					; operations
    )
   (cmdl-message/active			; message
    (lambda (port)
      (let ((n-names
	     (length (environment-bindings (->environment '(BOB))))))
	(newline port)
	(display "Entering Bob" port)
	(newline port)
	(display "(There " port)
	(display (if (= n-names 1) "is" "are") port)
	(display " now " port)
	(display n-names port)
	(display " defined name" port)
	(display (if (= n-names 1) "" "s") port)
	(display " available.)" port)
	(newline port)
	(display "Lines will be read but not parsed until a blank line
indicates the end of a valid statement." port)
	(newline port))))))

(define (bob-rep/cmdl-driver cmdl)
  ;; This will not work for CMDL's in a Scheme running in an Edwin
  ;; inferior-repl mode buffer.
  (thomas-eval
   (expr->dylan (bob-rep/prompt-for-expression
		 (cmdl/port cmdl)
		 (string-append (number->string (cmdl/level cmdl)) " ?")))
   (->environment '(BOB)))
  (bob-rep/cmdl-driver cmdl))

(define bob-rep/prompt-for-expression
  ;; Kludge this to support Scheme under Emacs or a terminal.
  ;; There's no good fix for Scheme in an Edwin inferior-repl.
  (let ((under-emacs? (make-primitive-procedure 'under-emacs? 0))
	(transmit-signal-with-argument
	 (environment-lookup (->environment '(runtime emacs-interface))
			     'transmit-signal-with-argument))
	(transmit-signal
	 (environment-lookup (->environment '(runtime emacs-interface))
			     'transmit-signal)))
    (lambda (port prompt)
      (if (under-emacs?)
	  (begin
	    (transmit-signal-with-argument
	     port #\p
	     (string-append (number->string (cmdl/level (nearest-cmdl)))
			    " [Bob]"))
	    (transmit-signal port #\R)
	    (bob (read-lines (lambda () (read-line port)))
		 bob-rep/parse-error))
	  (begin
	    (newline)
	    (bob (read-lines (lambda ()
			       (port/with-output-terminal-mode
				port 'COOKED
				(lambda ()
				  (write-string prompt port)
				  (write-string " " port)
				  (flush-output port)))
			       (port/with-input-terminal-mode
				port 'COOKED
				(lambda () (read-line port)))))
		 bob-rep/parse-error))))))

(define (bob-rep/parse-error input-string input-offset . error-args)
  (let* ((length (string-length input-string))
	 (bol (let loop ((i (-1+ input-offset)))
		(if (or (negative? i)
			(and (< i length)
			     (char=? #\newline (string-ref input-string i))))
		    (1+ i)
		    (loop (-1+ i)))))
	 (line (substring input-string
			  bol
			  (let loop
			      ((eol input-offset))
			    (if (or (= eol length)
				    (char=? #\newline
					    (string-ref input-string eol)))
				eol
				(loop (1+ eol)))))))
    (newline)
    (write-string line)
    (newline)
    (write-string (let ((offset (- input-offset bol)))
		    (let loop ((i 0))
		      (if (= i offset)
			  (substring line 0 offset)
			  (begin
			    (if (not (char-whitespace? (string-ref line i)))
				(string-set! line i #\space))
			    (loop (1+ i)))))))
    (write-char #\^)
    (apply error error-args)))

(define (read-lines read-line)
  (let loop ((lines '()))
    (let ((line (read-line)))
      (if (and (= 1 (string-length line))
	       (char=? #\newline (string-ref line 0)))
	  (apply string-append (reverse! lines))
	  (loop (cons line lines))))))

(define (read-line port)
  (let loop ((line '()))
    (let ((char (read-char port)))
      (if (eqv? char #\newline)
	  (list->string (reverse! (cons char line)))
	  (loop (cons char line))))))

(empty-bob-environment!)

(display "\nApply bob-rep to start a Bob read-eval-print loop.\n")

