;;; defining-forms.s

;;; basic macros for typechecking system:  
;;; define-unchecked, define-checked, define-type-abbrev,
;;; declare-unchecked

;;; changed check-define-checked to return #f instead of () on error.
;;; Thu Mar 25 14:32:06 1993.

;;; rewritten to use extend-syntax Thu Nov 10 14:56:38 1988
;;; Also define-checked produces name and type as its output.

;;; extracted from old distribution/check1.s (was not on margaret's
;;; version).  Sun Nov  6 22:49:07 1988

(extend-syntax (define-unchecked)
  [(define-unchecked name type value)
   (with ([type-scheme (external-type->type-scheme 'type)])
     (begin
       (change-global-prefix! 'name 'type-scheme)
;   (add-undefined-types-to-badlist ',type ',generics)
       (set! name value)
       (list 'name ': 'type)))])

(extend-syntax (declare-unchecked)
  [(declare-unchecked name generics type)
   (begin
     (change-global-prefix! 'name (make-type-scheme 'generics 'type))
     ;(add-undefined-types-to-badlist ',(cadddr l) ',(caddr l))
     'name)])



(extend-syntax (define-type-abbrev)
  [(define-type-abbrev name type-exp)
   (begin
     (extend-global-type-env! 'name 'type-exp)
;    (bind-typevar ',name ',type-exp ',l global-type-env)
;    (check-type-abbrev ',name ',type-exp)
     'name)])


(extend-syntax (define-checked)
  [(define-checked name type value)
   (with ((type-scheme (external-type->type-scheme 'type)))
     (with ((ans (check-define-checked 'name 'type-scheme 'value)))
       (if 'ans
	 (begin
	   (change-global-prefix! 'name 'type-scheme)
	   ;;(add-undefined-types-to-badlist....)
	   (set! name value)
	   (printf "~s : ~s~%" 'name 'type))
	 (reset))))])

;;; the following code is OK, except it needs to check the type-scheme
;;; for unbound type variables not included in the list of generics.

(define check-define-checked
  (lambda (name type-scheme value)
    (call/cc
      (lambda (return)
	(let ((generics (type-scheme->generics type-scheme))
	      (type     (type-scheme->type type-scheme))
	      (dummy    (gen-fcn-sym)))
	  ;;(add-undefined-types-to-badlist type generics)
	  (checker
	    (ext-prefix
	      (list name dummy)
	      (list 
		type-scheme
		(make-type-scheme
		  '()
		  (make-functional-type
		    (list (subst-consts-for-generics type-scheme))
		    (gen-type-var))))
	      empty-prefix)
	    (make-application dummy (list value))
	    empty-type-env
	    (lambda (msg)
	      (printf "define-checked: error in ~s:~%" name)
	      (pretty-print msg)
	      (return #f))))))))


