;;; -*- Base: 10; Mode: Scheme; Syntax: MIT Scheme; Package: USER -*-
;;
;; BSORT.SCM
;;
;; July 25, 1991
;; Minghsun Liu
;;
;; Implement CL-SORT using bubble sort.
;;

;;
;; Same as the CL-SORT in sequence.scm but uses the bubble sort function
;; below instead of the built-in ones in MIT Scheme. (Q-SORT??)
;;
(define (cl-sort seq pred #!rest keyword)
  (let ((keyfnc '()))
    (define (process-keyword)
      (if (not (null? keyword))
          (if (eq? (car keyword) :key)
              (set! keyfnc (cadr keyword))
              (error "CL-SORT: unknown keyword" keyword))))
    (define (get-predicate)
      (if keyfnc
          (lambda (x y)
            (let ((a (keyfnc x))
                  (b (keyfnc y)))
              (or (pred a b)
                  (equal? a b))))
          (lambda (x y)
            (or (pred a b) (equal? a b)))))
    (process-keyword)
    (cond ((array? seq)
           (list->vector
		(bsort (vector->list (just-the-array-maam seq)) (get-predicate))))
          ((string? seq)
           (set! seq (string->list seq))
           (list->string (bsort seq (get-predicate))))
          ((vector? seq)
           (list->vector (bsort (vector->list seq) (get-predicate))))
          ((list? seq)
           (bsort seq (get-predicate)))
          (else (error "CL-SORT: Not a sequence" seq)))))

;;
;; (BSORT LIST)
;;
;; sorts a list using bubble sort.
;;
(define (bsort list-to-sort pred)
  (let ((max (-1+ (length list-to-sort)))
	(index 0)
	(temp '()))
    (define (bsort-aux cur-list)
      (cond ((= max 0) 
	     list-to-sort)
	    ((= index max)
	     (set! index 0)
	     (set! max (-1+ max))
	     (bsort-aux list-to-sort))
	    ((not (pred (car cur-list) (cadr cur-list)))
	     (set! temp (car cur-list))
	     (set-car! cur-list (cadr cur-list))
	     (set-car! (cdr cur-list) temp)
	     (set! index (1+ index))
	     (bsort-aux (cdr cur-list)))
	    (else
	     (set! index (1+ index))
	     (bsort-aux (cdr cur-list)))))
    (if (null? list-to-sort)
	'()
	(bsort-aux list-to-sort))))
