;;
;; programs
;;

(module program)
(include "cw.sch")

(define (make-program name start text code)
  (vector 'program	;; just a header
	  name		;; name of the program
	  1		;; number of pc's
	  0		;; which pc are we running now
	  (list start)	;; list of pc's
	  text          ;; program text
	  code))	;; and the program code

(define (next-pc! p)
  (vector-set! p 3 (inc (current-pc-number p)))
  (if (= (current-pc-number p) (number-of-pcs p))
      (vector-set! p 3 0)))

(define (abort-current-program! p)
  (cond ((= 1 (number-of-pcs p))
	 (vector-set! p 4 '())
	 (vector-set! p 2 0)
	 #f)
	(else
	 (let ((pcn-to-kill (current-pc-number p)))
	   (vector-set! p 4
			(delete-nth (pc-list p)
				    pcn-to-kill))
	   (if (= pcn-to-kill (- (number-of-pcs p) 1))
	       (vector-set! p 3 0))
	   (vector-set! p 2 (dec (vector-ref p 2)))
	   #t))))

(define (set-current-pc! p to)
  (replace-nth! (pc-list p) (current-pc-number p) to))

(define (inc-current-pc! p)
  (set-current-pc! p (scale-to-core (inc (current-pc p)))))

(define (add-pc! p pc)
  (vector-set! p 4 (cons pc (pc-list p)))
  (vector-set! p 2 (inc (number-of-pcs p)))
  (next-pc! p))

(define (print-program p)
  (define (helper text)
    (cond ((null? text) '())
	  ((label? (car text))
	   (display (car text)) (display " ") (helper (cdr text)))
	  (else
	   (display (car text)) (newline) (helper (cdr text)))))
  (display "Program ") (display (program-name p)) (newline)
  (helper (program-text p)))
