;;
;; gen-print.scm
;;
;; Generic handler for printing the execution of an instruction.
;;

(module printer)

(define (mode->string m) (vector-ref '#("+" "^" "%" "<") m))

(define (print-operand m o)
  (format #t " ~s ~s" (mode->string m) o))

(define (verbose-print-execution round p i
				 mode-a op-a effective-a
				 mode-b op-b effective-b)
  (if (zero? (cdr (assq (program-name p) *the-programs*)))
      (newline))
  
  (format #t "~s[~s] ~s: ~s" (program-name p) (current-pc-number p)
	  (current-pc p) (i 'name))
  (if (> (i 'n-ops) 0)
      (print-operand mode-a op-a))
  (if (> (i 'n-ops) 1)
      (print-operand mode-b op-b))
  (display #\tab)
  (if *single-stepping*
      (begin
	(display "hit any key to continue: ")
	(read-char)
	(newline))))

(define *the-programs* #f)
(define *single-stepping* #f)

(define (verbose-display-init programs)
  (let ((index 0))
    (set! *the-programs*
	  (map (lambda (p)
		 (let ((new-car (cons (program-name p) index)))
		   (set! index (inc index))
		   new-car))
	       programs))))
