; -*- Scheme -*-
;
; $Id$

(require 'string:test:equal)
(require 'string:translate)

(define string:test:translate
  (lambda ()
    
    (string:test:equal
     'string:translate-a
     (string:translate "bevan" "aeiou" "+%#@&")
     "b%v+n")

    (string:test:equal
     'string:translate-b
     (string:translate "bevan" "aeiou" "*****")
     "b*v*n")

    (string:test:equal
     'string:translate-c 
     (string:translate "654321" "123456" "quotas")
     "satouq")

    (string:test:equal 
     'string:translate-d 
     (string:translate "124578" "12345678" "03:56:42")
     "035642")

    (string:test:equal
     'string:translate-e
     (string:translate "124578" "12345678" "03:56:42")
     "035642")

    (string:test:equal
     'string:translate-f 
     (string:translate "hxmysz" "hx:my:sz" "03:56:42")
     "035642")

    (string:test:equal
     'string:translate-g
     (string:translate "hx:my:sz" "hxmysz" "035642")
     "03:56:42")

    (string:test:equal
     'string:translate-h
     (string:translate "123321" "123" "-*|")
     "-*||*-")

    ))

; eof

