; -*- Scheme -*-
;
; $Id: string28.scm,v 1.1 1993/08/28 12:24:19 bevan Exp $

(require 'substring:replicate!)
(require 'substring:copy!)

;+doc
; procedure: substring:pad-left!
; arguments: source  source-start  source-end
;            padding padding-start padding-end
;            result  result-start  result-end
; signature: string x int x int x string x int x int x string x int x int
;         -> unspecified
; pre:       (and (not (eq? source result)) (not (eq? padding result))
;                 (<= 0 source-start source-end (string-length source))
;                 (<= 0 padding-start padding-end (string-length padding))
;                 (<= 0 result-start result-end (string-length result))
;                 (<= (- source-end source-start) (- result-end result-start)))
;
; Modifies RESULT such that the section from RESULT-START (inclusive)
; to RESULT-END (exclusive) consists of the characters in SOURCE from
; SOURCE-START (inclusive) to SOURCE-END (exclusive) padded on the
; left with copies of PADDING from PADDING-START (inclusive) to
; PADDING-END (exclusive)
;-doc

(define substring:pad-left!
  (lambda (s ss se p ps pe r rs re)
    (let* ((sl (- se ss)) (lc (- re sl)))
      (substring:replicate! r rs lc p ps (min (+ ps (- lc rs)) pe))
      (substring:copy! s ss se r lc))))

; eof
