; -*- Scheme -*-
;
; $Id: string18.scm,v 1.1 1993/08/28 12:22:38 bevan Exp $

(require 'substring:copy!)

;+doc
; procedure: substring:center!
; arguments: source source-start source-end result result-start result-end
; signature: string x int x int x string x int x int -> unspecified
; pre:       (and (not (eq? source result)) (not (eq? padding result))
;                 (<= 0 source-start source-end (string-length source))
;                 (<= 0 result-start result-end (string-length result))
;                 (<= (- source-end source-start) (- result-end result-start)))
;
; Modifies RESULT such that the characters in SOURCE between
; SOURCE-START (inclusive) and SOURCE-END (exclusive) are centered
; between RESULT-START and RESULT-END.
;
; > (define r "pqrstuv")
; > (substring:center! "abc" 0 3 r 0 7)
; > r
; "pqabcuv"
;-doc

(define substring:center!
  (lambda (s ss se r rs re)
    (substring:copy! s ss se r (+ rs (quotient (- (- re rs) (- se ss)) 2)))))

;+spec
; +--substring:center---
; | source?, result!: Scheme-String
; | source-start?, source-end?, result-start?, result-end?: Z
; +---------------------
; | 0 <= source-start? <= source-end? <= len source? 
; | 0 <= result-start? <= result-end? <= len result!
; | source-end? - source-start? <= result-end? - result-start?
; | result! = source? for source-start?
; |        '` source ; take source-end? ; drop source-start?
; |        '` source after source-end?
; +---------------------
;
; Is it correct?
;-spec

; eof
