; -*- Scheme -*-
;
; $Id: string17.scm,v 1.2 1993/10/22 11:06:06 bevan Exp $

(require 'string:copy)
(require 'substring:downcase!)
(require 'string:downcase!)

;+doc
; procedure: substring:downcase
; arguments: string start end
; signature: string x int x int -> string
; pre:       (<= 0 start end (string-length string))
;
; Returns a copy of STRING with every case-modifiable character
; betweeen START (inclusive) and END (exclusive) is coverted to
; lowercase. 
;
; > (substring:downcase "occlUDed cASEmenTs" 0 18)
; "occluded casements"
;
; > (substring:downcase "occlUDed cASEmenTs" 5 18)
; "occlUded casements"
;
; > (substring:downcase "occlUDed cASEmenTs" 5 15)
; "occlUded casemenTs"
;-doc

(define substring:downcase
  (lambda (s ss se)
    (let ((r (string:copy s)))
      (substring:downcase! r ss se)
      r)))

; Cheap hack, should rewrite so that it creates an empty string and
; then ships the characters over one by one.

;------------

;+doc
; procedure: string:downcase
; arguments: string
; signature: string -> string
;
; Returns a copy of STRING with every case-modifiable character
; betweeen START and END is coverted to lowercase.
;
; > (substring:downcase "occlUDed cASEmenTs")
; "occluded casements"
;-doc

(define string:downcase
  (lambda (s)
    (let ((r (string:copy s)))
      (string:downcase! r)
      r)))

; eof
