; -*- Scheme -*-
;
; $Id: string08.scm,v 1.1 1993/08/28 12:20:17 bevan Exp $
;

(require 'substring:replicate!)

;+doc
; procedure: substring:replicate
; arguments: string start end size
; signature: string x int x int x int -> string
; pre:       (and (< start end) (<= end (string-length string)))
;
; Generate a string which is SIZE chars long consisting on STRING from
; START (inclusive) to END (exclusive) repeated enough times so that
; it fills the string.
;
; > (substring:replicate "abc" 0 3 10)
; "abcabcabca"
; > (substring:replicate "abc" 0 3 1)
; "a"
; > (substring:replicate "abc" 0 3 0)
; ""
; > (substring:replicate ""    0 0 1)
; ""
;-doc

(define substring:replicate
  (lambda (source start end size)
    (if (zero? (- end start))
	""
	(let ((r (make-string size)))
	  (substring:replicate! r 0 size source start end)
	  r))))

;+spec
; +-- substring:replicate -------
; | in?, out!    : Scheme-String
; | start?, end? : Z
; | size?        : Z
; +------------------------------
; | start? < end? <= len in? 
; | out! = ((in?'`)^(size?/(end?-start?)) in?) for size?
; +------------------------------
;
; '` = curried concatentation, a^b = applies relation a, b times.
;
; XXX check this is a) valid Z b) a correct spec.
;-spec

;------------

;+doc
; procedure: string:replicate
; arguments: string size
; signature: string x int -> string
;
; Generate a string which is SIZE chars long consisting on STRING
; repeated enough times so that it fills the string.
;
; > (string:replicate "abc" 10)
; "abcabcabca"
; > (string:replicate "abc" 1)
; "a"
; > (string:replicate "abc" 0)
; ""
; > (string:replicate ""    1)
; ""
;-doc

(define string:replicate
  (lambda (source size)
    (let ((sl (string-length source)))
      (if (zero? sl)
	  source
	  (substring:replicate source 0 sl size)))))

;+spec
; +-- string:replicate -------
; | in?, out! : Scheme-String
; | size?     : Z
; +------------------------------
; | out! = ((in?'`)^(size?/len in?) in?) for size?
; +------------------------------
;
; '` = curried concatentation, a^b = applies relation a, b times.
;
; XXX check this is a) valid Z b) a correct spec.
;-spec

; eof
