#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Premise Computation

(declare (usual-integrations)
	 (integrate-external "struct"))

(define *defaults*)
(define *parameters*)
(define *assumptions*)
(define *trees*)
(define *links*)

(define (cell/premises cell)
  (fluid-let ((*defaults* '())
	      (*parameters* '())
	      (*assumptions* '())
	      (*trees* '())
	      (*links* '()))
    (let ((defaults (premises/walk-cell cell)))
      (premises/unmark! cell)
      (values *defaults*
	      *parameters*
	      *assumptions*
	      (if (or (eq? defaults 'PARAMETER-OR-ASSUMPTION-SEEN)
		      (null? defaults))
		  *trees*
		  (cons (if (null? (cdr defaults)) (car defaults) cell)
			*trees*))
	      *links*))))

(define (cells/premises cells)
  (fluid-let ((*defaults* '())
	      (*parameters* '())
	      (*assumptions* '())
	      (*trees* '())
	      (*links* '()))
    (let ((defaults (premises/walk-cells cells)))
      (for-each premises/unmark! cells)
      (values *defaults*
	      *parameters*
	      *assumptions*
	      (if (eq? defaults 'PARAMETER-OR-ASSUMPTION-SEEN)
		  *trees*
		  (if (< (length defaults) (length cells))
		      defaults
		      cells))
	      *links*))))

(define (premises/unmark! cell)
  (let ((supplier (cell/true-supplier cell)))
    (if (not (eq? (cell/mark supplier) 'UNMARKED))
	(begin
	  (set-cell/mark! supplier 'UNMARKED)
	  (for-each premises/unmark! (cell/inputs supplier))))))

(define (premises/walk-cell cell)
  (if (node/bound? cell)
      (let ((supplier (cell/true-supplier cell)))
	(case (cell/mark supplier)
	  ((UNMARKED)
	   (set-cell/mark! supplier 'MARKING)
	   (set! *links* (append! (premises/links cell supplier) *links*))
	   (set-cell/mark! supplier (premises/check-rule supplier)))
	  ((MARKING)
	   (error "circular dependency at" supplier)))
	(cell/mark supplier))
      '()))

(define (premises/links x y)
  (let x-loop ((c x) (x-links '()))
    (if (cell/link c)
	(if (eq? c y)
	    x-links
	    (let ((link (cell/link c)))
	      (x-loop link (cons (cons c link) x-links))))
	(let y-loop ((c y) (y-links '()))
	  (if (cell/link c)
	      (if (eq? c x)
		  y-links
		  (let ((link (cell/link c)))
		    (y-loop link (cons (cons c link) y-links))))
	      (append! x-links y-links))))))

(define (premises/check-rule cell)
  (let ((rule (cell/rule cell)))
    (cond ((rule/constant? rule)
	   '())
	  ((rule/default? rule)
	   (set! *defaults* (cons cell *defaults*))
	   (list cell))
	  ((rule/parameter? rule)
	   (set! *parameters* (cons cell *parameters*))
	   'PARAMETER-OR-ASSUMPTION-SEEN)
	  ((rule/assumption? rule)
	   (set! *assumptions* (cons cell *assumptions*))
	   'PARAMETER-OR-ASSUMPTION-SEEN)
	  (else
	   (premises/walk-cells (cell/inputs cell))))))

(define (premises/walk-cells cells)
  (let ((results (map premises/walk-cell cells)))
    (if (memq 'PARAMETER-OR-ASSUMPTION-SEEN results)
	(begin
	  (set! *trees*
		(append! (premises/default-trees cells results)
			 *trees*))
	  'PARAMETER-OR-ASSUMPTION-SEEN)
	(reduce unionq '() results))))

(define (premises/default-trees cells results)
  (let loop ((cells cells) (results results) (trees '()) (defaults '()))
    (cond ((null? cells)
	   (if (< (length defaults) (length trees)) defaults trees))
	  ((eq? 'PARAMETER-OR-ASSUMPTION-SEEN (car results))
	   (loop (cdr cells) (cdr results) trees defaults))
	  (else
	   (loop (cdr cells)
		 (cdr results)
		 (cons (car cells) trees)
		 (unionq (car results) defaults))))))

(define (desired-premises cell)
  (let ((premises (desired-premises/mark cell)))
    (let loop ((cell cell))
      (if (not (eq? (cell/mark cell) 'UNMARKED))
	  (begin
	    (set-cell/mark! cell 'UNMARKED)
	    (for-each (lambda (cell)
			(let ((constraint (cell/owner cell)))
			  (if constraint
			      (for-each-vector-element
				  (constraint/cells constraint)
				loop))))
		      (node/cells cell)))))
    premises))

(define (desired-premises/mark cell)
  (if (and (not (node/bound? cell))
	   (eq? (cell/mark cell) 'UNMARKED))
      (begin
	(set-cell/mark! cell 'MARKED)
	(let loop ((cells (node/cells cell)) (premises '()))
	  (if (null? cells)
	      premises
	      (loop (cdr cells)
		    (append! (let ((cell (car cells)))
			       (if (cell/owner cell)
				   (if (cell/global? cell)
				       (list cell)
				       '())
				   (desired-premises/constraint cell)))
			     premises)))))
      '()))

(define (desired-premises/constraint cell)
  (let ((constraint (cell/owner cell)))
    (let ((cells (constraint/cells constraint)))
      (let rule-loop
	  ((rules
	    (vector-ref
	     (constraint-type/forget-rules (constraint/type constraint))
	     (cell/name cell)))
	   (premises '()))
	(if (null? rules)
	    premises
	    (let inputs-loop
		((inputs (rule/inputs (car rules)))
		 (premises premises))
	      (if (null? premises)
		  (rule-loop (cdr rules) premises)
		  (inputs-loop
		   (cdr inputs)
		   (append!
		    (desired-premises/mark (vector-ref cells (car inputs)))
		    premises)))))))))