DisplayObject subclass: #FaceModel
	instanceVariableNames: 'contents location '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Face-demo'!


!FaceModel methodsFor: 'private'!

setContents: aFace location: aLocation
	contents _ aFace.
	location _ aLocation! !

!FaceModel methodsFor: 'display'!

displayOn: destForm at: aDisplayPoint clippingBox: aClipRectangle rule: aRuleInteger mask: aForm
 	^ contents displayOn: destForm at: aDisplayPoint+location  clippingBox: aClipRectangle rule: aRuleInteger mask: aForm! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FaceModel class
	instanceVariableNames: ''!


!FaceModel class methodsFor: 'creation'!

contents: aFace location: aLocation
	^ self new setContents: aFace location: aLocation! !

DisplayObject subclass: #FaceWindow
	instanceVariableNames: 'instVarName1 instVarName2 '
	classVariableNames: 'ClassVarName1 ClassVarName2 '
	poolDictionaries: ''
	category: 'Face-demo'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FaceWindow class
	instanceVariableNames: ''!


!FaceWindow class methodsFor: 'examples'!

example  
	"FaceWindow example"
	
	| form1 form2 pen formRect f oRect |
	oRect _ Rectangle fromUser.
	formRect_ 0@0 extent: 50@50.
	pen _ Pen new.
	pen defaultNib: 2.
	form1 _ SequenceNode subNodes: ((1 to: 5) collect:
		[:n | 
		Display fill: formRect mask: Form white.
		pen north; turn: 72/6*n; place: formRect center; spiral: 45 angle: 144.
		OpaqueForm shape: (Form fromDisplay: formRect)]).
	pen defaultNib: 8; north.
	Display fill: formRect mask: Form white.
	pen place: 4@27.
	1 to: 36 do: [:n | pen go: Float pi*2*20/36; turn: 10].
	f_ Form fromDisplay: formRect.
	Display fill: formRect mask: Form white.
	pen place: 4@27; mask: Form lightGray.
	1 to: 36 do: [:n | pen go: Float pi*2*20/36; turn: 10].
	form2 _ OpaqueForm figure: (Form fromDisplay: formRect) shape: f.
	Display fill: formRect mask: Form gray.
	self run: (WindowNode
		window: (0@0 extent: oRect extent)
		contents: (SuperpositionNode subNodes: (Array
			with: (BounceInBoxNode
				contents: (EvaluationNode block:
					[(Form fromDisplay: (Sensor mousePoint extent: 50@50)) borderWidth: 2])
				location: 20@0 velocity: 1@1)
		with: (BounceInBoxNode contents: form1 location: 20@0 velocity: 2@3)
		with: (BounceInBoxNode contents: form2 location: 0@0 velocity: 3@3)
		))) at: oRect origin!

show: aFace at: aPoint
	| view |
	view _ FormView new model: aFace.
	view borderWidth: 2.
	view translateBy: aPoint.
	view display.
	Cursor crossHair showWhile: [
		[Sensor anyButtonPressed] whileFalse: [view displayView] ].
	view release! !

!FaceWindow class methodsFor: 'creation'!

window: aView contents: aModel
	^ self new setWindow: aView contents: aModel! !

FaceModel subclass: #Face
	instanceVariableNames: 'center radius contour leftEye rightEye nose mouth '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Face-demo'!


!Face methodsFor: 'display'!

displayOn: aDestForm at: aDisplayPoint clippingBox: aClipRectangle rule: aRuleInteger mask: aForm
	
 	super displayOn: aDestForm at: aDisplayPoint clippingBox: aClipRectangle rule: aRuleInteger mask: aForm.! !

!Face methodsFor: 'initialization'!

defineContour
	| myCircle myForm |
	myForm _ Form new extent: 1@1.
myForm black.
myCircle _ Circle new.
myCircle form: myForm; radius: radius; center: center! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Face class
	instanceVariableNames: 'origin leftEye rightEye nose mouth '!


!Face class methodsFor: 'creation'!

at: aPoint withLeftEye: anEye andRightEye: anotherEye andNose: aNose andMouth: aMouth
	| fred |
	fred _ super new.
fred setContour: aPoint; setLeftEye: anEye; setRightEye: anotherEye; setNose: aNose; setMouth: aMouth.
^fred! !

Object subclass: #Feature
	instanceVariableNames: 'center radius contour '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Face-demo'!


!Feature methodsFor: 'display'!

show
self displayOn: Display! !

!Feature methodsFor: 'initialization'!

setContour
	center _ Sensor waitButton!

setRadius	
	radius _ FillInTheBlank  request: 'What is the radius of this feature ?'! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Feature class
	instanceVariableNames: ''!


!Feature class methodsFor: 'creation'!

at: aPoint withRadius: aNumber
"create a facial feature at a designated point"
| fred |
fred _ self new.
fred setContourAt: aPoint.
fred setRadius: aNumber.
fred defineContour.
^ fred! !

Feature subclass: #Mouth
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Face-demo'!


!Mouth methodsFor: 'initialization'!

defineContour
	|myArc myForm |
	myForm _ Form new extent: 1@1.
myForm black.
myArc _ Arc new.
myArc form: myForm; radius: radius; center: center; quadrant: 2! !

Feature subclass: #Nose
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Face-demo'!


!Nose methodsFor: 'initialization'!

defineContour
	|myArc myForm |
	myForm _ Form new extent: 1@1.
myForm black.
myArc _ Arc new.
myArc form: myForm; radius: radius; center: center; quadrant: 2! !

Feature subclass: #Eye
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Face-demo'!


!Eye methodsFor: 'initialization'!

defineContour
	| myCircle myForm |
	myForm _ Form new extent: 1@1.
myForm black.
myCircle _ Circle new.
myCircle form: myForm; radius: radius; center: center! !