; Test of state functions in search toolbox
;

! (define TestState '(1 2 3 4 5 6 7 8 9))

= (FirstElement TestState) 1

= (RestOfElements TestState) (2 3 4 5 6 7 8 9)

= (FirstElement (RestOfElements TestState)) 2

= (EmptyState? TestState) #f

= (EmptyState? ()) #t

= (FindSymbolInSlot 1 TestState) 1

= (FindSymbolInSlot 3 TestState) 3

= (FindSymbolInSlot 9 TestState) 9

; Next gives error - no 10'th entry
* (FindSymbolInSlot 10 TestState)

= (FindFirstSlotOfSymbol 1 '(1 2 3))
  1

= (FindFirstSlotOfSymbol 3 '(1 2 3))
  3

; Next gives error - no entry 4
* (FindFirstSlotOfSymbol 4 '(1 2 3))


! (define TestState2 (FillSlot 1 'a TestState))

= TestState2 (a 2 3 4 5 6 7 8 9)

! (set! TestState2 (FillSlot 5 'e TestState2))

= TestState2 (a 2 3 4 e 6 7 8 9)

= (FillSlot 9 'i TestState2) (a 2 3 4 e 6 7 8 i)

; Next gives error - no 10'th entry
* (FillSlot 10 'j TestState)
