; ********* Monkey and Banana Problem ***********
; This problem involves a monkey at the door of a room. In
; the middle of the room hangs a banana but the monkey is
; not tall enough to reach it. However there is a box near
; the window of the room that the monkey can push around and
; could stand on to reach the banana. The monkey is hungry,
; can he reach the banana?

(define Monkey-SearchProblem #f)

(define SetUpMonkey
  (lambda ()
    
    ; the state of the system will be represented by a
    ; triple giving:
    ;  1. the monkey's horizontal position:
    ;     one of: atdoor, underbanana, atwindow.
    ;  2. the monkey's vertical position:
    ;     one of: onfloor, onbox.
    ;  3. the box's horizontal position:
    ;     one of: atdoor, underbanana, atwindow.

    ; the following functions manipulate the state
    
    (define makeState
      (lambda (hPos vPos bPos) (list hPos vPos bPos)))
    
    (define monkeyHoriz
      (lambda (aState) (car aState)))
    
    (define monkeyVert
      (lambda (aState) (cadr aState)))
    
    (define boxPos
      (lambda (aState) (caddr aState)))
      
    ; The initial state is:
    
    (define initialState '(atdoor onfloor atwindow))
    
    ; the goal state is when the monkey in on the box under
    ; the banana
    
    (define goalFN
      (lambda (aState)
        (equal? aState '(underbanana onbox underbanana))))
    
    ; there are three types of moves possible:
    ;  a) the monkey can move one place left or right if it
    ;     is on the floor
    
    (define monkey-Left
      (lambda (aState)
        (if (eq? (monkeyVert aState) 'onfloor)
            (cond ((eq? (monkeyHoriz aState)
                        'underbanana)
                   (makeState 'atdoor
                              (monkeyVert aState)
                              (boxPos aState)))
                  ((eq? (monkeyHoriz aState)
                        'atwindow)
                   (makeState 'underbanana
                              (monkeyVert aState)
                              (boxPos aState)))
                  (else #f))
            #f)))
    
    (define monkey-Right
      (lambda (aState)
        (if (eq? (monkeyVert aState) 'onfloor)
            (cond ((eq? (monkeyHoriz aState)
                        'atdoor)
                   (makeState 'underbanana
                              (monkeyVert aState)
                              (boxPos aState)))
                  ((eq? (monkeyHoriz aState)
                        'underbanana)
                   (makeState 'atwindow
                              (monkeyVert aState)
                              (boxPos aState)))
                  (else #f))
            #f)))
    
    ;  b) the monkey can climb on or off the box if he is
    ;     beside the box
    
    (define monkey-ClimbOn
      (lambda (aState)
        (if (and (eq? (monkeyVert aState) 'onfloor)
                 (eq? (monkeyHoriz aState)
                      (boxPos aState)))
            (makeState (monkeyHoriz aState)
                       'onbox
                       (boxPos aState))
            #f)))
    
    (define monkey-ClimbOff
      (lambda (aState)
        (if (eq? (monkeyVert aState) 'onbox)
            (makeState (monkeyHoriz aState)
                       'onfloor
                       (boxPos aState))
            #f)))
    
    ;  c) the monkey can push the box left or right if he is
    ;     beside the box and on the floor

    (define box-Left
      (lambda (aState)
        (if (and (eq? (monkeyVert aState) 'onfloor)
                 (eq? (monkeyHoriz aState)
                      (boxPos aState)))
            (cond ((eq? (monkeyHoriz aState)
                        'underbanana)
                   (makeState 'atdoor
                              (monkeyVert aState)
                              'atdoor))
                  ((eq? (monkeyHoriz aState)
                        'atwindow)
                   (makeState 'underbanana
                              (monkeyVert aState)
                              'underbanana))
                  (else #f))
            #f)))
    
    (define box-Right
      (lambda (aState)
        (if (and (eq? (monkeyVert aState) 'onfloor)
                 (eq? (monkeyHoriz aState)
                      (boxPos aState)))
            (cond ((eq? (monkeyHoriz aState)
                        'atdoor)
                   (makeState 'underbanana
                              (monkeyVert aState)
                              'underbanana))
                  ((eq? (monkeyHoriz aState)
                        'underbanana)
                   (makeState 'atwindow
                              (monkeyVert aState)
                              'atwindow))
                  (else #f))
            #f)))
    
    ; the evaluation function encourages the monkey to move
    ; to under the banana, the box to move with the monkey
    ; and the monkey to climb the box.
    
    (define evalFN
      (lambda (aState)
        (+ (if (eq? (monkeyHoriz aState)
                    'underbanana) +1 -1)
           (+ (if (eq? (boxPos aState)
                       (monkeyHoriz aState)) +1 -1)
              (if (eq? (monkeyVert aState)
                       'onbox) +1 -1)))))
           
    
    (set! Monkey-SearchProblem
          (MakeSearchProblem initialState
                             goalFN
                             evalFN
                             (MakeActionList monkey-Left
                                             monkey-Right
                                             monkey-ClimbOn
                                             monkey-ClimbOff
                                             box-Left
                                             box-Right)))))

(begin (SetUpMonkey)
       #t)
