; Cookie Monster test of pattern matching toolbox
;
; Conversation in Sesame Street with cookie monster
; who requires a cookie

(define StartConversation
  (lambda ()
    ; continue to request cookie until get one
    ; respond to abuse and repetition
    
    (let ((lastAList #f)
          (lastItem #f)
          (sentence #f))
      
      (define displayAList
        (lambda (aList)
          ; display list without outer brackets
          (if (null? aList)
              #f
              (begin (display (car aList))
                     (display " ")
                     (displayAList (cdr aList))))))
              
      
      (define checkForPatterns
        (lambda aPatternList
          (do ((restPatterns aPatternList)
               (result #f))
              ((or (null? restPatterns)
                   result) (set! lastAList result)
                           result)
              (set! result (Match (car restPatterns) sentence))
              (set! restPatterns (cdr restPatterns)))))
      
      (define badWord?
        (lambda (anAL)
          ; is the value of expletive a bad word?
          (member (GetAssociationValue 'expletive anAL)
                  '(damn silly stupid))))
    
      (display "Give me cookie!")
      (do ((done #f))
          (done (newline)
                (display "Thank you ... munch munch ... Burp.")
                (newline))
          (newline)
          (display "...> ")
          (set! sentence (read))
          (newline)
          (cond ((not (pair? sentence))
                 (display "Please give your replies as a list"))
                ((checkForPatterns
                  (PATTERN ?+ 'cookie ?+)
                  (PATTERN ?+ 'cookie)
                  (PATTERN 'cookie ?+)
                  (PATTERN 'cookie)
                  (PATTERN ?+ 'cookies ?+)
                  (PATTERN ?+ 'cookies)
                  (PATTERN 'cookies ?+)
                  (PATTERN 'cookies))
                 (set! done #t))
                ((checkForPatterns
                  (PATTERN ?+ 'some (?+ 'item))
                  (PATTERN 'some (?+ 'item)))
                 (display "No want ")
                 (set! lastItem (GetAssociationValue 'item lastAList))
                 (displayAList lastItem))
                ((checkForPatterns
                  (PATTERN ?+ (? 'word) (<-? 'word) ?+)
                  (PATTERN (? 'word) (<-? 'word) ?+)
                  (PATTERN ?+ (? 'word) (<-? 'word))
                  (PATTERN (? 'word) (<-? 'word)))
                 (display "Why say words twice?"))
                ((checkForPatterns
                  (PATTERN ?+ (? 'expletive badWord?) ?+)
                  (PATTERN (? 'expletive badWord?) ?+)
                  (PATTERN ?+ (? 'expletive badWord?))
                  (PATTERN (? 'expletive badWord?)))
                 (display "Please don't get cross!")
                 (newline)
                 (if lastItem
                     (begin (display "Earlier you spoke of ")
                            (displayAList lastItem))
                     #f))
                (else (display "Give me cookie!")))))))

(begin
 (display "Type (StartConversation) to talk to cookie monster")
 (newline))