; ===== section 3.3.4 InnKeeper =====

(define InnKeeper
  (lambda ()
    
    ; the knowledge base and other global variables
    (let ((InnKeeper-KB #f)
          (guestName    #f)
          (answer       #f)    ; guest's reply
          (desire       'food) ; food or drink
          (selectionNo  0)     ; index into lists of alternatives
          (evicted      #f)     
          (allDone      #f))
      
      (define mealList 
        '("gooey gruel" "mouldy mushrooms" 			    
                        "leathery leg of lamb"))
      (define drinkList 
        '("stale beer" "sour wine" "murky water"))
      
      (define orderWord?
        (lambda (anAList)
          ; does the pattern variable order express a wish to order ?
          (member (GetAssociationValue 'order anAList)
                  '(have want like about))))
      
      (define eatWord?
        (lambda (anAList)
          ; does the pattern variable eat express a wish to eat ?
          (member (GetAssociationValue 'eat anAList)
                  '(eat hungry starving))))
      
      (define drinkWord?
        (lambda (anAList)
          ; does the pattern variable drink express a wish to drink ?
          (member (GetAssociationValue 'drink anAList)
                  '(drink thirsty dry))))
      
      (define posessionWord?
        (lambda (anAList)
          ; does the pattern variable posession denote something valueable ?
          (member (GetAssociationValue 'posession anAList)
                  '(money gold silver))))
      
      (define pleasureWord?
        (lambda (anAList)
          ; does the pattern variable pleasure express pleasure ?
          (member (GetAssociationValue 'pleasure anAList)
                  '(lovely yummy excellent great))))
      
      (define displeasureWord?
        (lambda (anAList)
          ; does the pattern variable displeasure express displeasure ?
          (member (GetAssociationValue 'displeasure anAList)
                  '(filthy yacky awful terrible inedible))))
      
      (define meal
        (lambda ()
          (set! selectionNo (+ 1 selectionNo))
          (if (= selectionNo (length mealList))
              (set! selectionNo 0)
              #f)
          (list-ref mealList selectionNo)))
      
      (define drink
        (lambda ()         
          (set! selectionNo (+ 1 selectionNo))
          (if (= selectionNo (length drinkList))
              (set! selectionNo 0)
              #f)
          (list-ref drinkList selectionNo)))
      
      (define evasiveAnswer
        (lambda ()          
          (define repertoire '("is off today"
                               "is never on our menu"
                               "is not popular around here"))
          (set! selectionNo (+ 1 selectionNo))
          (if (= selectionNo (length repertoire))
              (set! selectionNo 0)
              #f)
          (list-ref repertoire selectionNo)))
      
      (define disinterestedComment                
        (lambda ()           
          (define repertoire '("Indeed ?"
                               "Amazing"
                               "That's fairly interesting"))
          
          (set! selectionNo (+ 1 selectionNo))
          (if (= selectionNo (length repertoire))
              (set! selectionNo 0)
              #f)
          (list-ref repertoire selectionNo)))
      
      (define reply
        (lambda aList
          ; remove any outer brackets or sublists and show the resulting list
          
          (define replyAux
            (lambda (aList)
              (do ((rest aList (cdr rest)))
                  ((null? rest))
                  (if (pair? (car rest))
                      (replyAux (car rest))
                      (display (car rest)))
                  (display " "))))
          
          (replyAux aList)))
      
      (define serve 
        (lambda ()        
          (reply "You are a man of means, I assume ?")     
          (set! answer (readAnswer))
          (if (Match (PATTERN ?+ (? 'posession posessionWord?))
                     answer)                      
              (begin
               ; serve
               (reply "Nissifer will bring your order in a minute.")
               (reply "Stay as long as you like"))
              (begin
               ; evict
               (reply "Much as it embarrasses me, but I" 
                      "must urge you to take your business elsewhere")
               (evict)))))
      
      (define evict 
        (lambda () (set! evicted #t)))
      
      (define makeFact
        (lambda (aPattern aProcedure) (cons aPattern aProcedure)))
      
      (define selectPattern car) ; select the pattern part of a fact
      (define selectProc    cdr) ; select the procedure part of a fact
      
      (define initializeKB
        (lambda ()
          (set!
           innKeeper-KB
           (MakeKB                       
            ; guest wants to eat
            (makeFact (PATTERN ?+ (? 'eat eatWord?))
                      (lambda (al) (set! desire 'food)
			           (reply "May I suggest the" (meal) "?")))            
            ; guest wants to drink
            (makeFact (PATTERN ?+ (? 'drink drinkWord?))
                      (lambda (al) (set! desire 'drink)
			           (reply "May I suggest" (drink) "?")))            
            ; guest wants to order an item
            (makeFact (PATTERN ?+ (? 'order orderWord?) 		
                                  (?+ 'what))
                      (lambda (al)
                        (if (or (member (GetAssociationValue 'what al)
					mealList)
                                (member (GetAssociationValue 'what al)
					drinkList))
                            ; ordered item is on menu
                            (serve)
                            ; ordered item is not on menu
                            (reply "Sorry, but" 
				   (GetAssociationValue 'what al) 
				   (evasiveAnswer)))))                                    
            ; guest accepts
            (makeFact (PATTERN 'yes ?+) (lambda (al) (serve)))            
            ; guest declines
            (makeFact (PATTERN 'no ?+) 
                      (lambda (al) 
                        (reply "Would you care for some"                        
                               (if (eq? desire 'food) (meal) (drink)) 
                               "then ?")))            
            ; guest wants to pay a compliment
            (makeFact (PATTERN ?+ (? 'pleasure pleasureWord?))
                      (lambda (al) (reply "Thank you.")))            
            ; guest didn't like it
            (makeFact (PATTERN ?+ (? 'displeasure displeasureWord?))
                      (lambda (al) (reply "This is preposterous !"
					  "I must ask you to leave") 
			           (evict)))            
            ; guest leaves
            (makeFact (PATTERN 'Bye)
                      (lambda (al)
                        (set! allDone #t)
                        (if (not evicted)
                            (reply "Come back soon")) 		
                        (newline)))                                                 
            ; guest just wants to chat
            (makeFact (PATTERN ?+) (lambda (al)
				     (reply (disInterestedComment))))      
            ))))
      
      (define readAnswer
        ; get a response from the guest
        (lambda ()
          (newline)
          (display "...> ")
          (set! answer (read))
          (newline)
          (if (not (pair? answer))
              (begin (reply "Please give your replies as a list")
                     (readAnswer))
              answer)))
      
      (initializeKB)
      (set! allDone #f)
      (DisplayLine "Welcome to the Blue Unicorn" 
                   "I am Weamish,the owner.")
      (display "How may I address you ?")
      (set! guestName (readAnswer))
      (reply "How may we be of service" guestName "?")
      (do ((answer #f)
           (element #f))
          (allDone #f)
          (set! answer (readAnswer))
          (set! element
                (RetrieveByString innKeeper-KB 
				  answer 
				  selectPattern))
          ((selectProc (GetFact element)) (GetAList element))))))

