; ========== some simple Random Distributions ==========

; ...> DEFINE a flavour of type <0t01randomGenerator>

(defFlavour 0to1randomGenerator (ako Vanilla) 
  (ivars lastNumber a m))

(defMethod (initialize! 0to1randomGenerator) ()
  (self 'setSeed! 524287)
  (set! a 630360016)
  (set! m 4294967295) ; (2**32) - 1 
   #t)

(defMethod (setSeed! 0to1randomGenerator) (aSeed) 
  (set! lastNumber aSeed))

(defMethod (nextRN 0to1randomGenerator) ()
  (let ((rn (remainder (* lastNumber a) m)))
     (set! lastNumber rn) 
     (/ rn m)))

; ----- a "Distribution" root flavour -----

(defFlavour Distribution (ako Vanilla) (ivars name rng sampleTally) 
  setivars getivars testivars)

(defMethod (initRNG Distribution) () 
  (makeInstance (myGen 0to1randomGenerator))
  (self 'rng! myGen)
  ((self 'rng) 'initialize!))

(defMethod (reset! Distribution) () 
  (if (self 'sampleTally?)
      (sampleTally 'reset!)))
  
(defMethod (show Distribution) ()
  (displayLine "===" (self 'flavourName) ":" name)
  (if (self 'sampleTally?)
      (sampleTally 'show)
      (displayLine "No samples were taken !")))

(defMethod (updateTally! Distribution) (aValue)
  (if (not (self 'sampleTally?)) (set! sampleTally (Tally 'new)))  
  (sampleTally 'update! aValue) )

; ----- Boolean Distribution -----

(defFlavour DrawDist (ako Distribution)  (ivars %true) 
  setivars getivars testivars)

(defMethod (sample DrawDist) ()
  (if (not (self 'rng?)) (self 'initRNG))  
  (let ((tORf #t) (value 1))
    (set! tORf (>? %true (rng 'nextRN)))
    (set! value (if tORf 1 0))
    (self 'updateTally! value)
    tORf))

; ----- Integer Uniform Distribution -----

(defFlavour RandIntDist (ako Distribution) (ivars lower upper)
  setivars getivars testivars)

(defMethod (sample RandIntDist) ()
  (if (not (self 'rng?)) (self 'initRNG))
  (let ((range (- upper lower))
        (sample 0)) 
    (set! sample (round (+ lower (* range (rng 'nextRN)))))
    (self 'updateTally! sample)
    sample))

; ----- Uniform Distribution -----

(defFlavour UniformDist (ako Distribution) (ivars lower upper)
  setivars getivars testivars)

(defMethod (sample UniformDist) ()
  (if (not (self 'rng?)) (self 'initRNG))
  (let ((range (- upper lower))
        (sample 0)) 
    (set! sample (+ lower (* range (rng 'nextRN))))
    (self 'updateTally! sample)
    sample))

; ----- NegExp Distribution -----

(defFlavour NegExpDist (ako Distribution) (ivars rate)
  setivars getivars testivars)

(defMethod (sample NegExpDist) ()
  (if (not (self 'rng?)) (self 'initRNG))
  (set! sample (- (* (/ 1 rate) (log (rng 'nextRN)))))
  (self 'updateTally! sample)
   sample)

; ----- Constant Distribution -----

(defFlavour ConstantDist (ako Distribution) (ivars value)
  setivars getivars testivars)

(defMethod (sample ConstantDist) () (self 'updateTally! value) value)

                             
