; M.C. Stairmand, Nov. 1987

;  This file contains the code of vanilla.


(define vaninit (lambda ()
(set! vanivars
      '((self ())
        (name 'vanilla)
        (creator ())
        (subs (list flavour))
        (mum 'flavour)))

(set! vanmeths
      '((becomesub (subflavour)
                    (if (null? (subflavour 'name))
                        (begin
                         (disp name "refuses to become the super flavour of a nameless flavour")
                         (newline))
                        (begin
                         (for-each
                          (lambda (x)
                            (if (equal? (x 'name) (subflavour 'name))
                                (set! subs (remove x subs))))
                          subs)
                         (set! subs (append subs (list subflavour))))))
        (akotree ()
             (disp name)
             (newline)
             (for-each
              (lambda (x)
                 (x 'rfamily '(vanilla)))
              subs))
        (describe () (disp "later maybe") (newline))
        (actormixed () #f)
        (removeFlavour (flav)
                        (set! subs (remove flav subs)))
        (clean () (set! subs (list flavour))
                  ())
        (self! (s) (set! self s))
        (name () name)
   
        (ivars ()
               '(self **creator** **mum**))
        (flavour () 'flavour)
        
        (methods () '((**self!** (s) (set! self s))
                      (flavour () **creator**)
                      (**flavourPointer!** (f) (set! **creator** f))
                      (**mum!** (m) (set! **mum** m))
                      (sendToSuperFlavours (meth . args)
                         (if (and (not (proper-list? meth))
                             (> (length (**creator** 'super)) 1))
                              (cerror "Too many supers")
                              (begin
                               (if (not (proper-list? meth))
                                   (set! meth (list meth)))
                               (for-each
                                (lambda (sfl)
                                  (if (or (not (cdr meth))
                                          (equal? (sfl 'name)
                                                  (cadr meth)))
                                      (if (assq (car meth) (sfl 'methods))
                                       (apply
                                        call/we
                                        (list
                                        (self '**env**)
                                        (makemethod (self '**env**)
                                                    (cdr
                                                     (assq 
                                                      (car meth)
                                                      (sfl 'methods))))
                                         args))
                                       (cerror "message not found"))))
                                (**creator** 'super)))))       
                      (flavourName () **mum**)))))
                  ()))
(vaninit)                
      
(set! vanilla (bootstrap-vanilla vanivars vanmeths))
(vanilla 'self! vanilla)