; M.C. Stairmand, November 1987.

; actor is a flavour that allows coroutines.
; The function ***x*** should be called from the top-level.
; It provides a continuation for the method "toplevel".

(defflavour actor (ako vanilla) (ivars **currentmethod**
                                       **savedstates**
                                       **initstates**))

(defmethod (reset actor) ()
  (set! **savedstates** ())
  (set! **initstates** ()))
  

(defmethod (resume actor) (instance meth . args)
  (call/cc
   (lambda (cont)
     (if (assq **currentmethod** **savedstates**)
         (set! **savedstates** (remove
                            (assq **currentmethod** **savedstates**)
                            **savedstates**)))
     (set! **savedstates** (append **savedstates**
                                   (list (cons **currentmethod**
                                                           cont))))
     (apply instance (append (list 'continue meth) args)))))

(defmethod (continue actor) (meth . args)
  (call/cc
   (lambda (init)
     (if (assq meth **initstates**)
         (set! **initstates** (remove (assq meth **initstates**)
                                      **initstates**)))
     (set! **initstates** (append **initstates** (list (list
                                                        meth
                                                        init
**currentmethod**))))
     (set! **currentmethod** meth)
     (if (assq meth **savedstates**)
         ((cdr (assq meth **savedstates**)) #!null)
         (apply self (append (list meth) args))))))

(defmethod (detach actor) ()
  (call/cc
   (lambda (cont)
     (if (assq **currentmethod** **savedstates**)
         (set-cdr! (assq **currentmethod** **savedstates**) cont)
         (set! **savedstates** (append **savedstates**
                                       (list (cons **currentmethod**
                                                           cont)))))
     (let ((back (cadr (assq **currentmethod** **initstates**))))
       (set! **currentmethod** (caddr (assq **currentmethod**
                                            **initstates**)))
       (back #!null)))))

(defmethod (terminated? actor) (meth)
  (cadddr (assq meth **initstates**)))

(defmethod (TopLevel actor) ()
  (***toplevel*** #!null))

(defmethod (ppmeth flavour) (name)
  (assq name methods))
                            
(define ***x***
  (lambda ()
    (call/cc
     (lambda (cont)
       (set! ***toplevel*** cont)))))
  