friends(mole,  bear).
friends(bear, tiger).

happy(mole).
% prescribe property 'happy' to individual 'mole', meaning:
% there exists a 'mole' with predicate 'happy';  ergo a "happy mole"

likes(bear, tiger).  
% prescribe binary relation 'likes' among individuals 'bear' 
% and 'tiger', meaning: there  exists a 'bear and   a 'tiger'  
% and they 'like' each other;
% ergo: "bear likes tiger"

washes(bear, tiger, soap).  
%  ... "bear washes tiger with soap" 
creatures([mole, bear, tiger]). 
% 'mole', 'bear' and 'tiger' belong to class (list)  'creatures',  
% meaning: 
% there exists ... and they are all members of class 'creatures'

happy(mole).
sad(mole).

likes(tiger, Anybody).

likes(tiger, _ ).

clean(Friend ) :- washed(Friend).
washed(Friend) :- soaped(Friend), rinsed(Friend).

washed(mole).
washed(Friend, When) :- saturday(When).

gentry(Creature) :- offspring(Creature,Father), gentry(Father).
gentry(Creature)    :- done(Creature, Deed),  
                                  noble(Deed), 
                                  daring(Deed).
admirable(Creature) :- done(Creature, Deed), 
                                    noble(Deed), 
                                    daring(Deed).
gentry(bigBear).
 
travels(Friend, NewPlace, Vehicle) :- 
                location(Friend, OldPlace),             
                connected(OldPlace, NewPlace),  
                OldPlace \= NewPlace,    
                location(Vehicle, OldPlace).

father(Person, Offspring) :- 
              offspring(Person, Offspring), male(Person).

offspring(bigTiger, littleTiger).

male(bigTiger).

?- father(Who, littleTiger).    
?- offspring(Who, littleTiger), male(Who).

offspring(littleMole, bigMole).
offspring(littleBear, bigBear).
done(littleMole, savedFoxFromDrowning).
done(fastHare, toldOfBigFlood).
noble(savedFoxFromDrowning).
daring(savedFoxFromDrowning).
daring(toldOfBigFlood).

gentry(bigMole).
gentry(Creature):-offspring(Creature, Father), gentry(Father).
gentry(Creature):- done(Creature, Deed), 
                              noble(Deed), 
                              daring(Deed).
gentry(bigBear).

    ?- gentry(Who).
    Who = bigMole
    Who = littleMole
    Who = littleBear
    Who = littleMole
    Who = fastHare
    Who = bigBear

 gentry(Creature) :- offspring(Creature, Father),  
                               gentry(Father), !.

?- gentry(Who).
    Who = bigMole
    Who = littleMole

?- gentry(littleMole).
    yes
?- gentry(fastHare). 
    yes

age(mole, 13) :- !.
age(bear,  5) :- !.
age(tiger, 5) :- !.

? age(Who, 5).
   Who = bear

once(Predicate) :- Predicate, !.
?- once(age(Who, 5)).
   Who = bear

gentry(fox) :- !, fail.

creature(bear).
likes(mole, Who) :- creature(Who), not Who == fox.
?- likes(mole,bear).
   yes
?- likes(mole,fox).
   no
?- likes(mole,snake).
   no
?- not likes(mole,snake).
   yes

?- likes(mole, Who).
   Who = bear
?- not likes(mole, Who).
   No (more) solutions

likes(mole,snake).
likes(mole,poetry).
likes(Who,What) :- not hates(Who,What).
hates(mole,snake).

?- likes(mole,snake). 
  yes
?- hates(mole,snake).
  yes
?- likes(mole,billard).
  no
?- likes(mole,What).
  What = snake   What = poetry

likes(Who,What) :- not hates(Who,What).
likes(mole,snake).
likes(mole,poetry).
hates(mole,snake).
?- likes(mole,snake).
  no
?- likes(mole,poetry).
  yes
?-likes(Who,poetry).
  Who = mole
?- likes(Who,snake).
   No (more) solutions
?- likes(mole,What).
   No (more) solutions

chomp :- repeat, acquire(Answer), 
              echo(Answer), 
              finished(Answer).
% read" is implementation dependent - 
% for MacProlog use "promp_read".
acquire(Answer) :- read(Answer). 
echo(Answer) :- display (Answer), nl.
finished(bye) :- !.
finished(Term) :- fail.  

?- chomp.
   hello 
   here 
    bye
   yes

nice(bear).
nice(tiger).
?- nice(bear) = nice(tiger).
    no
?- nice(bear) = nice(Who).
    Who = bear

?- likes(bear, mole) == likes(bear, mole).
    yes

?- 2+2 =:= 4.
    yes

?- 2 < 3.
    yes

?- (@< 2 3)
    yes

?- Result is 2 + 2 * 3 / 4.
    Result = 3.5
?- Result = 2 + 2 * 3 / 4.
    Result = 2 + 2 * 3 / 4

?- int(3.14, Result).
    Result = 3

asserta(blind(mole)).
assert((understands(mole, Who) :- mole(Who))).
?- blind(Who).
   Who = mole
?- understands(mole, mole).
   no

understands(mole, mole).
understands(mole, mouse).
understands(mole, digging).
?- understands(mole, Which).
   Which = mole  
   Which = mouse   
   Which = digging

retract(understands(mole,mouse)).
?- understands(mole, Which).
   Which = mole  
   Which = digging
abolish(understands, 2).
?- understands(mole, Which).
   No definition for relation understands(mole, _)

% before the retract and abolish to the above database 
:- assert(understands(mole, poetry)).
   yes
:- listing.
   understands(mole, mole).
   understands(mole, mouse).
   understands(mole, digging).
   understands(mole, poetry).

?- arg(3,travels(littleBear, balloon, panama), Where).
   Where = panama.

?- functor(Hate, hates, 2).
    Hate = hates(_1, _2)

?- functor(Hate, hates, 2),
           arg(1, Hate, mole),
           arg(2, Hate, snake), 
           assert(Hate).
    Hate =  hates(mole, snake)
?- hates(Who, snake).
    Who = mole

?- Clause =.. [respects, snake, mole].
    Clause =  respects(snake, mole)
?- cantStand(papaBear, noise) =.. List.
    List = [cantStand, papaBear, noise]

?- Clause =.. [respects, snake, mole], assert(Clause).
    Clause =.. [respects, snake, mole]
?- Query =.. [respects, snake, Who], call(Query).
    Who = mole

op(500, xfy, =>).
X=>Y :- creature(X), creature(Y), X \== Y, 	
           write(X), tab(1), write(washes), tab(1), .write(Y), nl.
creature(bear).
creature(tiger).
?- bear => tiger.
bear washes tiger
   yes
?- bear => bear.
% fails the "identity test": X \== Y 
   no 	
?- bear => snake. 
% snake is not asserted to be a creature 
   no

friends([mole, bear, tiger)].
%  take car and cdr
?- friends([Head|Tail]).
   Head = mole
   Tail = [bear, tiger]

% take (car (cdr ..))
?- friends ([_| [SecondElement|_]])
   _1 = mole
   SecondElement = bear
   _2 = [tiger]

first(Element, [Element|_]).
?- first(BestFriend, [mole, bear, tiger]).
   BestFriend = mole

third(Element, [_,_,Element|_]).
?- third(ThirdBestFriend, [mole, bear, tiger]).
   ThirdBestFriend = tiger

last(Element, [Element]).
last(Element, [_|Tail]) :- last(Element,Tail]).
?- last(LeastBestFriend, [mole, bear, tiger]).
   LeastBestFriend = tiger

inList(Who, [Who|_]).
inList(Who, [_|Tail]) :- inList(Who,Tail).
?-inList(tiger, [mole,bear,tiger])
   yes

?-inList(Who, [mole, bear, tiger]).
   Who = mole
   Who = bear
   Who = tiger

friend(Who) :- friends(List), inList(Who, List).

?- friend(bear).
   yes
?- friend(fox).
   no

% a list appended to an empty list is the same list (stopping case)
append([ ], List, List). 
% two non-empty lists appended to each other have all the 
% elements of the first                    
% list appended to the second list. This can be recursively defined: 
% element by element.
append([Element|List1], List2, [Element|List3]) 
         :- append(List1, List2, List3).

?- append([goose, frog], [mole, bear, tiger], Friends).
    Friends = [goose, frog, mole, bear, tiger]
?- append([goose, frog, mole], WhichList, 
                [goose, frog, mole, bear, tiger]).
    WhichList = [bear, tiger].

?-  sort([mole, bear, tiger], Result).
    Result = [bear, mole, tiger]

lives(mole, hole).
lives(bear ,littleHouseByTheRiver).
lives(tiger,littleHouseByTheRiver).
lives(Guest, Place) :- frequentVisitor(Guest, Host), 
                                  lives(Host, Place).
frequentVisitor(mole, bear).
frequentVisitor(mole, tiger).

?- bagof(Where, lives(mole, Where), Places).
    Where =  hole
    Places =  [hole]
    Where =  littleHouseByTheRiver
    Places =  [littleHouseByTheRiver, littleHouseByTheRiver]
    No (more) solutions

?- setof(Where, lives(mole, Where), Places)
    Where =  hole
    Places =  [hole]
    Where =  littleHouseByTheRiver
    Places =  [littleHouseByTheRiver]
    No (more) solutions

?- findall(Where,lives(mole,Where),Solutions).
    Solutions = [hole, littleHouseByTheRiver, littleHouseByTheRiver]
?- findall(Who,lives(Who, littleHouseByTheRiver), Solutions),
     sort(Solutions, SortedSolutions).
    Solutions =  [bear, tiger, mole, mole]
    SortedSolutions =  [bear, mole, mole, tiger]

% --- Dungeon Master ---

% FACTS: elementary concepts, relationships and their 
% instantiations  

        adventurer(cugel).

        monster(herman).
        monster(sadlark).
        monster(marvin).

        dungeon(first).
        dungeon(second).
        dungeon(third).

        treasure(gold).
        treasure(jewel). 

% we don't class marvin's map as a treasure 
% - it's most likely a forgery anyway 

        owns(herman,gold).
        owns(sadlark,jewel).
        owns(marvin,map).

        in(first,cugel).
        in(second,herman).
        in(third,sadlark).
        in(third,marvin).
        in(second,gold).
        in(third,jewel).
        in(third,map).

        stronger(cugel,herman).
        stronger(cugel,marvin).
        stronger(sadlark,herman).
        stronger(sadlark,marvin).
        stronger(marvin,herman).

        connected(first,second).
        connected(first,third).
        connected(second,third).
        connected(third,first).
        connected(third,second).

%  RULES: derived concepts   

%  all places are "connected" to themselves
        connected(FirstPlace,SecondPlace) :- 				  				FirstPlace==SecondPlace. 
 
% you are rich if (and only if) you own riches
        rich(SomeOne) :- riches(SomeOne,_). 
 
% riches may be owned or acquired
        riches(SomeOne,Item) :- owns(SomeOne,Item), treasure(Item).
        riches(SomeOne,Item) :- acquire(SomeOne,Item), 
                                               treasure(Item).
        
% to acquire an item you must go and get it  
        acquire(SomeOne,Item) :- go(SomeOne,Item), 
                                                 grab(SomeOne,Item).

% to go to an item you must be in some place, the item must be in 
% some place, and the two places must be connected
        go(SomeOne,Item) :- in(FirstPlace, SomeOne), 
                                        in(SecondPlace,SomeOne), 
                                        connected(FirstPlace,SecondPlace).

% to grab an item from a monster you must take it away, 
% which will only succeed if you win the  resulting "fight". 
        grab(SomeOne,Item) :- owns(Owner,Item), 
                                           monster(Owner), 
                                           win(SomeOne,Owner).

% to win a fight you must be stronger than your opponent
        win(SomeOne,Opponent) :- stronger(SomeOne,Opponent).

        ?- monster(Who).
       Who = herman  Who = sadlark  Who = marvin

        ?- rich(sadlark).
       yes
        ?- rich(marvin).
       no  % the map doesn't count (not a treasure),
             %  but he can acquire the goldBar from herman.

        ?- acquire(marvin, What).
       X = goldBar

        ?- go(cugel,herman).
       yes   % first and third cave are connected
        ?- go(herman, cugel).
       no   % second and first cave are not connected 

        ?- acquire(sadlark, What).
       What = gold   What = map
        ?- acquire(Who,jewel)
       no more solutions   % sadlark has got it and she is too strong
        ?- acquire(Who,goldBar).
       Who = cugel   Who = sadlark   Who = marvin  
       % herman is just too weak to defend it

        ?- owns(cugel, What).
       no more solutions
        ?- grab(cugel,goldBar).   
       yes  %  he may take it from herman
        :- acquire(cugel,sword).
       no   % can't go to sword (not asserted to be "in" anywhere)
        ?- acquire(cugel, What).
       What = goldBar   What = map
        ?- rich(cugel).
       yes
        ?- riches(cugel,What).
       What = goldBar

        ?- riches(Who, What).
       % any treasure that anybody can own or acquire
       % remember that the map is not classed as "treasure" !
       Who = cugel       What = goldBar  % they can all rob poor herman
       Who = sadlark    What = goldBar
       Who = marvin     What = goldBar
       Who = herman    What = goldBar  % herman owns it
       Who = sadlark    What = jewel 
       % nobody ever takes anything from sadlark !

% --- Lineland ---

 solveLineland(InitState) :- 
           solution(InitState,      	% from an intial state
                    NewState,        	% (via other states) to a goal   
                    [InitState],     		% path initialization  
                    Solution),      		% (via other paths) to a solution  
           show(Solution).

 show(Path) :- display(solution), nl, showSteps(Path).

        showSteps([]).
        showSteps([Head|Tail]) :- display(Head), nl, showSteps(Tail).

solution(state(e,s,s,l,l),done,OldPath,OldPath).
        solution(state(s,e,s,l,l),done,OldPath,OldPath).
        solution(state(s,s,e,l,l),done,OldPath,OldPath).
        solution(state(s,s,l,e,l),done,OldPath,OldPath).
        solution(state(s,s,l,l,e),done,OldPath,OldPath). 

 solution(OldState, NewState, OldPath, NewPath) :-  
            hop(+1, OldState, NextState, OldPath, NextPath), 
            solution(NextState, NewState, NextPath, NewPath).

        solution(OldState, NewState, OldPath, NewPath) :-  
            hop(+2, OldState, NextState, OldPath, NextPath), 
            solution(NextState, NewState, NextPath, NewPath).

        solution(OldState, NewState, OldPath, NewPath) :-  
            hop(-1, OldState, NextState, OldPath, NextPath), 
            solution(NextState, NewState, NextPath, NewPath).

        solution(OldState, NewState, OldPath, NewPath) :-  
            hop(-2, OldState, NextState, OldPath, NextPath), 
            solution(NextState, NewState, NextPath, NewPath).

hop(Places, OldState, NewState, OldPath, NewPath) :- 
       position(e, OldState, From),
       To is From + Places, 
       To > 0,  To =< 5,
       hopSpace(From, To, OldState, NewState), 
       not cyclic(NewState,OldPath), 
       NewPath = [NewState|OldPath], 
       write(NewPath), nl.

 position(Symbol,state(e,_,_,_,_),1).
 position(Symbol,state(_,e,_,_,_),2).
 position(Symbol,state(_,_,e,_,_),3).
 position(Symbol,state(_,_,_,e,_),4).
 position(Symbol,state(_,_,_,_,e),5).

cyclic(State,Path) :- onPath(State,Path).

onPath(State,[State|_]).  
onPath(State,[_|Tail]) :- onPath(State,Tail).

hopSpace(From, To, OldState, NewState) 
            :- % get the 'e' into place	 
               moveSymbol(e, To, OldState, BufferState, 
                                    replacedSymbol), 
               % now put the replaced symbol where the 'e' came from   
               moveSymbol(ReplacedSymbol, From, BufferState, 
                                   NewState, Dummy). 

moveSymbol(Symbol, To, Old, New, ReplacedSymbol) 
          :-.functor(Old,State,Arity),  % bind the old State and Arity
	    % build a new one with these values
             functor(New,State,Arity),                  
             build(Arity,Symbol,To,Old,New,ReplacedSymbol).

build(0, Symbol, To, Old, New, ReplacedSymbol).

build(Index, Symbol, To, Old, New, ReplacedSymbol) 
        :- Index > 0, not Index =:= To, %  no change
           arg(Index,Old,Value),          %  get and .
           arg(Index,New,Value),         %  copy the old slot's value
           Next is Index - 1,                %  recurse to the next slot
           build(Next, Symbol, To, Old, New, ReplacedSymbol).

   build(Index, Symbol, To, Old, New, ReplacedSymbol) 
        :- Index > 0, Index =:= To,         %  destination of 'e'
           arg(Index, New, Symbol),      %  put 'e' in slot
           arg(Index, Old, ReplacedSymbol),  
           %  remember what was there
           Next is Index - 1,                  %  recurse to the next slot
           build(Next, Symbol, To, Old, New, ReplacedSymbol).

:- solveLineland(state(e,l,l,s,s)).
        solution
        state(s, e, s, l, l)
        state(s, l, s, e, l)
        state(s, l, e, s, l)
        state(e, l, s, s, l)
        state(l, e, s, s, l)
        state(l, s, s, e, l)
        state(l, s, e, s, l)
        state(l, s, l, s, e)
        state(l, s, l, e, s)
        state(l, s, e, l, s)
        state(l, e, s, l, s)
        state(l, l, s, e, s)
        state(l, l, e, s, s)
        state(l, e, l, s, s)
        state(e, l, l, s, s)
        yes

:- solveLineLand(state(e,l,l,s,s),7).

	solution
	state(s, s, l, e, l)
	state(s, e, l, s, l)
	state(e, s, l, s, l)
	state(l, s, e, s, l)
	state(l, s, l, s, e)
	state(l, s, l, e, s)
	state(l, e, l, s, s)
	state(e, l, l, s, s)
	yes


