; a maze is an association list of exits and other objects 
(define Maze '((entry   (north exit) (east exit) 
                        (south pit) (west dungeon))
               (exit    (north #f) (east #f) 
                        (south entry) (west entry))
               (dungeon (north entry) (east #f) 
                        (south pit) (west #f) 
                        (monster troll) (treasure jewel))
               (pit     (north #f) (east #f) 
                        (south #f) (west dungeon))))

; adventurers are bound to a list of their properties (
; name-value pairs), including "position" 
; (see definition of "room" below)
(define Adventurer (list (list 'position (room Maze 'entry))) )

; 0: return an adventurer in a new location
(define changeLocation 
  (lambda (anAdventurer aRoom)
    (map 
     (lambda (aPropertyPair)
       (if (equal? (car aPropertyPair) 'position)
           (list 'position aRoom)
           aPropertyPair))
     anAdventurer)))
   

; 1: Maze description 
(define displayMaze 
  (lambda (aMaze) 
    (display "*** Maze ***") (newline)
    (for-each (lambda (aDescription) 
                (display "   ") (display (car aDescription)) 
                (display ":") (newline)
                (for-each (lambda (aProperty)
                            (display aProperty))
                          (cdr aDescription))
                (newline))
              Maze)
    (newline)))

; 2: Adventurer position (returns a room)
(define where 
  (lambda (anAdventurer) 
    (cadr (assoc 'position anAdventurer))))

; 3a: find a room in a maze (by name)
(define room 
  (lambda (aMaze aRoomName) (assoc aRoomName aMaze)))
; 3b: inspect an association and test if it describes an exit
(define exit? 
  (lambda (anAssociation)
    (and (member (car anAssociation) '(north east south west))
         (not (null? (cadr anAssociation)))) ))
; 3c: inspect a room and return all exits ...
(define exits
  (lambda (aRoom)
    (define associations (cdr aRoom))
    (map (lambda (anAssociation)
            (if (exit? anAssociation) anAssociation))
         associations)))

; 4: return the next room (if any) in a maze, 
;    given a direction  
(define next 
  (lambda (aMaze aRoom aDirectionName)
    (define directionAssoc (assoc aDirectionName (cdr aRoom))) 
    (if (exit? directionAssoc)
        (room aMaze (cadr directionAssoc))) ))

; 5: change ane adventurer's location by walking in a given 
;    direction (if there is an exit that way) - 
;    returns a "new" adventurer
(define walk 
  (lambda (aMaze anAdventurer aDirectionName)
    (define destination 
            (next aMaze (where anAdventurer) aDirectionName))
    (if (not (null? destination))
        (changeLocation anAdventurer destination)
    (begin (display "ouch .. (there's a wall here) @#!!") (newline)
               anAdventurer ))))

; ... {and so forth} ...

