

/***************************************************************************/
/* This is the main process that runs on each pe 			   */
/* EXPORTS: nothing                                                        */
/*									   */
/* IMPORTS: 	void OsMcDepInit();					   */
/* 		MESSAGE *OsNextWorkPiece();				   */
/*		void RopmConsume(GOAL_OR_RESP *message);		   */
/*              void BePrintGoal(GOAL_OR_RESP *goalResp);                  */
/*		void BePrintResponse(GOAL_OR_RESP *goalResp);              */
/***************************************************************************/

#include "typedefs.h"
#include "gen.h"
#include "macros.c"
#include "msgmacros.c"
#include "seq_macros.c"

extern Instruction *Instr;
int	packedGoal=0;

UsrHostInit(argc, argv) 
{
}

UsrNodeInit()
{
    extern LONG *SeqStack, **SeqTrail;
    extern LONG MAXSTACKSIZE, MAXTRAILSIZE;

    SeqStack =   (LONG *) OsAllocInit(sizeof(LONG) * MAXSTACKSIZE);
    if (SeqStack == NULL)
    {
	OsPrint("error during initialization in seq stack allocation\n");
	OsPrint("execution aborted\n");
	exit(1);
    }
    SeqTrail =   (LONG **) OsAllocInit(sizeof(LONG *) * MAXTRAILSIZE);
    if (SeqTrail == NULL)
    {
	OsPrint("error during initialization in seq trail allocation\n");
	OsPrint("execution aborted\n");
	exit(1);
    }
    OsPrintf("PE %d - Node initialization complete.\n", OsMyPeNum());
}




UsrSetReadVar(ppReadVar,pSize,str)
char **ppReadVar,*str;
int  *pSize;
{
}



UsrGetReadVar(pReadVar,size)
LONG *pReadVar;
LONG  size;
{
    extern int Loc;
    extern SLOT *term_space;
    extern LONG next_term, PURE_CODE_MARKER;
    LONG *objsize;
    char *buffer; 

    buffer = (char *)pReadVar;
    objsize = (LONG *)buffer;
    if (*objsize == 0)
    {
	OsPrint("No Pure code: error receiving read only vars \n");
	exit(1);
    }
    term_space = (SLOT *) OsAllocInit(sizeof(SLOT) * maxTerm);
    if (term_space == NULL)
    {
	OsPrint("error during initialization in termspace allocation\n");
	OsPrint("execution aborted\n");
	exit(1);
    }
    next_term = (*objsize - 1)/ sizeof(SLOT); 
    Relocate((SLOT *)(objsize + 1), term_space, next_term, term_space);
    PURE_CODE_MARKER = next_term;
    if (DEBUG)
        OsPrintf("%d pure code slots read\n", PURE_CODE_MARKER);
    if( (Loc=LoadBytecode( &buffer[*objsize], size - *objsize )) == -1 ) 
        exit(1);
    if (DEBUG)
        OsPrint("%d byte code instructions read\n\n", Loc);
}


UsrSetBoundVar(num, ptr, Fun)
LONG num;
LONG *ptr;
LONG *Fun;
{
}



UsrPackMsg(code,ptrMsg,ptrNew,pSize,maxSize)
MESSAGE *ptrMsg, *ptrNew;
int	code,*pSize,maxSize;
{
    MESSAGE *PackMessage();

    COPY_MESSAGES(ptrNew,ptrMsg);
    *pSize = sizeof(MESSAGE); 
    if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL  || IS_RESP_DATA(ptrMsg)) 
        PackMessage(ptrMsg,ptrNew,pSize);

    if (*pSize >= maxSize) {
	OsPrintf("pack buffer is too small, need %d\n",*pSize);
	OsKillSys();
	}
}

UsrUnpackMsg(code,ptrMsg)
MESSAGE *ptrMsg;
int code;
{
    if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL || IS_RESP_DATA(ptrMsg))
          UnpackMessage(ptrMsg);
    if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL)  packedGoal++;

    if (DEBUG)
    { 
        if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL)  {
	    OsPrintf("Unpacked  Goal: ");
	    PrintTerm(ptrMsg->goalterm, ptrMsg->goalResp); 
	}
        else if (IS_RESP_DATA(ptrMsg)) {
	    OsPrintf("Unpacked Resp: \n");
	    BePrintTuple(ptrMsg->goalResp);
        }
	else OsPrintf("Unpacked Control Message");
	OsPrintf("\n");
    }
}


UsrInitMsg(pMsg, CDsize)
MESSAGE **pMsg;
int *CDsize;  /* not used in ROPM */

{
    SLOT *term;
    SLOT *tuple;
    MESSAGE *RopmFirstMsg();


    Malloc_Slots(term,1);
    INSERT_CLOSED_TERM(term, MainFunctor(), 0);
    *pMsg = (MESSAGE *) RopmFirstMsg();
    (*pMsg)->goalterm = term;
    (*pMsg)->BCEntrypt = MainEntryPt();
    if (MainEntryPt() == -1)
    {
	OsPrintf("no query in program.\n");
	exit();
    }
    if (DEBUG)
       OsPrintf("address of top level term is %x\n",term);
    *CDsize = sizeof(LocalArea);
}






UsrPrg(Entrypt, Msgptr, Dataptr)
SHORT Entrypt;
MESSAGE *Msgptr;
LocalArea *Dataptr;
{
    extern Instruction *Instr;

    if (Entrypt == ENTRYPT_FIRST)
    {
	MESSAGE *pMsg;
	int CDsize;
	PVECTOR *Priority;

	UsrInitMsg(&pMsg, &CDsize);
	if (DEBUG)
            OsPrintf("Entry Pt. after Init Msg created is %d\n",
		     pMsg->BCEntrypt);
	Priority = pMsg->priority_vector;
	CreateChareGen(ENTRYPT_REST,pMsg, sizeof(MESSAGE), CDsize, Priority, TRUE);
    }
    else  /* Entrypt = ENTRYPT_REST */
    {
	if (DEBUG)
	{
	     int i, bcentrypt = Msgptr->BCEntrypt;

	     OsPrintf("message has term 0x%x\n",Msgptr->goalterm);
	     OsPrintf("PE %d :Instr %d has opcode %d, numargs %d, args: ", 
			OsMyPeNum(), bcentrypt, 
			Instr[Entrypt].opcode, Instr[bcentrypt].argCount);
	     for (i = 0; i < Instr[bcentrypt].argCount; i++)
	         OsPrintf("%d ", Instr[bcentrypt].arg[i]);

	     OsPrintf("\n");
	}
	if (MSGMAINTYPE(Msgptr) != MSGTYPE_RESP || (IS_RESP_DATA(Msgptr)))
	BCInterp(Msgptr->BCEntrypt, Msgptr, Dataptr);
	if (MSGMAINTYPE(Msgptr) == MSGTYPE_RESP)
	    RopmRespCheck(Msgptr, Dataptr);

    }
    Free_Message(Msgptr); 
}


