#include "typedefs.h"
#include "pgm_typedefs.h"
#include "pgm.h"
#include "macros.c"
#include "pgm_macros.c"
#include "cg.h"
#include "instruct.h"


/*======================================================================
 *		EmitSeqHead - generate code for a clause
 *
 *		define an entry point for the clause.  emit code to unify with
 *		head of the clause and fire first node of djg if unification is
 *		successful.  jump to next clause of procedure if unification fails.
 *
 *		if fact, write fact template and exit.
 *		if clause, write clause header and emit code for body.
 *
 *			Unify		FailAddr, PureCode, #vars
 *			FireArc	arc#, RespEntry, PureCode
 *=====================================================================*/

EmitSeqHead(clause,ismain, nextEntry)
CLAUSE *clause; 
BOOLEAN ismain;
LONG *nextEntry;

{  
    TRACE(OsPrint("PROCESSING CLAUSE %d\n", clause));
    TRACE(PrintClause( clause ));

    *nextEntry = GenArcLabel();

/*  SetLabel( clause,SEQHEAD );   make entry point for fact */
    Emit(Enter,"pdl",clause->lit_position[0], clause->num_vars,
	 clause, *nextEntry);
    EmitSeqUnify( clause );
}


LOCAL EmitSeqUnify( c )
CLAUSE *c;
{
	LONG varsunified = 0;  /* bit vector of vars that have been unified */
	LONG contAddr;
	SHORT depth = Depth(c->lit_position[0]) - 1;

	contAddr = GenArcLabel();
	if (depth > MOLECSTACKSIZE)
	    Emit( AllocateBlock, "d", depth-1 ); 
	SeqDescend(c->lit_position[0],contAddr, c, 0 , &varsunified);
	if (depth > MOLECSTACKSIZE)
	    Emit( FreeBlock, "d", depth-1 ); 
	SetLabel( c, contAddr );
}


LOCAL SeqDescend( term, nextArgAddr, c, depth, varsunified )
SLOT *term;
LONG nextArgAddr;
CLAUSE *c;
LONG depth, *varsunified;
{
    LONG arity;
    LONG i;

    switch(SLOT_TAG( term )) 
    {
    case FUNCTOR:
    case CLOSED_TERM:
	{
	    LONG argLabel;

	    arity = ARITY( term );
	    if (arity == 0)
	    {
		if (depth)
		    Emit( SUnifyAtom,  "p", term);
		break;
	    }  
	    argLabel = GenArcLabel();	/* address of unify for next 
					   argument */
	    if( depth )
	        Emit( SUnifyStrct, "pld", term, c, argLabel, depth);
	    for( i = 1; i <= arity; i++ )
	        SeqDescend( term + i, argLabel, c, depth+1, varsunified );
	    if( depth ) Emit( PopStack, "d", MOLECSTACK ); 
	        SetLabel( c, argLabel );
	    break;
	}
	case TUPLE_INDEX_1:
	    if( c->num_nodes > 1 && IS_GROUND( c, INDEX(term) ) )
	        Emit( SUnifyGround, "d", INDEX(term));
	    else if (*varsunified & (1 << INDEX(term)))
	        Emit( SUnifyVar, "d", INDEX(term));
	    else
	    {
		*varsunified |= (1 << INDEX(term));
		Emit( SUnify1stVar, "d", INDEX(term));  
	    }
	    break;
	case INTEGER:
	    Emit( SUnifyCon, "d", INTVALUE(term));
	    break;
	case REAL:
	    Emit( SUnifyCon, "d", REALVALUE(term));
	    break;
	case ABSOLUTE_ADDRESS:
	    SeqDescend( ABS_ADDRESS( term ), nextArgAddr, 
		       c, depth, varsunified );
	    break;
	default:
	    OsPrint(" unknown term type %d\n", SLOT_TAG(term) );
    }
}




/*=====  returns nesting depth of a term  =====*/

LOCAL Depth( term )
SLOT *term;
{
	LONG arity, maxDepth, i, d;

	if( TAG_IS_FUNCTOR( term )) {
		maxDepth = 0;
		arity = ARITY( term );
		if (arity == 0) 
		    return 0;
		for( i = 1; i <= arity; i++ ) {
			d = Depth( term + i );
			if( d > maxDepth )
				maxDepth = d;
		}
		return maxDepth + 1;
	}
	else if( TAG_IS_ADDRESS( term ))
		return Depth( ABS_ADDRESS( term ) );
	else return 0;
}
