
#include "typedefs.h"
#include "pgm_typedefs.h"
#include "pgm.h"
#include "macros.c"
#include "pgm_macros.c"
#include "cg.h"
#include "instruct.h"
#include "bit_macros.c"

/*======================================================================
 *		EmitHead - generate code for a clause
 *
 *		define an entry point for the clause.  emit code to unify with
 *		head of the clause and fire first node of djg if unification is
 *		successful.  jump to next clause of procedure if unification fails.
 *
 *		if fact, write fact template and exit.
 *		if clause, write clause header and emit code for body.
 *
 *			Unify		FailAddr, PureCode, #vars
 *			FireArc	arc#, RespEntry, PureCode
 *=====================================================================*/

EmitHead(clause, ismain, arcsFired, allbuiltin, nextEntry, mutexjump,
	 statusbits)
CLAUSE *clause; 
BOOLEAN ismain;
LONG *arcsFired;
BOOLEAN *allbuiltin;
LONG nextEntry;
LONG mutexjump;
LONG statusbits;
{  
	SHORT bodylit, i;
	LONG mark;
	SLOT *tuple;
	extern SHORT MAXLINKSINPROGRAM;
	LONG tempvector;

	TRACE(OsPrint("PROCESSING CLAUSE %d\n", clause));
	TRACE(PrintClause( clause ));

	/*===== clause is fact =====*/
	if( clause->num_arcs == 0 ) {
		Emit(GetFactEnv,"pd",clause->lit_position[0], clause->num_vars);
		EmitUnify( clause, nextEntry );
		Emit( SendFactResp, "dl", MAXLINKSINPROGRAM,clause, mutexjump);
		*arcsFired = 0;
	}

	/*===== clause is nonfact ======*/
	else 
	{
	    Emit( GetClauseEnv, "pd", clause->lit_position[0], clause->num_vars);  
	    EmitUnify( clause, nextEntry );
	    CloseHeadVars( clause );
/*	    emit( AfterUnifPrint );   debugging only */
	    *arcsFired = Fire(clause, 0, nextEntry, TRUE, FALSE, ismain,
			      statusbits);
	    
	    for (*allbuiltin = TRUE,i = 0; i < clause->num_arcs; i++)
		*allbuiltin &=  (BitInVector1W(*arcsFired, i) && 
				 clause->builtin_index[i+1] != 0);
	    if (!ismain)
	        Emit( Succeed, "l", clause, mutexjump );
	}
}


LOCAL EmitUnify( c, failAddr )
CLAUSE *c;
LONG failAddr;

{
	LONG varsunified = 0;  /* bit vectore of vars that have been unified */
	LONG contAddr;
	SHORT depth = Depth(c->lit_position[0]) - 1;
	int tupsize = HeadTupSize(c);

	contAddr = GenArcLabel();
/*	emit( BeforeUnifPrint );       for debugging only  */
	if (depth > MOLECSTACKSIZE)
	    Emit( AllocateBlock, "d", depth-1 );  
	Descend( c->lit_position[0], contAddr, failAddr, c, 0 , &varsunified);
	if (depth > MOLECSTACKSIZE)
	    Emit( FreeBlock, "d", depth-1 );  
	SetLabel( c, contAddr );
}


LOCAL Descend( term, nextArgAddr, failAddr, c, depth, varsunified )
SLOT *term;
LONG nextArgAddr, failAddr;
CLAUSE *c;
LONG depth, *varsunified;
{
	LONG arity;
	LONG i;

	switch(SLOT_TAG( term )) {
	case FUNCTOR:
	case CLOSED_TERM:
	{
		LONG argLabel;

		arity = ARITY( term );
		if (arity == 0)
		{
		    if (depth)
		        Emit( UnifyAtom,  "pl", term, c, failAddr );
		    break;
		}  
		argLabel = GenArcLabel();	/* address of unify for next 
						   argument */
		if( depth )
		     Emit( UnifyStrct, "plld", term, c, argLabel, c, failAddr,
			   depth);
		for( i = 1; i <= arity; i++ )
			Descend( term + i, argLabel, failAddr, c, depth+1, varsunified );
		if( depth ) Emit( PopStack , "d", MOLECSTACK); 
		SetLabel( c, argLabel );
		break;
	}
	case TUPLE_INDEX_1:
		if( c->num_nodes > 1 && IS_GROUND( c, INDEX(term) ) )
			Emit( UnifyGround, "dl", INDEX(term), c, failAddr );
		else if (*varsunified & (1 << INDEX(term)))
		    Emit( UnifyVar, "dl", INDEX(term), c, failAddr );
		else
		{
		    *varsunified |= (1 << INDEX(term));
		    Emit( Unify1stVar, "dl", INDEX(term), c, failAddr );  
		}
		break;
	case INTEGER:
		Emit( UnifyCon, "dl", INTVALUE(term), c, failAddr );
		break;
	case REAL:
		Emit( UnifyCon, "dl", REALVALUE(term), failAddr );
		break;
	case ABSOLUTE_ADDRESS:
		Descend( ABS_ADDRESS( term ), nextArgAddr, 
			failAddr, c, depth, varsunified );
		break;
	/*case UNBOUND_VAR:
		Emit( UnifyVar, "d", (LONG)term );
		break;*/
	default:
		OsPrint(" unknown term type %d\n", SLOT_TAG(term) );
	}
}


/*
 *		CloseHeadVars - emit CloseVar for each var in clause head
 */

LOCAL CloseHeadVars( c )
CLAUSE *c;
{
	LONG mask;

	mask = 0;
	EmitClose( c, c->lit_position[0], &mask );
}



/*		recursively traverse clause head term, emitting CloseVar for
 *		each variable encountered.  only need to close a variable once,
 *		so maintain mask to handle vars appearing repeatedly in the term
 */

LOCAL EmitClose( c, term, closed )
CLAUSE *c;
SLOT *term;
LONG *closed;
{
	LONG i, arity;

	/*OsPrint("EmitClose: closed = %d\n", *closed );*/
	if( TAG_IS_TUPLE_INDEX_1( term ) && !IS_GROUND(c,INDEX(term)) ) {
		if( ((1<<INDEX(term)) & *closed) == 0) {
			Emit( CloseCVar, "d", INDEX( term ));
			*closed |= ( 1<<INDEX(term) );
		}
	}
	else if( TAG_IS_ADDRESS( term ))
		EmitClose( c, ABS_ADDRESS( term ), closed);
	if( TAG_IS_FUNCTOR( term )) {
		arity = ARITY( term );
		for( i = 1; i <= arity; i++ )
			EmitClose( c, term + i, closed );
	}
}


/*=====  returns nesting depth of a term  =====*/

LOCAL Depth( term )
SLOT *term;
{
	LONG arity, maxDepth, i, d;

	if( TAG_IS_FUNCTOR( term )) {
		maxDepth = 0;
		arity = ARITY( term );
		if (arity == 0) 
		    return 0;
		for( i = 1; i <= arity; i++ ) {
			d = Depth( term + i );
			if( d > maxDepth )
				maxDepth = d;
		}
		return maxDepth + 1;
	}
	else if( TAG_IS_ADDRESS( term ))
		return Depth( ABS_ADDRESS( term ) );
	else return 0;
}



/* ALL THE FOLLOWING CODE IS NOW REDUNDANT */
/*---------------------------------------------------------------------*/

LONG FireSuccessiveArcs( c, nextEntry, ismain, node, ishead, isjoin, 
			allbuiltin, statusbits)
CLAUSE *c;
LONG nextEntry;
BOOLEAN ismain;
SHORT node;
BOOLEAN ishead;        /* is this a call from EmitHead */
BOOLEAN isjoin;        /* is this a call from Join */
BOOLEAN *allbuiltin;
LONG statusbits;
{
    LONG arcsfired = 0, tmparcsfired;
    SHORT succnode, lit;
    BOOLEAN solnsent = FALSE;

    while (node != 1 && !(arcsfired & c->pred_arcs[1]))
    {
	TRACE(OsPrintf("In FireSuccessiveArcs: node %d\n", node));
	arcsfired |= Fire(c, node, nextEntry, ishead, isjoin, ismain, 
			  statusbits);
	node = c->succ_node[ARC(lit)];
	if(c->pred_count[node] > 1 )
	{
	    arcsfired |= EmitJoinCode(c, node, ismain, ARC(lit), statusbits);
	    break;
	}
    }
    *allbuiltin = (lit != 0);
    if (node == 1)
	if (!ismain && !solnsent)
	    emit( SendClauseResp );

    return arcsfired;
}


LONG EmitJoinCode(c, node, ismain, arc, statusbits)
CLAUSE *c;
SHORT node;
SHORT arc;
BOOLEAN ismain;
LONG statusbits;
{
    LONG arcsfired ;

    arcsfired |= Join(c, node, arc, ismain, statusbits);

    return arcsfired;
}

