/*
 *		ROPM code generator - header file
 *
 *		file gen.h contains additional items which are exported to the
 *		byte code executor.  this file contains code generator-specific
 *		typedefs and global variables.
 */

#include "gen.h" 

/*----------------------------------------------------------------------
 *		backpatch list
 *
 *		linked list of label references.  unresolved references are
 *		linked together in an IChain and backpatched when the label
 *		is defined.
 *--------------------------------------------------------------------*/

typedef struct s_IChain {
	Instruction *instr;	/* instruction containing the reference */
	SHORT arg;		/* which argument */
	struct s_IChain *next;	/* next unresolved reference */
} IChain;

/*----------------------------------------------------------------------
 *		label
 *
 *		this structure provides for forward referencing of addresses
 *		during byte code generation.  a Label structure contains a
 *		"name", and an address which may be undefined (-1).  reference
 *		to a defined Label simply resolves to the address.  reference
 *		to an undefined Label causes the reference to be placed on an
 *		IChain list, and when the Label is defined the references on
 *		the IChain are backpatched.
 *
 *		the IChain refers to an argument of a byte code instruction, so
 *		this mechanism only works for address references made from
 *		instruction operands.
 *--------------------------------------------------------------------*/

typedef struct {
	LONG idClause;       /* symbol "name" is the pair (idClause,idArc) */
	SHORT idArc; 	     /* any convenient short integer */
	LONG address;	     /* location of this symbol */
	IChain *refChain;    /* linked list of unresolved references */
} Label;

/*----------------------------------------------------------------------
 *		entry point
 *
 *		the entry point table gives, for each procedure/arity, the address
 *		of the executable code for that procedure.  the label table is not
 *		sufficient because pgm has processed the clauses in reverse source
 *		order, and the first clause entered in the label table is not the 
 *		correct one if there are multiple clauses for the procedure.
 *----------------------------------------------------------------------*/

typedef LONG Entry;

/*----------------------------------------------------------------------
 *		global variables 
 *--------------------------------------------------------------------*/

Instruction	*Instr;
LONG			Loc;
Label			*Symtab;			/* symbol table */
Entry			*Entrytab;		/* entry point table */
LONG			*ArgSpace;		/* argument space */
LONG			*argPtr;			/* current arg space pointer */
LONG			*regMap;			/* register allocation map */
LONG			LabelCount;		/* number of labels in Symtab */


