/* THIS FILE HAS BEEN MODIFIED TO INCORPORATE OPTIMISATIONS FOR BUILTINS
   OCCURRING IN THE DJG. IN ADDITION, SOME OF THE OUTPUT HAS ALSO BEEN
   ADAPTED TO SUIT THE COMPILER FOR PARALLEL PROLOG. HOWEVER, THESE
   CHANGES HAVE ONLY BEEN MADE TO THE MAXJOIN <= 2 VERSION OF THE CODE.

   							-  RAM  8/4/89  */

#include "typedefs.h"
#include "macros.c"
#include "pgm_macros.c"
#include "pgm_typedefs.h"
#include "bit_macros.c"

/* MaxCa is max number of pairs of arcs joining at a single node */
/* Ex: if 4 arcs join at a node, there are 6 pairs of arcs */
#define MaxCa (MaxJoin * (MaxJoin - 1) / 2)

/*
Multiple-Word Bit-Vectors --
Determining how much space to allocate for the vector allocation block:

                      MAXIMUM                 MAXIMUM
VECTOR              ARRAY LENGTH           VECTOR LENGTH

pred.nodes          MaxNodes               (MaxNodes / LONGLENGTH + 2)
node_path           MaxNodes                         "
arc_path            MaxArcs                          "
arc_backpointers   MaxArcs                          "
node_backpointers  MaxNodes                         "

Only one of the following is ever used : use larger to compute BLOCKLEN
common_ancestors    MaxNodes                         "  (MaxJoin <= 2)
       OR
common_ancestors    MaxNodes * MaxCa                 "  (MaxJoin > 2)

miscellaneous       8                                "
-----------------   ---------------------      ---------------------
BLOCKLEN   =    ((3 + MaxCa) * MaxNodes + 8) * (MaxNodes/LONGLENGTH + 2)

*/

#define BLOCKLEN ((MaxNodes / LONGLENGTH + 2) * ((3 + MaxCa) * MaxNodes + 8))

extern SHORT VLEN_N, VLEN_A, VLEN_V;

typedef struct 
	{
	VECTOR *nodes[MaxNodes];
        SHORT count[MaxNodes];
        } PRED;

static struct
	{
	SHORT count;
	SHORT node[MaxNodes];
	} RCA[MaxNodes];


#if (MaxJoin > 2)
typedef struct
	{
	SHORT num_pairs;
        SHORT arc1[MaxCa], arc2[MaxCa];
	SHORT num_ca[MaxCa];
	VECTOR *ca[MaxCa];
	} NODE_CA;
#endif

#if (MaxJoin <= 2)
Common_Ancestor_Info(c)
CLAUSE *c;
    {
    SHORT node_order[MaxNodes];
    LONG block[BLOCKLEN];
    SHORT top=0;
    VECTOR *node_path[MaxNodes]; /* node_path[K] = nodes on path to node K */
    VECTOR *arc_path[MaxArcs];  /* arc_path[K] = nodes on path to arc K */
    VECTOR *arc_backpointers[MaxArcs];/* Tuple pointers needed in arc K*/
    VECTOR *node_backpointers[MaxNodes];/* Pointers in node K */
    PRED pred; /* nodes preceding each node in the graph */
    VECTOR *common_ancestors[MaxNodes];  /* Common Ancestors of node K */
    SHORT CA_count[MaxNodes];     /* Number of common ancestors of node K */

#ifdef PRIORITY
    CaNodeDistance(c);
#endif
    c->sequential = Seq_Check(c);
    if (c->sequential)
       {
       TRACE2(printf("Sequential Graph\n"));
       return(0);
       }
    check(c);
    TRACE2(nodepr(c));
    NodeTopSort(c, node_order);
    CA_AllocateVectors(c, block, &top, node_path, arc_path, 
		arc_backpointers, node_backpointers, &pred, common_ancestors);
    Label(c, node_order, arc_path, node_path);
    Compute_CA(c, arc_path, common_ancestors);
    Reduce_CA(c, node_order, block, &top, node_path, 
			common_ancestors, CA_count);
    TRACE2(prca(c, common_ancestors));
    Tuple_Pointers(c, node_order, block, &top, node_backpointers,
		arc_backpointers, arc_path, common_ancestors);
    Optimize_TP(c, node_order, node_backpointers, arc_backpointers, 
			block, &top, common_ancestors, CA_count, arc_path);  
    TRACE2(prtp(c, node_backpointers));
    OptimiseCAforBuiltins(c, node_backpointers, arc_path, common_ancestors,
			  CA_count); 
    ArcOutput(c, node_backpointers, common_ancestors, CA_count);
    NodeOutput(c, &pred, node_backpointers, common_ancestors, CA_count);
    OptimiseLinkInfoForBuiltins(c); 
    TRACE2(prap(c));  /* arc output */
    TRACE2(prex(c, node_backpointers));  /* node output */
    }
#else
Common_Ancestor_Info(c)
CLAUSE *c;
    {
    SHORT node_order[MaxNodes];
    LONG block[BLOCKLEN];
    SHORT top=0;
    VECTOR *node_path[MaxNodes]; /* node_path[K] = nodes on path to node K */
    VECTOR *arc_path[MaxArcs];  /* arc_path[K] = nodes on path to arc K */
    VECTOR *arc_backpointers[MaxArcs];/* Tuple pointers needed in arc K*/
    VECTOR *node_backpointers[MaxNodes];/* Pointers in node K */
    PRED pred; /* nodes preceding each node in the graph */
    NODE_CA common_ancestors[MaxNodes];

#ifdef PRIORITY
    CaNodeDistance(c);
#endif
    c->sequential = Seq_Check(c);
    if (c->sequential == TRUE)
       {
       TRACE2(printf("Sequential Graph\n"));
       return(0);
       }
    check(c);
    TRACE2(nodepr(c));
    NodeTopSort(c, node_order);
    CA_AllocateVectors(c, block, &top, node_path, arc_path, 
		arc_backpointers, node_backpointers, &pred, common_ancestors);
    Label(c, node_order, arc_path, node_path);
    Compute_CA(c, arc_path, common_ancestors);
    Reduce_CA(c, node_order, block, &top, node_path, common_ancestors);
    TRACE2(prca(c, common_ancestors));
    Tuple_Pointers(c, node_order, block, &top, node_backpointers,
		arc_backpointers, arc_path, common_ancestors);
    TRACE2(prtp(c, node_backpointers));
    OptimiseCAforBuiltins(c, node_backpointers, arc_path, common_ancestors,
			  CA_count); 
    ArcOutput(c, node_backpointers, common_ancestors);
    TRACE2(prap(c));
    NodeOutput(c, &pred, node_backpointers, common_ancestors);
    TRACE2(prex(c, node_backpointers));
    }
#endif

Seq_Check(c)
CLAUSE *c;
   {
   SHORT i, Result;

   Result = TRUE;
   for (i=0; i<c->num_nodes; i++)
      {
      if (c->succ_count[i] > 1)
         {
         Result = FALSE;
         break;
         }
      }
   return Result;
   }

check(c)
CLAUSE *c;
   {
   SHORT i;
   for (i=0; i<c->num_nodes; i++)
      {
      if ((c->pred_count[i] > MaxJoin))
         {
         fprintf(stderr,"Error: Node %d has in-degree higher than %d.\n"
		 	,i, MaxJoin);
         fprintf(stderr,"To use this graph, increase MaxJoin and recompile.\n");
         exit(1);
         }
      }
   }


/* CA_AllocateVectors()
 *
 * 
 */

#if (MaxJoin <= 2)
CA_AllocateVectors(c, block, ptop, node_path, arc_path, arc_backpointers,
		node_backpointers, ptr_pred, common_ancestors)
CLAUSE *c;
LONG block[];
SHORT *ptop;
VECTOR *node_path[], *arc_path[], *arc_backpointers[];
VECTOR *node_backpointers[], *common_ancestors[];
PRED *ptr_pred;
   {
   ArrayAlloc(block, (*ptop), BLOCKLEN, node_path, VLEN_N, MaxNodes);
   ArrayAlloc(block, (*ptop), BLOCKLEN, arc_path, VLEN_N, MaxArcs);
   ArrayAlloc(block, (*ptop), BLOCKLEN, arc_backpointers, VLEN_N, MaxArcs);
   ArrayAlloc(block, (*ptop), BLOCKLEN, node_backpointers,VLEN_N, MaxNodes);
   ArrayAlloc(block, (*ptop), BLOCKLEN, (*ptr_pred).nodes, VLEN_N, MaxNodes);

   CA_ArrayAlloc(block, ptop, common_ancestors);
   }
#else
CA_AllocateVectors(c, block, ptop, node_path, arc_path, arc_backpointers,
		node_backpointers, ptr_pred, common_ancestors)
CLAUSE *c;
LONG block[];
SHORT *ptop;
VECTOR *node_path[], *arc_path[], *arc_backpointers[];
VECTOR *node_backpointers[];
PRED *ptr_pred;
NODE_CA common_ancestors[];
   {
   ArrayAlloc(block, (*ptop), BLOCKLEN, node_path, VLEN_N, MaxNodes);
   ArrayAlloc(block, (*ptop), BLOCKLEN, arc_path, VLEN_N, MaxArcs);
   ArrayAlloc(block, (*ptop), BLOCKLEN, arc_backpointers, VLEN_N, MaxArcs);
   ArrayAlloc(block, (*ptop), BLOCKLEN, node_backpointers,VLEN_N, MaxNodes);
   ArrayAlloc(block, (*ptop), BLOCKLEN, (*ptr_pred).nodes, VLEN_N, MaxNodes);

   CA_ArrayAlloc(block, ptop, common_ancestors);
   }
#endif

#if (MaxJoin <=2)
CA_ArrayAlloc(block, ptop, common_ancestors)
LONG block[];
SHORT *ptop;
VECTOR *common_ancestors[];
   {
   ArrayAlloc(block,(*ptop),BLOCKLEN,common_ancestors,VLEN_N,MaxNodes);
   }
#else
CA_ArrayAlloc(block, ptop, common_ancestors)
LONG block[];
SHORT *ptop;
NODE_CA common_ancestors[];
   {
   SHORT i;
   for (i=0; i<MaxNodes; i++)
      {
      ArrayAlloc(block,(*ptop),BLOCKLEN,common_ancestors[i].ca,
		VLEN_N, MaxCa);
      }
   }
#endif


/* NodeTopSort()
 * 
 * Sort the nodes of a clause into Topological Order. 
 */

NodeTopSort(c, node_order)
CLAUSE *c;
SHORT node_order[];
  {
  SHORT arc_visited[MaxArcs];
  SHORT node_visited[MaxNodes];
  SHORT i, j;

  /* Initializations */
  
  node_order[0] = 0;               /* Node 0 is always first */

  for (i=1; i<c->num_nodes; i++)  {
    node_visited[i] = FALSE;
    }
  for (i=0; i<c->num_arcs; i++)   {
    arc_visited[i] = FALSE;
    }
  j = c->num_nodes - 1;

  NodeTopSort2(c, 0, &j, node_visited, arc_visited, node_order);

  if (node_order[c->num_nodes-1] != 1)
      {
      fprintf(stderr,"Incorrect Node Numbers -- graph must end with node 1\n");
      exit(1);
      }
  }


/* NodeTopSort2:
 *
 * Recursively traverse the graph for a clause and 
 *     sort the nodes in Topological Order.
 */

NodeTopSort2(c, v, pj, node_visited, arc_visited, node_order)
CLAUSE *c;
SHORT v, *pj;
SHORT arc_visited[];
SHORT node_visited[];
SHORT node_order[];
    {
    SHORT e;

    for (e=0; e<c->num_arcs; e++)
        {
        if (BitInVector1W(c->succ_arcs[v],e))
            {
            if (arc_visited[e] == FALSE)  
                {
                arc_visited[e] = TRUE;
                NodeTopSort2(c, c->succ_node[e], pj, 
 			node_visited, arc_visited, node_order);
                if (node_visited[c->succ_node[e]] == FALSE)  
                    {
                    node_order[*pj] = c->succ_node[e];
                    node_visited[c->succ_node[e]] = TRUE;
                    (*pj)--;
                    }
                }
            }
        }
    } 


/*  Label()
 *
 *  Label each node of a clause with the nodes (including itself) along any 
 *      path from the start node to the node in question.  Label each arc in
 *      the clause with the nodes along any path from the start node to that
 *      arc.
 */

Label(c, node_order, arc_path, node_path)
CLAUSE *c;
SHORT node_order[];
VECTOR *arc_path[], *node_path[];
    {
    SHORT i, node, idx, good, vlen;
    LONG pred, succ;
    VECTOR *last; 

    /* Initializations */
    for (i=0; i<c->num_nodes; i++)
        {
        EmptyVector(node_path[i]);
        }

    for (i=0; i<c->num_nodes; i++)
        {
        node = node_order[i];  /* Traverse the graph in topological order */

      /* For each node, add path for each preceeding arc */
        pred = c->pred_arcs[node];
        for (idx=0; idx<LONGLENGTH; idx++)
            {
            if (BitInVector1W(pred,idx))
               {
               VectorUnion(node_path[node],node_path[node],arc_path[idx]);
               }
            }
               

      /* A node is on the path to itself */
        InsInVector(node_path[node], node);

      /* Path for successor arcs of a node
       * is the same as the path for the node.
       */
        succ = c->succ_arcs[node];
        for (idx=0; idx<LONGLENGTH; idx++)
            {
            if (BitInVector1W(succ, idx))
                {
                CopyVector(arc_path[idx], node_path[node]);
                }
            }
        } /* for (i... */

    /* Last node should have all nodes in its node_path */
    last = node_path[node_order[c->num_nodes - 1]];
    good = TRUE;
    for (i=0; i<c->num_nodes; i++)
       {
       if (!BitInVector(last,i))
          {
          good = FALSE;
          break;
          }
       }

    if (!good)
       {
       fprintf(stderr,"Incorect Node Labelling -- Function Label()\n");
       exit(1);
       }
    }

/* Vector_to_ints()
 *
 * Given a bit-vector, and a pointer to an array of integers, fill the
 *     array with the locations of the 1's in the bit-vector.
 */ 


Vector_to_ints1W(vector, ints, count)
LONG vector;
SHORT *ints, *count;
   {
   int idx=0, i=0;
   while(vector!=0)
      {
      while (!BitInVector1W(vector,idx)) idx++;
      *(ints + i) = idx;
      vector &= ~(1<<idx);
      i++;
      idx++;
      }
   *count = i;
   }

Vector_to_ints(vector, ints, count)
VECTOR *vector;
SHORT *ints, *count;
   {
   SHORT idx=0, i=0;
   for (idx=0; idx<(VectorLength(vector)<<WSHIFT); idx++)
      {
      if (BitInVector(vector,idx))
         {
         *(ints + i) = idx;
         i++;
         idx++;
         }
      }
   *count = i;
   }

/* vector_count()
 *
 * Count the number of 1's in a Bit-Vector.
 */ 

vector_count1W(vector)
LONG vector;
   {
   int idx=0, count=0;
   while (vector !=0)
      {
      while (!BitInVector1W(vector,idx)) idx++;
      count++;
      vector &= ~(1<<idx);
      idx++;
      }
   return count;
   }

vector_count(vector)
VECTOR *vector;
   {
   SHORT idx, count=0;
   for (idx=0; idx<(VectorLength(vector) << WSHIFT); idx++)
      {
      if (BitInVector(vector, idx))
         {
         count++;
         }
      }
   return count;
   }

/* Compute_CA()
 *
 * Compute the common ancestor nodes of all join nodes.  A node may
 *    have several common ancestors.  We are actualy computing the
 *    common ancestors of the *arcs* leading to a join node.  Nodes
 *    are restricted to have at most two predecessor arcs.
 */
#if (MaxJoin <= 2)
Compute_CA(c, arc_path, common_ancestors)
CLAUSE *c;
VECTOR *arc_path[], *common_ancestors[];
    {
    SHORT i, node, idx;
    LONG pred;

  /* Initializations */
    for (i=0; i<c->num_nodes; i++)
        {
        FillVector(common_ancestors[i]);
        }

  /* For each join node, compute the common ancestor nodes.
   * This is the intersection of the arc_path sets for each incoming arc. 
   */
    for (node=0; node<c->num_nodes; node++)
        {
        if (JOIN_NODE(c,node))
            {
            pred = c->pred_arcs[node];
            for (idx=0; idx<LONGLENGTH; idx++)
               {
               if (BitInVector1W(pred,idx))
                  {
                  VectorIntersect(common_ancestors[node],
			common_ancestors[node],arc_path[idx]);
                  }
               }
            }
        else
            {
            EmptyVector(common_ancestors[node]);
            }
        }
    }

#else
Compute_CA(c, arc_path, common_ancestors)
CLAUSE *c;
VECTOR *arc_path[];
NODE_CA common_ancestors[];
   {
   SHORT node, l, i, j;
   SHORT p_arcs[MaxJoin]; 
   SHORT p_arcs_count;
 
   for (node=0; node<c->num_nodes; node++)
      {
      if (JOIN_NODE(c,node))
         {
         Vector_to_ints1W(c->pred_arcs[node],p_arcs,&p_arcs_count);
         l=0;
         for (i=0; i<p_arcs_count-1; i++)
            {
            for (j=i+1; j<p_arcs_count; j++)
               {
               common_ancestors[node].arc1[l] = p_arcs[i];
               common_ancestors[node].arc2[l] = p_arcs[j];
               VectorIntersect(common_ancestors[node].ca[l],
                  arc_path[p_arcs[i]], arc_path[p_arcs[j]]);
               l++;
               }
            }
         common_ancestors[node].num_pairs = l;
         }
      }
   }
#endif


/* Reduce_CA()
 *
 * Using the common ancestor information produced by Compute_CA(), remove
 *    any common ancestor nodes which are not 'least'.  This will leave
 *    the Least Common Ancestor Nodes for each join node.
 */

#if (MaxJoin <= 2)
Reduce_CA(c, node_order, block, ptop, node_path, common_ancestors, CA_count)
CLAUSE *c;
SHORT node_order[], *ptop, CA_count[];
LONG block[];
VECTOR *node_path[], *common_ancestors[];
    {
    SHORT node, i, count, CA;
    VECTOR *lca;

    VectorAlloc(block, (*ptop), BLOCKLEN, lca, VLEN_N);

    for (node=0; node<c->num_nodes; node++)
        {
        if (JOIN_NODE(c,node))
            { /* join node */
            EmptyVector(lca);
            for (i=c->num_nodes-1; i>=0; i--)
               {
               if (BitInVector(common_ancestors[node], node_order[i]))
                  {
                  CA = node_order[i];
                  InsInVector(lca, CA);
                  VectorDifference(common_ancestors[node],
				common_ancestors[node], node_path[CA]);
                  }
               }
            CopyVector(common_ancestors[node], lca);
            }
        }

   /* Count number of common ancestors of each node */
    for (node=0; node<c->num_arcs; node++)
        {
        CA_count[node] = vector_count(common_ancestors[node]);
        }
    }
#else
Reduce_CA(c, node_order, block, ptop, node_path, common_ancestors)
CLAUSE *c;
SHORT node_order[], *ptop;
LONG block[];
VECTOR *node_path[];
NODE_CA common_ancestors[];
    {
    SHORT i, node, j, count, CA;
    VECTOR *lca;

    VectorAlloc(block, (*ptop), BLOCKLEN, lca, VLEN_N);

    for (node=0; node<c->num_nodes; node++)
        {
        if (JOIN_NODE(c,node))
            { /* join node */
            for (i=0; i<common_ancestors[node].num_pairs; i++)
                {
                EmptyVector(lca);
                for (j=c->num_nodes-1; j>=0; j--)
                   {
                   if (BitInVector(common_ancestors[node].ca[i], node_order[j]))
                      {
                      CA = node_order[j];
                      InsInVector(lca, CA);
                      VectorDifference(common_ancestors[node].ca[i],
			    common_ancestors[node].ca[i], node_path[CA]);
                      }
                   }
                CopyVector(common_ancestors[node].ca[i], lca);
                }
            }
        }

   /* Count number of common ancestors of each node */
    for (node=0; node<c->num_arcs; node++)
        {
        for (i=0; i<common_ancestors[node].num_pairs; i++)
            {
            common_ancestors[node].num_ca[i] = 
                vector_count(common_ancestors[node].ca[i]);
            }
        }
    }
#endif

PrVector1W(vector)
LONG vector;
   {
   SHORT idx;

   printf("[");
   if (vector != 0)
      {
      /* get first one */
      idx = 0;
      while (!BitInVector1W(vector,idx)) idx++;
      printf("%d",idx);
      vector &= ~(1<<idx);
      idx++;
      }
   while (vector != 0)
      {
      /* get rest */
      while (!BitInVector1W(vector,idx)) idx++;
      printf(", %d",idx);
      vector &= ~(1<<idx);
      }
   printf("]");
   }

PrVector(vector)
VECTOR *vector;
   {
   SHORT idx, First = TRUE;

   printf("[");
   for (idx=0; idx<(VectorLength(vector)<<WSHIFT) - 8 ; idx++)
      {
      if (BitInVector(vector, idx))
         {
         if (First == TRUE)
            {
            printf("%d",idx);
            First = FALSE;
            }
         else
            {
            printf(", %d",idx);
            }
         }
      }
   printf("]");
   }

#if (MaxJoin <= 2)
/* Print out Common Ancestors of Join Nodes */
prca(c, common_ancestors)
CLAUSE *c;
VECTOR *common_ancestors[];
    {
    SHORT i;

    printf("COMMON ANCESTORS OF ARCS LEADING TO JOIN NODES:\n");
    for (i=0; i<c->num_nodes; i++)
        {
        if (JOIN_NODE(c,i))
            {
            printf("Node %d: ",i);
            PrVector(common_ancestors[i]);
            printf("\n");
            }
        }
    printf("\n");
    }
#else
/* Print out Common Ancestors of Join Nodes */
prca(c, common_ancestors)
CLAUSE *c;
NODE_CA common_ancestors[];
    {
    int i, j, e1, e2;

    printf("COMMON ANCESTORS OF ARCS LEADING TO JOIN NODES:\n");
    for (i=0; i<c->num_nodes; i++)
        {
        if (JOIN_NODE(c,i))
            {
            if (common_ancestors[i].num_pairs > 0) printf("NODE %d\n",i);
            for (j=0; j<common_ancestors[i].num_pairs; j++)
                {
                e1 = common_ancestors[i].arc1[j];
                e2 = common_ancestors[i].arc2[j];
                printf("e%d,e%d : ",e1,e2);
                PrVector(common_ancestors[i].ca[j]);
                printf("\n");
                }
            if (common_ancestors[i].num_pairs > 0) printf("\n");
            }
        }
    }
#endif


/* Tuple_Pointers()
 *
 * Compute, for each arc, the tuple pointers which it needs to carry.
 *     For each node in the graph (working backwards topologically),
 *     determine, from outgoing arcs, what tuple pointers need to be
 *     dispersed over incoming arcs.  A node must *carry* pointers which 
 *     must be dispersed over its incoming arcs. Then compute tuple 
 *     pointers needed for each incoming arc.  Use the following rules:
 *
 *     For branch nodes, node must carry all pointers carried by all
 *     outgoing arcs, except for pointers to the node itself. For nodes
 *     with only one outgoing arc, the node must carry the same pointers
 *     that the arc does.
 *
 *     For join nodes, each incoming arc must carry pointers to the common 
 *     ancestor nodes.  Also, the pointers carried by the node must be
 *     dispersed over the incoming arcs.  If an incoming arc is chosen to
 *     carry a pointer which is carried by the node, the arc must be able
 *     to supply it (i.e. have the node pointed to in its arc_path).  For 
 *     nodes with only one incoming arc, the arc must carry the same pointers 
 *     as the node.
 */

#if (MaxJoin <= 2)
Tuple_Pointers(c, node_order, block, ptop, node_backpointers,
		arc_backpointers, arc_path, common_ancestors)
CLAUSE *c;
SHORT node_order[], *ptop;
LONG block[];
VECTOR *node_backpointers[], *arc_backpointers[];
VECTOR *arc_path[], *common_ancestors[];
    {
    SHORT node, i, idx, count;
    VECTOR *tuples_carried, *tuples_needed;

    for (i=0; i<c->num_nodes; i++)
        EmptyVector(node_backpointers[i]);
    for (i=0; i<c->num_arcs; i++)
        EmptyVector(arc_backpointers[i]);

    VectorAlloc(block,(*ptop),BLOCKLEN,tuples_carried, VLEN_N);
    VectorAlloc(block,(*ptop),BLOCKLEN,tuples_needed, VLEN_N);

    for (idx=c->num_nodes-1; idx>=1; idx--)
        {
        node = node_order[idx];

        /* arc to nodes */
        if (BRANCH_NODE(c,node))
            {
            count = c->succ_count[node];
            i = 0;
            while (count > 0)
                {
                if (BitInVector1W(c->succ_arcs[node],i)) 
                    {
                    VectorUnion(node_backpointers[node],
			node_backpointers[node], arc_backpointers[i]);
                    count--;
                    }
                i++;
                }
            DelFromVector(node_backpointers[node],node);
            }
        else 
            {
            if (c->succ_count[node] == 1)
                {
                i=0;
                while (!BitInVector1W(c->succ_arcs[node],i)) i++;
                CopyVector(node_backpointers[node], 
			arc_backpointers[i]);
                }
            }

        /* node to arcs */
        if (JOIN_NODE(c,node))
            {
            CopyVector(tuples_needed,node_backpointers[node]);
            count = c->pred_count[node];
            i = 0;
            while (count > 0)
                {
                if (BitInVector1W(c->pred_arcs[node],i))
                    {
                    VectorUnion(arc_backpointers[i],
			arc_backpointers[i],common_ancestors[node]);
                    VectorIntersect(tuples_carried,tuples_needed,
				arc_path[i]);
                    VectorUnion(arc_backpointers[i],
			arc_backpointers[i], tuples_carried);
                    VectorDifference(tuples_needed, tuples_needed,
					 tuples_carried);
                    count--;
                    }
                i++;
                }
            }
        else
            {
            if (c->pred_count[node] == 1)
                {
                i=0;
                while (!BitInVector1W(c->pred_arcs[node],i)) i++;
                CopyVector(arc_backpointers[i], 
			node_backpointers[node]);
                }
            }
        }
    }
#else
Tuple_Pointers(c, node_order, block, ptop, node_backpointers,
		arc_backpointers, arc_path, common_ancestors)
CLAUSE *c;
SHORT node_order[], *ptop;
LONG block[];
VECTOR *node_backpointers[], *arc_backpointers[], *arc_path[];
NODE_CA common_ancestors[];
    {
    SHORT node, i, idx, count, e1, e2;
    VECTOR *tuples_carried, *tuples_needed;

    for (i=0; i<c->num_nodes; i++)
        EmptyVector(node_backpointers[i]);
    for (i=0; i<c->num_arcs; i++)
        EmptyVector(arc_backpointers[i]);

    VectorAlloc(block,(*ptop),BLOCKLEN,tuples_carried, VLEN_N);
    VectorAlloc(block,(*ptop),BLOCKLEN,tuples_needed, VLEN_N);

    for (idx=c->num_nodes-1; idx>=1; idx--)
        {
        node = node_order[idx];

        /* arc to nodes */
        if (BRANCH_NODE(c,node))
            {
            count = c->succ_count[node];
            i = 0;
            while (count > 0)
                {
                if (BitInVector1W(c->succ_arcs[node],i))
                    {
                    VectorUnion(node_backpointers[node],
		     node_backpointers[node],arc_backpointers[i]);
                    count--;
                    }
                i++;
                }
            DelFromVector(node_backpointers[node],node);
            }
        else 
            {
            if (c->succ_count[node] == 1)
                {
                i=0;
                while (!BitInVector1W(c->succ_arcs[node],i)) i++;
                CopyVector(node_backpointers[node], 
			arc_backpointers[i]);
                }
            }

        /* node to arcs */
        if (JOIN_NODE(c,node))
            {
            for (i=0; i<common_ancestors[node].num_pairs; i++)
                {
                e1 = common_ancestors[node].arc1[i];
                e2 = common_ancestors[node].arc2[i];
                VectorUnion(arc_backpointers[e1],
		 arc_backpointers[e1],common_ancestors[node].ca[i]);
                VectorUnion(arc_backpointers[e2],
		 arc_backpointers[e2],common_ancestors[node].ca[i]);
                }

            CopyVector(tuples_needed,node_backpointers[node]);
            count = c->pred_count[node];
            i = 0;
            while (count > 0)
                {
                if (BitInVector1W(c->pred_arcs[node],i))
                    {
                    VectorIntersect(tuples_carried,tuples_needed,
				arc_path[i]);
                    VectorUnion(arc_backpointers[i],
			arc_backpointers[i], tuples_carried);
                    VectorDifference(tuples_needed, tuples_needed,
					 tuples_carried);
                    count--;
                    }
                i++;
                }
            }
        else
            {
            if (c->pred_count[node] == 1)
                {
                i=0;
                while (!BitInVector1W(c->pred_arcs[node],i)) i++;
                CopyVector(arc_backpointers[i], 
			node_backpointers[node]);
                }
            }
        }
    }
#endif

#if (MaxJoin <= 2)
Optimize_TP(c, node_order, node_backpointers, arc_backpointers, 
		block, ptop, common_ancestors, CA_count, arc_path)
CLAUSE *c;
SHORT node_order[];
VECTOR *node_backpointers[], *arc_backpointers[], 
       *common_ancestors[], *arc_path[];
LONG block[];
SHORT *ptop, CA_count[];
   {
   SHORT Changed;

   Rev_CA(c, common_ancestors, CA_count);
   Changed = Remove_Pointers(c, node_order, 
		node_backpointers, arc_backpointers, arc_path);
   Propagate_Removals(c, node_order, block, ptop, 
		arc_backpointers, node_backpointers);
   }
#endif

#if (MaxJoin <= 2)
Rev_CA(c, common_ancestors, CA_count)
CLAUSE *c;
VECTOR *common_ancestors[];
SHORT CA_count[];
{
    SHORT i, ca, ct;

    for (i=0; i<c->num_nodes; i++)
	RCA[i].count = 0;
    for (i=0; i<c->num_nodes; i++)
    {
	ct = CA_count[i];
	ca = 0;
	while (ct-- > 0)
	{
	    while (!BitInVector(common_ancestors[i], ca)) ca++;
	    RCA[ca].node[RCA[ca].count++] = i;
	    ca++; 
	}
    }
}

int Remove_Pointers(c, node_order,node_backpointers,arc_backpointers,arc_path)
CLAUSE *c;
SHORT node_order[];
VECTOR *node_backpointers[], *arc_backpointers[], *arc_path[];
   {
   SHORT changed = FALSE, node, nextrca, i, j, pcount, arc;

   for (i=0; i<c->num_nodes; i++)
      {
      node = node_order[i];

      if (BRANCH_NODE(c,node) && 
	  (vector_count(node_backpointers[node]) > 0))
         {
         changed = TRUE;
         for (j=0; j<RCA[node].count; j++)
            {
            nextrca = RCA[node].node[j];
         /* for each predecessor arc of nextrca, remove unnecessary pointers */
            pcount = c->pred_count[nextrca];
            arc = 0;
            while (pcount > 0)
	    {
		while (!BitInVector1W(c->pred_arcs[nextrca],arc)) arc++;
		VectorDifference(arc_backpointers[arc],
			arc_backpointers[arc], node_backpointers[node]);
		arc++;
		pcount--;
	    }
            } /* for (j ... */
         } /* if (BRANCH_NODE.... */
      } /* for (i=0 ... */
   return changed;
   }

Propagate_Removals(c, node_order, block, ptop, 
		arc_backpointers, node_backpointers)
CLAUSE *c;
SHORT node_order[];
LONG block[];
SHORT *ptop;
VECTOR *arc_backpointers[], *node_backpointers[];
   {
   SHORT idx, node, found, j, nextrca, pcount, arc, count, i;
   VECTOR *new, *diff, *t;

   VectorAlloc(block,(*ptop),BLOCKLEN,new, VLEN_N);
   VectorAlloc(block,(*ptop),BLOCKLEN,diff, VLEN_N);
   VectorAlloc(block,(*ptop),BLOCKLEN,t, VLEN_N);
   
   for (idx=c->num_nodes-2; idx>=0; idx--)
      {
      node = node_order[idx];
      EmptyVector(new);
      if (BRANCH_NODE(c,node))
      {
         count = c->succ_count[node];
         i = 0;
         while (count>0)
            {
            if (BitInVector1W(c->succ_arcs[node],i))
               {
               VectorUnion(new, new, arc_backpointers[i]);
               count--;
               }
            i++;
            }
         DelFromVector(new, node);
      }
      else if (c->succ_count[node] == 1)
      {
	  i=0;
	  while (!BitInVector1W(c->succ_arcs[node],i)) i++;
	  CopyVector(new, arc_backpointers[i]);
      }
      VectorDifference(diff, node_backpointers[node], new);

      if (vector_count(diff) > 0)
         {
         found = FALSE;
         for (j=0; j<RCA[node].count; j++)
            {
            nextrca = RCA[node].node[j];
            VectorIntersect(t, node_backpointers[nextrca], diff);
            if (vector_count(t) > 0)
               { /* Don't propagate past CA node */
               found = TRUE;
               break;
               }
            }
         if (found == FALSE)
            { /* Propagate Removal of Pointers */
            VectorDifference(node_backpointers[node],
		node_backpointers[node], diff);
            /* for each predecessor arc, subtract difference vector */
            pcount = c->pred_count[node];
            arc = 0;
            while (pcount > 0)
               {
               while (!BitInVector1W(c->pred_arcs[node],arc)) arc++;
               VectorDifference(arc_backpointers[arc],
			arc_backpointers[arc], diff);
               arc++;
               pcount--;
               }
            } /* if (found == FALSE) */
         } /* if (vector_count ... */
      } /* for (idx ... */
   }
#endif

/* Print the Tuple Pointers carried by each node */
prtp(c, node_backpointers)
CLAUSE *c;
VECTOR *node_backpointers[];
    {
    SHORT i;

    printf("TUPLE POINTERS CARRIED BY NODES (before optimization):\n");
    for (i=0; i<c->num_nodes; i++)
        {
        printf("TP[%d] = ",i);
        PrVector(node_backpointers[i]);
        printf("\n");
        }
    printf("\n");
    }

#if (MaxJoin <= 2)
prap(c)
CLAUSE *c;
    {
    SHORT i,j ;

    printf("\nFORWARD-BACKWARD INDICES FOR JOIN ARCS:\n");
    for (i=0; i<c->num_arcs; i++)
    {
        if (JOIN_NODE(c,c->succ_node[i]))
	{
            printf("Arc %d:: chainindex = %d,",i, 
		             c->ArcIndices[i].arclinkindex);
            printf(" <%d,%d,%d> ",i,c->ArcIndices[i].Pbptr_idx,
                   c->ArcIndices[i].fptr_other,c->ArcIndices[i].fptr_me);
            for (j=0; j<c->ArcIndices[i].MCA_num; j++)
                printf("<%d, %d> ",c->ArcIndices[i].MCA_me[j],
				c->ArcIndices[i].MCA_other[j]);
	    printf("\n");  
	}
    }
    printf("\n");
    }
#else
prap(c)
CLAUSE *c;
    {
    SHORT i, j, k;

    printf("FORWARD-BACKWARD INDICES FOR JOIN ARCS:\n");
    for (i=0; i<c->num_arcs; i++)
        {
        if (c->ArcIndices[i].numjoins > 0) printf("Arc%d::\n",i);
        for (k=0; k<c->ArcIndices[i].numjoins; k++)
            {
            printf("e%d: ", c->ArcIndices[i].joins_with[k]);
            printf("<%d,%d,%d> ",c->ArcIndices[i].Pbptr_idx[k],
                c->ArcIndices[i].fptr_other[k],c->ArcIndices[i].fptr_me[k]);
            for (j=0; j<c->ArcIndices[i].MCA_num[k]; j++)
                {
                printf("<%d, %d> ", c->ArcIndices[i].MCA_me[k][j],
				c->ArcIndices[i].MCA_other[k][j]);
                }
            printf("\n");
            }
        if (c->ArcIndices[i].numjoins > 0) printf("\n");
        }
    }
#endif

nodepr(c)
CLAUSE *c;
    {
    SHORT i;

    printf("GRAPH:\n");
    printf("Arcs Preceding the Following Nodes:\n");
    for (i=0; i<c->num_nodes; i++)
        {
	printf("node %d: ",i);
        PrVector1W(c->pred_arcs[i]);
        printf("\n");
        }
    printf("\n");
    printf("Arcs Succeeding the Following Nodes:\n");
    for (i=0; i<c->num_nodes; i++)
        {
	printf("node %d: ",i);
        PrVector1W(c->succ_arcs[i]);
        printf("\n");
        }
    printf("\n");
    }


/* ArcOutput()
 * 
 * For arcs leading to join nodes, determine where to find the backward- 
 *    and forward-pointers.  Pbptr_idx[arc] will contain an index into the
 *    previous nodes' tuple pointers array.  The backpointer found in this 
 *    location will point to the common ancestor node's forward pointer array.
 *    fptr_other[arc] will contain an index into this array.  The forward-
 *    pointer found here will point to the tuples relation for the (other)
 *    arc which leads to the join node. fptr_me[arc] specifies a pointer
 *    to the original arc's tuple relation.
 */

#if (MaxJoin <= 2)
ArcOutput(c, node_backpointers, common_ancestors, CA_count)
CLAUSE *c;
VECTOR *node_backpointers[], *common_ancestors[];
SHORT CA_count[];
    {
    SHORT i, arc, p1, p2, arc1, arc2, ca, k, l;
    SHORT back1, back2, node, count, num_CAs, idx;
    BOOLEAN AllBuiltinsInPath(), AllBuiltinsExceptOne();

    /* Initializations */
    for (i=0; i<c->num_nodes; i++)
        {
        c->fwd_ptr[i] = 0;
        }
    
    for (node=0; node<c->num_nodes; node++) {
	if (JOIN_NODE(c,node))  
	{
            count = c->pred_count[node];
            arc=0;
            ca=0;
            /* Find a predecessor arc */
            while (!BitInVector1W(c->pred_arcs[node],arc)) arc++;
            arc1 = arc++;
            while (!BitInVector1W(c->pred_arcs[node],arc)) arc++;
            arc2 = arc;

           /* Find a Common Ancestor Node */
            while (!BitInVector(common_ancestors[node],ca)) ca++;

           /* Compute position of forward pointers */
            c->ArcIndices[arc1].fptr_other = (c->fwd_ptr[ca])++;
            c->ArcIndices[arc2].fptr_other = (c->fwd_ptr[ca])++;
            c->ArcIndices[arc1].fptr_me = c->ArcIndices[arc2].fptr_other;
            c->ArcIndices[arc2].fptr_me = c->ArcIndices[arc1].fptr_other;

            p1 = c->pred_node[arc1];
            p2 = c->pred_node[arc2];

           /* Compute position of primary backpointer */
	    if (AllBuiltinsInPath(c, ca, p1))
	        if (c->builtin_index[arc1+1] != 0)   /* all builtins */
	             back1 = 2;     /* currenttuple == primary com. ances. */
	        else back1 = 1;     /* contexttuple == primary com. ances. */
	    else if (AllBuiltinsExceptOne(c, ca, p1) &&
		     c->builtin_index[arc1+1] != 0)   /* all builtins  */
	        back1 = 1; 	    /* contexttuple == primary com. ances. */
	    else 
	    {
		p1 = FindBackPtrCarrier(node_backpointers, c, ca, p1);
		back1 = 0;
		for (k=0; k<ca; k++)
		if (BitInVector(node_backpointers[p1],k))
		    back1--;    /* back pointer indices are negative */
	    }

	    if (AllBuiltinsInPath(c, ca, p2))
	        if (c->builtin_index[arc2+1] != 0)   /* all builtins */
	             back2 = 2;     /* currenttuple == primary com. ances. */
	        else back2 = 1;     /* contexttuple == primary com. ances. */
	    else if (AllBuiltinsExceptOne(c, ca, p2) &&
		     c->builtin_index[arc2+1] != 0)   /* all builtins  */
	        back2 = 1;          /* contexttuple == primary com. ances. */
	    else 
	    {
		p2 = FindBackPtrCarrier(node_backpointers, c, ca, p2);
		back2 = 0;
		for (k=0; k<ca; k++)
		if (BitInVector(node_backpointers[p2],k))
		    back2--;	 /* back pointer indices are negative */
	    }

            c->ArcIndices[arc1].Pbptr_idx = back1;
            c->ArcIndices[arc2].Pbptr_idx = back2;

	    c->ArcIndices[arc1].MCA_num = CA_count[node]-1;
	    c->ArcIndices[arc2].MCA_num = CA_count[node]-1;
            if (CA_count[node] > 1)
	    { 
                palloc(LONG,c->ArcIndices[arc1].MCA_num,c->ArcIndices[arc1].MCA_me);
                palloc(LONG,c->ArcIndices[arc2].MCA_num,c->ArcIndices[arc2].MCA_me);
                palloc(LONG,c->ArcIndices[arc1].MCA_num,c->ArcIndices[arc1].MCA_other);
                palloc(LONG,c->ArcIndices[arc2].MCA_num,c->ArcIndices[arc2].MCA_other);
	    }
          /* Compute positions of backpointers for multiple CAs */
            ca++;
            for (l=0; l<CA_count[node]-1; l++)
                {
                while(!BitInVector(common_ancestors[node],ca)) ca++;

               /* Compute position of primary backpointer */

		if (AllBuiltinsInPath(c, ca, p1))
		    if (c->builtin_index[arc1+1] != 0)   /* all builtins  */
		         back1 = 2;  /* currenttuple == primary com. ances. */
		    else back1 = 1;  /* contexttuple == primary com. ances. */
		else if (AllBuiltinsExceptOne(c, ca, p1) &&
			 c->builtin_index[arc1+1] != 0)  /* all builtins */
		    back1 = 1;       /* contexttuple == primary com. ances.  */
 		else 
		{
		    p1 = FindBackPtrCarrier(node_backpointers, c, ca, p1);
		    back1 = 0;
		    for (k=0; k<ca; k++)
		    if (BitInVector(node_backpointers[p1],k))
		        back1--;     /* back pointer indices are negative */
		}

		if (AllBuiltinsInPath(c, ca, p2))
		    if (c->builtin_index[arc2+1] != 0)   /* all builtins */
		         back2 = 2;  /* currenttuple == primary com. ances. */
		    else back2 = 1;  /* contexttuple == primary com. ances. */
		else if (AllBuiltinsExceptOne(c, ca, p2) &&
			 c->builtin_index[arc2+1] != 0)  /* all builtins */
		    back2 = 1;  /* contexttuple == primary com. ances.  */
		else 
		{
		    p1 = FindBackPtrCarrier(node_backpointers, c, ca, p1);
		    back2 = 0;
		    for (k=0; k<ca; k++)
		    if (BitInVector(node_backpointers[p2],k))
		        back2--;     /* back pointer indices are negative */
		}

                c->ArcIndices[arc1].MCA_me[l] = back1;
                c->ArcIndices[arc2].MCA_me[l] = back2;
                c->ArcIndices[arc1].MCA_other[l] = back2;
                c->ArcIndices[arc2].MCA_other[l] = back1;
                ca++;
                }
            }
        }
    }
#else
ArcOutput(c, node_backpointers, common_ancestors)
CLAUSE *c;
VECTOR *node_backpointers[];
NODE_CA common_ancestors[];
    {
    SHORT i, ca, k, l, n1, n2, node, e1, e2, back1, back2, p1, p2;

    /* Initializations */
    for (i=0; i<c->num_nodes; i++)
        {
        c->fwd_ptr[i] = 0;
        }
    for (i=0; i<c->num_arcs; i++)
        {
        c->ArcIndices[i].numjoins=0;
        }
    
    for (node=0; node<c->num_nodes; node++)
        {
        if (JOIN_NODE(c,node))
            {
            for (i=0; i<common_ancestors[node].num_pairs; i++)
                {
                e1 = common_ancestors[node].arc1[i];
                e2 = common_ancestors[node].arc2[i];

                p1 = c->pred_node[e1];
                p2 = c->pred_node[e2];

               /* Find a Common Ancestor Node */
                ca=0;
                while (!BitInVector(common_ancestors[node].ca[i],ca)) ca++;

                n1 = c->ArcIndices[e1].numjoins++;
                n2 = c->ArcIndices[e2].numjoins++;

                c->ArcIndices[e1].joins_with[n1] = e2;
                c->ArcIndices[e2].joins_with[n2] = e1;

               /* Compute position of forward pointer */
                c->ArcIndices[e1].fptr_other[n1] = (c->fwd_ptr[ca])++;
                c->ArcIndices[e2].fptr_other[n2] = (c->fwd_ptr[ca])++;
                c->ArcIndices[e1].fptr_me[n1] = c->ArcIndices[e2].fptr_other[n2];
                c->ArcIndices[e2].fptr_me[n2] = c->ArcIndices[e1].fptr_other[n1];

               /* Compute position of primary backpointer */

                if (BitInVector(node_backpointers[p1],ca))
                    {
                    back1 = 0;
                    for (k=0; k<ca; k++)
                        {
                        if (BitInVector(node_backpointers[p1],k))
                           back1++;
                        }
                    }
		else back1 = -1; 
    
                if (BitInVector(node_backpointers[p2],ca))
                    {
                    back2 = 0;
                    for (k=0; k<ca; k++)
                        {
                        if (BitInVector(node_backpointers[p2],k))
                           back2++;
                        }
                    }
                else back2 = -1;

                c->ArcIndices[e1].Pbptr_idx[n1] = back1;
                c->ArcIndices[e2].Pbptr_idx[n2] = back2;

                if (common_ancestors[node].num_ca[i] > 1)
                    {
                    c->ArcIndices[e1].MCA_num[n1] =
                        common_ancestors[node].num_ca[i]-1;
                    c->ArcIndices[e2].MCA_num[n2] =
                        common_ancestors[node].num_ca[i]-1;
                    palloc(SHORT, c->ArcIndices[e1].MCA_num[n1], 
                                  c->ArcIndices[e1].MCA_me[n1]);
                    palloc(SHORT, c->ArcIndices[e2].MCA_num[n2], 
                                  c->ArcIndices[e2].MCA_me[n2]);
                    palloc(SHORT, c->ArcIndices[e1].MCA_num[n1], 
                                  c->ArcIndices[e1].MCA_other[n1]);
                    palloc(SHORT, c->ArcIndices[e2].MCA_num[n2], 
                                  c->ArcIndices[e2].MCA_other[n2]);
                    }

              /* Compute positions of backpointers for multiple CAs */
                ca++;
                for (l=0; l<common_ancestors[node].num_ca[i]-1; l++)
                    {
                    while(!BitInVector(common_ancestors[node].ca[i],ca)) ca++;
                    if (BitInVector(node_backpointers[p1],ca))
                        {
                        back1 = 0;
                        for (k=0; k<ca; k++)
                            {
                            if (BitInVector(node_backpointers[p1],k))
                               back1++;
                            }
                        }
                    else back1 = -1;
    
                    if (BitInVector(node_backpointers[p2],ca))
                        {
                        back2 = 0;
                        for (k=0; k<ca; k++)
                            {
                            if (BitInVector(node_backpointers[p2],k))
                               back2++;
                            }
                        }
                    else back2 = -1;

                    c->ArcIndices[e1].MCA_me[n1][l] = back1;
                    c->ArcIndices[e2].MCA_me[n2][l] = back2;
                    c->ArcIndices[e1].MCA_other[n1][l] = back2;
                    c->ArcIndices[e2].MCA_other[n2][l] = back1;
                    ca++;
                    }
                }
            }
        }
    }
#endif




FindBackPtrCarrier(node_backpointers, clause, ca, node)
VECTOR *node_backpointers[];
CLAUSE *clause;
SHORT ca, node;
{
    SHORT arc;

    if (BitInVector(node_backpointers[node],ca))
        return node;
    else
    {
	if (JOIN_NODE(clause, node))
	{
	    OsPrint("Error - arc backpointer not found\n");
	    exit(1);
	}
	arc = 0;
	while (!BitInVector1W(clause->pred_arcs[node],arc)) arc++;
	/* there should be only one arc */
	return (FindBackPtrCarrier(node_backpointers, clause, ca, clause->pred_node[arc]));
    }
}

prpn(c, ptr_pred)
CLAUSE *c;
PRED *ptr_pred;
   {
   SHORT i;

   printf("Predecessor nodes of: \n");
   for (i=0; i<c->num_nodes; i++)
      {
      printf("Node %d: ",i);
      PrVector((*ptr_pred).nodes[i]);
      printf("\n");
      }
   }




Find1stPredNode(c, node)
CLAUSE *c;
SHORT node;
{
    SHORT i, count = 0;
    SHORT arc;

    for(arc = 0; arc < VLEN_A; arc++)
	if (BitInVector1W(c->pred_arcs[node],arc))
	    break;
    return(c->pred_node[arc]);
}




/* NodeOutput()
 *
 * For each node, determine where to get the tuple pointers when a new
 *     tuple is inserted into the node relation.  The pointer needed
 *     may be in one of the backpointer relations of a predecessor node,
 *     or it may be the predecessor node itself.
 * 
 * The following encoding is used for a <NodeCode, Index> pair:
 *
 * 	Nodecode:  if it is a pred node, give its node number+1 : > 0
 *		   otherwise give an index <= 0 which suggests use the
 * 		   context tuple corresponding to the incident arc with 
 *		   smallest arc number, using indirection.
 *
 *	Index:    -1 -- parent tuple
 *		   i -- (i >= 0) ith back pointer in the tuple obtained via 
 *			 Nodecode.
 */

#if (MaxJoin <= 2)
NodeOutput(c, ptr_pred, node_backpointers, common_ancestors, CA_count)
CLAUSE *c;
PRED *ptr_pred;
VECTOR *node_backpointers[], *common_ancestors[];
SHORT CA_count[];
   {
   SHORT node, idx, found, i, pn,  count, ct, n, k, pcount, ca, arc;

 /* Initialize pred_nodes */
   for (i=0; i<c->num_nodes; i++)
      {
      EmptyVector((*ptr_pred).nodes[i]);
      (*ptr_pred).count[i] = 0;
      }

  /* Compute predecessor nodes for each node (bit-vector) */

   for (node=1; node<c->num_nodes; node++)
      {
      count = c->pred_count[node];
      idx=0;
      while (count>0)
         {
         if (BitInVector1W(c->pred_arcs[node],idx))
            {
            InsInVector((*ptr_pred).nodes[node],c->pred_node[idx]);
            (*ptr_pred).count[node]++;
            count--;
            }
         idx++;
         }
      }
   TRACE2(prpn(c, ptr_pred));

   /* Initialize NodeIndices */
   for (i=0; i<c->num_nodes; i++)
       c->NodeIndices[i].count = 0;

   for (node=2; node<c->num_nodes; node++)
      {
      for (idx=0; idx<VLEN_N; idx++)
         {
         if (BitInVector(node_backpointers[node],idx))
            {
            found = FALSE; /* Use this to stop searching once tuple is found */
            pcount = (*ptr_pred).count[node];
            pn = 0;
            while (pcount > 0)
	    { /* Look at each predecessor node */
               if (BitInVector((*ptr_pred).nodes[node],pn))
	       {
		   arc = 0;
		   while (!(BitInVector1W(c->succ_arcs[pn],arc) &&
			    BitInVector1W(c->pred_arcs[node],arc))) arc++;
                  pcount--;
                  if (pn == idx)
		  { 
		      /* Pointer needed is to pred node itself */
		      ct = c->NodeIndices[node].count++;
		      c->NodeIndices[node].nodecode[ct] = pn ;
		      if ( c->builtin_index[arc+1] != 0) /*  a builtin */
		           c->NodeIndices[node].index[ct] = 1; /* ctuple */
		      else c->NodeIndices[node].index[ct] = 2; /* context */
		      found = TRUE;
		      break;
		  }
                  if (BitInVector(node_backpointers[pn],idx))
		  { 
		      /* Pointer needed is in pred node's relation */
		      ct = c->NodeIndices[node].count++;
		      c->NodeIndices[node].nodecode[ct] = pn; 
		      n = 0;
		      for (k=0; k<idx; k++)
			  if (BitInVector(node_backpointers[pn],k))
			      n++;
		      c->NodeIndices[node].index[ct] = -n; /* note use of -  */
		      found = TRUE;			  /* for indirection */
		      break;
		  }
	       } /* if (BitInVector((*ptr_pred).nodes... */
               pn++;
	    } /* while (pcount > 0) */

            if (!found)
	    {
		/* Try_Common_Ancestors returns common ancestor else -1 */
               ca = Try_Common_Ancestors(c,node,idx,node_backpointers,
				common_ancestors, CA_count); 
	       pn = Find1stPredNode(c, node);  
	       if (found = (ca >= 0))
	       {
		   if (ca != idx)
		   {
		       /* pn definitely points to ca */
		       ct = c->NodeIndices[node].count++;
		       /* find which pn index points to ca  */
		       for (n=0,k=0; k<ca; k++)
		            if (BitInVector(node_backpointers[pn],k))
			        n++;
		       c->NodeIndices[node].nodecode[ct] = -n; /* note use of -
		   					     for indirection */
		   }
	       }
	       if (!found || ca == idx)
	       {
		   /* idx is in the path from ca to a join node or ca == idx */
		   ct = c->NodeIndices[node].count++;
		   c->NodeIndices[node].nodecode[ct] = pn;
		   arc = 0;
		   while (!(BitInVector1W(c->succ_arcs[pn],arc) &&
			    BitInVector1W(c->pred_arcs[node],arc))) arc++;
		   if ( AllBuiltinsInPath(c, idx, pn) &&
		        c->builtin_index[arc+1] != 0)  /* is a builtin */
		        c->NodeIndices[node].index[ct] = 1; /* ctuple */
		   else c->NodeIndices[node].index[ct] = 2; /* context */
	       }
	   }  /* if (!found) .. */
	} /* if (BitInVector(c->.... */
     } /* for (idx ...  */
  } /* for (node = 2 ... */
}
#else
/* change common_ancestors and I don't need this */
NodeOutput(c, ptr_pred, node_backpointers, common_ancestors)
CLAUSE *c;
PRED *ptr_pred;
VECTOR *node_backpointers[];
NODE_CA common_ancestors[];
   {
   SHORT node, idx, found, i, pn,  count, ct, n, k, pcount;

 /* Initialize pred_nodes */
   for (i=0; i<c->num_nodes; i++)
      {
      EmptyVector((*ptr_pred).nodes[i]);
      (*ptr_pred).count[i] = 0;
      }

  /* Compute predecessor nodes for each node (bit-vector) */
   for (node=1; node<c->num_nodes; node++)
      {
      count = c->pred_count[node];
      idx=0;
      while (count>0)
         {
         if (BitInVector1W(c->pred_arcs[node],idx))
            {
            InsInVector((*ptr_pred).nodes[node],c->pred_node[idx]);
            (*ptr_pred).count[node]++;
            count--;
            }
         idx++;
         }
      }
   TRACE2(prpn(c, ptr_pred));

  /* Initialize NodeIndices */
   for (i=0; i<c->num_nodes; i++)
      {
      c->NodeIndices[i].count = 0;
      }

   for (node=2; node<c->num_nodes; node++)
      {
      for (idx=0; idx<VLEN_N; idx++)
         {
         if (BitInVector(node_backpointers[node],idx))
            {
            found = FALSE; /* Use this to stop searching once tuple is found */
            pcount = (*ptr_pred).count[node];
            pn = 0;
            while (pcount > 0)
               { /* Look at each predecessor node */
               if (BitInVector((*ptr_pred).nodes[node],pn))
                  {
                  pcount--;
                  if (pn == idx)
                     { /* Pointer needed is to pred node itself */
                     ct = c->NodeIndices[node].count++;
                     c->NodeIndices[node].nodecode[ct] = pn;
                     c->NodeIndices[node].index[ct] = -1;
                     found = TRUE;
                     break;
                     }
                  if (BitInVector(node_backpointers[pn],idx))
                     { /* Pointer needed is in pred node's relation */
                     ct = c->NodeIndices[node].count++;
                     c->NodeIndices[node].nodecode[ct] = pn; 
                     n = 0;
                     for (k=0; k<idx; k++)
                        {
                        if (BitInVector(node_backpointers[pn],k))
                           n++;
                        }
                     c->NodeIndices[node].index[ct] = n;
                     found = TRUE;
                     break;
                     }
                  } /* if (BitInVector((*ptr_pred).nodes... */
               pn++;
               } /* while (pcount > 0) */

            if (found != TRUE)
               {
		   /* Try_Common_Ancestors returns common ancestor else -1 */
               found = (Try_Common_Ancestors(c,node,idx,node_backpointers,
				common_ancestors) >= 0); 
               }

            if (found != TRUE)
               {
               fprintf(stderr,"Error -- Extension not found\n");
               exit(1);
               }
            } /* if (BitInVector(c->.... */
         } /* for (idx ...  */
      } /* for (node = 2 ... */
   }
#endif






#if (MaxJoin <=2)
Try_Common_Ancestors(c, node, idx, node_backpointers, 
			common_ancestors, CA_count)
CLAUSE *c;
SHORT node, idx, CA_count[];
VECTOR *node_backpointers[], *common_ancestors[];
{
   SHORT found = FALSE, n, ct, ca, k, count;

   /* Search Common Ancestors */
   ca = 0;
   count = CA_count[node];
   while (count-- > 0)
   {
      while (!BitInVector(common_ancestors[node],ca)) ca++;
   /* Check this CA for needed pointer */
      if (BitInVector(node_backpointers[ca],idx) || ca == idx)
      { 
	  /* Found it! */
	  if (ca != idx)
	  {
	      ct = c->NodeIndices[node].count;  /* count incremented in NodeOutput */
	      /* one of node's pred nodes has a back pointer to  ca */
	      n = 0;
	      for (k=0; k<idx; k++)
	      {
		  if (BitInVector(node_backpointers[ca],k))
		  n++;
	      }
	      c->NodeIndices[node].index[ct] = -n;   /* note use of -ve
							for indirection */
	  }
	  found = TRUE;
	  break;
      } /* if (BitInVector(c->node.... */
      ca++;
   } /* while (count > 0) */
   return ((found) ? ca : -1);
}
#else
Try_Common_Ancestors(c, node, idx, node_backpointers, common_ancestors)
CLAUSE *c;
SHORT node, idx;
VECTOR *node_backpointers[];
NODE_CA common_ancestors[];
   {
   return(-1);
   }
#endif

prex(c, node_backpointers)
CLAUSE *c;
VECTOR *node_backpointers[];
    {
    SHORT i, j, idx, PRINT, AtLeastOnePointerNeeded;

    AtLeastOnePointerNeeded = FALSE;
    for (i=0; i<c->num_nodes; i++)
       {
       if (c->NodeIndices[i].count > 0)
          {
          AtLeastOnePointerNeeded = TRUE;
          break;
          }
       }

    if (AtLeastOnePointerNeeded == FALSE)
       {
       printf("\nNO TUPLE BACKPOINTERS NEEDED IN GRAPH\n");
       return;
       }

    printf("\nWHERE TO FIND TUPLE POINTERS WHEN ADDING TO A NODE RELATION:\n");
    printf("\nNode: # chains, <node, position in backpointers array >\n\n");
    for (i=0; i<c->num_nodes; i++)
    {
        idx=0;
        printf("Node %d: # chains = %d, ",i, c->NodeIndices[i].linkindices); 
        for (j=0; j<c->NodeIndices[i].count; j++)
	{
            while (!BitInVector(node_backpointers[i],idx)) idx++;
            printf("<%d, %d> ",c->NodeIndices[i].nodecode[j],
				c->NodeIndices[i].index[j]);
            idx++;
	}
        printf("\n"); 
    }
    printf("\n");
    }

#ifdef PRIORITY

/***************************************************************************/
/*	CaNodeDistance()						   */
/* 
   Added this routine to label the nodes of a clause in a Dependence Order
   and then Reverse this labelling such that last node always has a lebel
   of 0 and the First node the highest label if different from 0.
   The labels are stored in an array called node_distance[MaxNodes]
   in the data structure CLAUSE. Space needed for this array is allocated
   in PgmConsult() in pgm.c.
									   */
/*	written by Vikram Saletore					   */
/***************************************************************************/

/* CaNodeDistance()
 * 
 * Sort the nodes of a clause into Dependence Order. 
 */

CaNodeDistance(c)
CLAUSE *c;
{
  SHORT i, j, max_label;
  int	ceil_log2();

  /* Initializations */
  
  for (i=0; i<c->num_nodes; i++)
  	c->node_distance[i] = 0;

  DependenceOrderSort(c, 0);

  /* The last node 1 has the largest label */
  max_label = c->node_distance[1];

  /* get node distances from the last node */
  for (i=0; i<c->num_nodes; i++) 
	c->node_distance[i] = max_label - c->node_distance[i];

  max_label = c->node_distance[0];
  if ( max_label > 0 )
     for (i=0; i<c->num_nodes; i++) 
	if ( c->node_distance[i] > 0 )
		c->node_distance[i] = c->node_distance[i] - 1;

  c->numSeqLitBits = ceil_log2( c->node_distance[0] );

/*
  for (i=0; i<c->num_nodes; i++) 
	OsPrintf("i %d, c->node_distance[i] = %d\n", i, c->node_distance[i]);
  OsPrintf("clause->numSeqLitBits %d\n", c->numSeqLitBits);
  OsPrintf("\n");
*/

}


/* DependenceOrderSort():
 *
 * Recursively traverse the graph for a clause and 
 *     sort the nodes in Dependence Order.
 */

DependenceOrderSort(c, v)
CLAUSE *c;
SHORT v;
{
    SHORT e, label, edge;

    for (e=0; e<c->num_arcs; e++)
        {
        if (BitInVector1W(c->succ_arcs[v],e))
            {
/*
		OsPrintf("Node_v = %d, c->node_distance[v] = %d, c->succ_arcs[v] = %o\n", v, c->node_distance[v], e );
*/
		if ( c->builtin_index[e+1] != 0 )
			label = c->node_distance[v];
		else
			label = c->node_distance[v] + 1;

		if( label > c->node_distance[c->succ_node[e]] )
			c->node_distance[c->succ_node[e]] = label;
/*
		OsPrintf("label = %d, c->succ_node[e] = %d\n", label, c->succ_node[e]);
		OsPrintf("succ_node_v = %d, c->node_distance[succ_node] = %d, arc_e = %o\n", c->succ_node[e], c->node_distance[c->succ_node[e]], e);
*/
                DependenceOrderSort(c, c->succ_node[e]);
            }
        }
} 


int	ceil_log2( k )
int	k;
{
	int	m,j;

	j = 020000000000;

	if ( k == 0 )
		m = 32;
	else if ( k==1 )
		m = 31;
	else if ( k==2 )
		m = 30;
	else if ( k==3 )
		m = 30;
	else if ( k==4)
		m = 29;
	else if ( k==5)
		m = 29;
	else if ( k==6 )
		m = 29;
	else if ( k==7 )
		m = 29;
	else if ( k > 7)
	for ( m=0; m < 32; m++ )
	{
		if ( (j & k) == 0 )
			j = j >> 1;
		else
			break;
	}

	m = 32 - m;
	return( m );
}


#endif


/* This is a routine that modifies the common ancestor information by taking
   into account that builtins are evaluated inline and are not treated like 
   other literals. A builtin arc shares the same tuples as its predecessor 
   node. Thus if there is a chain of builtins from node A to node D, the 
   SAME tuple is used in evaluating all the builtins. 

   Therefore the node backpointer information being generated to trace back
   to the common ancestors for a join is not valid if there are builtins 
   present in the path from the common ancestors to the join node. 

   This routine looks for such builtins and corrects the node backpointer
   information accordingly. When atmost one non-builtin literal exists 
   in the path from a common ancestor CA to a join arc J1, then the context
   tuple for J1 during the join, is itself the common ancestor. 
   The tuple backpointer to the common ancestor CA in the node PN preceding J1
   is redundant and may then be removed. 

   It may happen that  CA is a common ancestor for a join arc J2 of
   another join in the DJG, and coincidentally PN happens to be the 
   node preceding J2 as well. In this case, if the above criterion is not 
   satisfied, then it is not correct to delete the tuple backpointer to CA
   in node PN, since it is needed by J2. The array "nondeletable" keeps
   track of illegal deletes and subsequently restores these tuple backpointers
   into the "node-backpointer" array.                                       */

OptimiseCAforBuiltins(c, node_backpointers, arc_path, common_ancestors,
		      CA_count)
CLAUSE *c;
VECTOR *node_backpointers[], *arc_path[];
VECTOR *common_ancestors[];
SHORT CA_count[];
{
    SHORT node, arccount, arc, ca, prednode, cacount, i;
    BOOLEAN AllBuiltinsInPath(),
    	    AllBuiltinsExceptOne();
    LONG FreeBlock[BLOCKLEN];
    SHORT BlockTop = 0;
    VECTOR  *nondeletable[MaxNodes];   /* non-deletable node backpointers */

    ArrayAlloc(FreeBlock, BlockTop, BLOCKLEN, nondeletable, VLEN_N, MaxNodes); 

    for (node = c->num_nodes-1; node >= 1; node--)
	if (JOIN_NODE(c, node))
	{
	    arc = 0;
	    arccount = c->pred_count[node];
	    while (arccount > 0)
	    {
		if (BitInVector1W(c->pred_arcs[node], arc))
		{
		    arccount--; ca = 0;
		    for (cacount = 0; cacount < CA_count[node]; cacount++)
		    {
			while (!BitInVector(common_ancestors[node], ca)) ca++;
			prednode = c->pred_node[arc];
			if (AllBuiltinsInPath(c, ca, prednode) ||
			    (AllBuiltinsExceptOne(c, ca, prednode) &&
			       c->builtin_index[arc+1] != 0))  /* is builtin */
			     DeleteAlongPath(node_backpointers,c,ca, prednode);
			else InsertAlongPath(nondeletable,c,ca,prednode); 
			ca++;
		    }
		}
		arc++;
	    }
	}

    if (DEBUG2)
    {
	printf("before adding nondeletables\n");
	for (node = 0; node < c->num_nodes; node++)
	{
	    printf("[%d] = ",node);
	    PrVector(node_backpointers[node]);
	    printf("\n");
	}
	printf("\n");
    }
    for( node= 0; node < c->num_nodes; node++)
    {
	VectorUnion(node_backpointers[node], node_backpointers[node],
			nondeletable[node]);
	/* back pointers do not need to be copied if the
	   literal evaluated is a builtin */
	for (i = 0; i < c->num_nodes; i++)
	{
	    if (!(JOIN_NODE(c,node) || BRANCH_NODE(c,node)) && 
		BitInVector(node_backpointers[node],i))
	    {
		arc = 0;
		while (!BitInVector1W(c->pred_arcs[node], arc)) arc++;
		/* only one such arc */
		if (c->builtin_index[arc+1] != 0 )   
		    DelFromVector(node_backpointers[node], i);
	    }
	}
    }
    if (DEBUG2)
    {
	printf("after opt. for builtins\n");
	for (node = 0; node < c->num_nodes; node++)
	{
	    printf("[%d] = ",node);
	    PrVector(node_backpointers[node]);
	    printf("\n");
	}
	printf("\n");
	printf("end of optimisations for builtins\n");
    }
}




DeleteAlongPath(node_backpointers, clause, ca, destnode)
VECTOR *node_backpointers[];
CLAUSE *clause;
SHORT ca;
SHORT destnode;
{
    SHORT   prevnode, arc;

    if (ca == destnode) 
        return ;
    DelFromVector(node_backpointers[destnode], ca);
    arc = 0;
    while (!BitInVector1W(clause->pred_arcs[destnode], arc)) arc++;
    /* there will be only one arc */
    DeleteAlongPath(node_backpointers, clause, ca, clause->pred_node[arc]);
}



InsertAlongPath(vectorptr, clause, ca, destnode)
VECTOR *vectorptr[];
CLAUSE *clause;
SHORT ca;
SHORT destnode;
{
    SHORT   prevnode, arc;

    if (ca == destnode)
        return;
    InsInVector(vectorptr[destnode], ca);
    if (JOIN_NODE(clause, destnode))
        return;
    arc = 0;
    while (!BitInVector1W(clause->pred_arcs[destnode], arc)) arc++;
    /* there will be only one arc */
    InsertAlongPath(vectorptr, clause, ca, clause->pred_node[arc]);
}



BOOLEAN AllBuiltinsInPath(clause, sourcenode, destnode)
CLAUSE *clause;
SHORT sourcenode;
SHORT destnode;
{
    SHORT   prevnode, arc;

    if (sourcenode == destnode) 
        return TRUE;
    if (JOIN_NODE(clause, destnode))
        return FALSE;
    arc = 0;
    while (!BitInVector1W(clause->pred_arcs[destnode], arc)) arc++;
    /* there will be only one arc */
    if (clause->builtin_index[arc+1] == 0)
          return FALSE;
    else return AllBuiltinsInPath(clause, sourcenode, clause->pred_node[arc]);
}



BOOLEAN AllBuiltinsExceptOne(clause, sourcenode, destnode)
CLAUSE *clause;
SHORT sourcenode;
SHORT destnode;
{
    SHORT   prevnode, arc;
    BOOLEAN AllBuiltinsInPath();

    if ((sourcenode == destnode) || JOIN_NODE(clause, destnode))
        return FALSE;
    arc = 0;
    while (!BitInVector1W(clause->pred_arcs[destnode], arc)) arc++;
    /* there will be only one arc */
    prevnode = clause->pred_node[arc];
    if (clause->builtin_index[arc+1] == 0)  /* not a builtin */
         return AllBuiltinsInPath(clause, sourcenode, prevnode);
    else return AllBuiltinsExceptOne(clause, sourcenode, prevnode);
}



OptimiseLinkInfoForBuiltins(c)
CLAUSE *c;
{
    extern SHORT MAXLINKSINPROGRAM;
    SHORT i, index = 0, maxlinks = 1;
    LONG  mask = 0;
    
    for (i = 0; i < c->num_nodes; i++, index = 0)
    {
        ComputeLinkInfo(c, i, &index, &mask);
	if (c->NodeIndices[i].linkindices > maxlinks)
	   maxlinks = c->NodeIndices[i].linkindices;
    }
    c->maxlinks = maxlinks;

    if (maxlinks > MAXLINKSINPROGRAM)
       MAXLINKSINPROGRAM = maxlinks;      /* largest in all clauses scanned
					     so far */
}


ComputeLinkInfo(c, node, nextindex, mask)
CLAUSE *c;
SHORT node;
SHORT *nextindex;
LONG *mask;
{
    SHORT arccount, arc, nextnode;
    EXTEND *nodeinfo = c->NodeIndices;

    arccount = c->succ_count[node];
    arc = 0;
    while (arccount-- > 0)
    {
	while (!BitInVector1W(c->succ_arcs[node], arc)) arc++;
	{
	    nextnode = c->succ_node[arc];
	    if (c->builtin_index[arc+1] != 0)   /* is a builtin */
	    {
		if (JOIN_NODE(c, nextnode))
	            c->ArcIndices[arc].arclinkindex = (*nextindex)--; 
		else if (nodeinfo[nextnode].count         /* back ptrs */
			 + c->fwd_ptr[nextnode]  == 0)    /* fwd  ptrs */
 		     ComputeLinkInfo(c, nextnode, nextindex, mask);
	    }
	    else c->ArcIndices[arc].arclinkindex = 0;
	    arc++;
	}
    }
    *mask |= (1 << node);   /* this node info has been computed */
    nodeinfo[node].linkindices = (-*nextindex);  /* *nextindex is -ve */
}
