
/************************************************************************/
/*									*/
/* This file contains the constant declarations, macro definitions and  */
/* Global type declarations						*/
/*									*/
/************************************************************************/

#include <stdio.h>
#include "host.h"
#include "cksys.h"

typedef LONG VECTOR;		/* The type of word used in Bit-Vectors */

#define LONGLENGTH 32    /* Number of bits in a LONG -- used for bit-vectors */

#define SLOT_TAG_SIZE 5
#define ARITY_SIZE    5
#define REF_CNT_SIZE  6
#define MAX_REF_COUNT 63
#define FUNCTOR_SHIFT 11	/* SLOT_TAG_SIZE + REF_CNT_SIZE  */
#define SYM_TAB_SHIFT 16 	/* SLOT_TAG_SIZE + REF_CNT_SIZE + ARITY_SIZE */
#define WORKSTACKSIZE 1000      /* for scanning terms for unification and 
				   for absence of unbound variables */

#define ABSOLUTE_ADDRESS 	0
#define MOLECULE	 	1
#define FUNCTOR		 	2
#define TUPLE_INDEX_1	 	3
#define TUPLE_INDEX_2	 	6
#define RELATIVE_INDEX	 	7
#define TERM_SPC_INDEX_1 	10
#define TERM_SPC_INDEX_2	11
#define INTEGER		 	14
#define REAL			15
#define UNBOUND_VAR		18
#define BLOCKED_VAR		19
#define TUPLE_SIZE		22
#define CLOSED_TERM		23
#define FREE_SLOT		26
#define SEQ_MOLECULE	 	27


/* the slot size is 32 bits. The least significant 5 bits will be used for the
   tag. Access procedures will be provided to insert/extract objects */


typedef LONG SLOT;

typedef struct 
	{
	    SHORT ref_count;   /* wasted space */
	    SLOT *terms;
	    SLOT *tuple;
	} MOLECULE_PTR;



/*									    */
/* Message type definition:						    */
/*	To get major type of message, use	macro MSGTYPE(x)	    */
/* 	Only 6 bits are used to define the MSGTYPE (inc subtypes	    */
/*									    */
#define ENTRYPT_FIRST	0		/* type, used when init	            */
#define ENTRYPT_REST	1		/* type, used for other messages    */
#define MSGTYPE_GOAL	1		/* goal message			    */
#define MSGTYPE_RESP	MSGTYPE_GOAL+1	/* response message		    */
#define MSGTYPE_ROUT	MSGTYPE_RESP+1	/* routing message		    */
#define MSGTYPE_CNTL	MSGTYPE_ROUT+1	/* control message		    */
#define MSGTYPE_CTRA	MSGTYPE_CNTL+1	/* contract message		    */
/*									    */
/* Message subtype definition 						    */
/*									    */
#define MSGTYPE_RESPRNUM	(MSGTYPE_RESP | 0x08)
					/* DONE, to indicate end of resp    */
#define MSGTYPE_RESPCNUM	(MSGTYPE_RESP | 0x10)
					/* report num of active clauses	    */
#define MSGTYPE_RESPDATA	(MSGTYPE_RESP | 0x20)
					/* data sent as a response 	    */
/* MACROS will be used to access  these fields */

/* Message data structure definition 					    */
/*									    */
typedef struct 
{
    BYTE 	 msgType;	/* only 4 bits used - rest free     	    */
				/* PART touched by system only:		    */
    SHORT 	 BCEntrypt;     /* entrypoint in byte code interpreter      */
    SHORT 	 respEP;        /* response entrypoint			    */
    ChareIDType	 srcChareID;	/* chare ID to which the resp should go	    */
    LONG	 goalSlot;      /* it is pointer to goal slot       	    */
    SLOT  	 *goalResp;	/* ptr to Goal or Resp for long message     */
    SLOT	 *goalterm;     /* the term associated with a new goal      */
    BYTE	 statusbits;   /* status bits associated with new goal     */
    SHORT	 rNum;          /* count value for responses 		    */
    SHORT  	 cNum; 		/* count value for clauses		    */
    PVECTOR	 *priority_vector; /* ptr to 32bit unsigned int as priority */
} MESSAGE;		


typedef struct 
	{
	    SHORT querycount;
	} LocalArea;


