
#ifdef PRIORITY
#define Priority

#include	<stdio.h>
#include	"typedefs.h"
#include	"ropm.h"
#include	"macros.c"
#include	"priority_macros.c"

shared  SHORT	MaxVectorLength = 0;


/* priority gen function for generating priorities of subgoals of a QUERY */
/* priority with distance from neighbors */
PVECTOR	*PgenLiteralPriority(query_ptr, lit_distance, node_num, num_lit_bits)
QUERY		*query_ptr;
int		lit_distance;
int		node_num;
int		num_lit_bits;
{

	PVECTOR 	*ptr, *lit_bvector_ptr, *query_bvector_ptr ; 
	PVECTOR		query_vec_length, lit_vec_length;
	int		query_vec_size, lit_vec_size;
	int		branch_bits;
	int		lit_start_bits = 0;
	int		lit_start_num;



	lit_start_num = query_ptr->lit_start_count[node_num];
	branch_bits = num_lit_bits;

#ifdef INST_DYNAMIC
	if ( lit_start_num <= 6 ) /* 2 */
	{
		lit_distance = ((lit_distance << 3) |
					(lit_start_num & 0x07ffffff) );
		branch_bits += 3; /* 2 */
	}
	else
	{
	   lit_start_bits = (lit_start_num >> 27) & 0x1f;
	   lit_distance = ((lit_distance << ( (lit_start_bits<<1) + 1)) | 
					(lit_start_num & 0x07ffffff) );
	   branch_bits += (lit_start_bits<<1) + 1;
	}
#endif 


#ifdef INST_STATIC 
	if ( lit_start_num > 7 ) lit_start_num = 7;
	lit_distance = ((lit_distance << 3) | lit_start_num);
	branch_bits += 3;
#endif 

	query_bvector_ptr = query_ptr->priority_vector;
	query_vec_length =  (*query_bvector_ptr >> 24);
	lit_vec_length = query_vec_length + branch_bits;
	if ( lit_vec_length > 248 )
		lit_vec_length = query_vec_length;
	if ( lit_vec_length > MaxVectorLength )
		MaxVectorLength = lit_vec_length;

	   PGEN_GET_PVECTOR2(query_bvector_ptr,query_vec_length,lit_bvector_ptr,lit_vec_length,lit_distance);

/*
OsPrintf("PGEN:AND LITERALS OF A QUERY\n");
OsPrintf("PGEN:Query:length %d size %d, Literal:length %d size %d\n", 
	query_vec_length, query_vec_size, lit_vec_length, lit_vec_size);
OsPrintf("lit_start_num=%o, lit_distance=%o, branch_bits=%d\n",
	lit_start_num,lit_distance,branch_bits);
print_parent_vector(query_bvector_ptr);
print_child_vector(lit_bvector_ptr);
OsPrintf("\n");
*/

	return(lit_bvector_ptr);
}


int PgenCheckLitPriorityLimit(vector)
int	vector;
{
	PVECTOR	bit_vector;
	int	bits_used;

	bits_used = (vector >> 27) & 0x1f;

	switch ( bits_used ) {

	case  0:	bit_vector = 07;
			break;
/*
	case  0:	bit_vector = 03;
			break;
*/
	case  1:	bit_vector = 01000000006;
			break;

	case  2:	bit_vector = 02000000034;
			break;

	case  3:	bit_vector = 03000000170;
			break;

	case  4:	bit_vector = 04000000760;
			break;

	case  5:	bit_vector = 05000003740;
			break;

	case  6:	bit_vector = 06000017700;
			break;

	case  7:	bit_vector = 07000077600;
			break;

	case  8:	bit_vector = 010000377400;
			break;

	case  9:	bit_vector = 011001777000;
			break;

	case  10:	bit_vector = 012007776000;
			break;

	case  11:	bit_vector = 013037774000;
			break;

	case  12:	bit_vector = 014177770000;
			break;

	case  13:	bit_vector = 015777760000;
			break;

	}

	if ( vector == bit_vector )
		return( TRUE );
	else
		return( FALSE );

}


int PgenGetNextLitVector(vector)
int	vector;
{
	PVECTOR	bit_vector;
	int	bits_used;

	bits_used = (vector >> 27) & 0x1f;

	switch ( bits_used ) {

	case  0:	bit_vector = 03000000160;
			break;
/*
	case  0:	bit_vector = 02000000030;
			break;
*/
	case  1:	bit_vector = 02000000030;
			break;

	case  2:	bit_vector = 03000000160;
			break;

	case  3:	bit_vector = 04000000740;
			break;

	case  4:	bit_vector = 05000003700;
			break;

	case  5:	bit_vector = 06000017600;
			break;

	case  6:	bit_vector = 07000077400;
			break;

	case  7:	bit_vector = 010000377000;
			break;

	case  8:	bit_vector = 011001776000;
			break;

	case  9:	bit_vector = 012007774000;
			break;

	case  10:	bit_vector = 013037770000;
			break;

	case  11:	bit_vector = 014177760000;
			break;

	case  12:	bit_vector = 015777740000;
			break;

	case  13:	bit_vector = 015777757777;
			break;

	}

		return( bit_vector );

}


print_child_vector(vector_ptr)
PVECTOR	*vector_ptr;
{
	PVECTOR	*ptr, vector_length;
	int		vector_size;

	ptr = vector_ptr;
	vector_length = (*ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ( (vector_length - 24) >> 5 )  + 2;

	OsPrintf("PGEN:child  bit vector = ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		OsPrintf("%x  %o\t", ptr, *ptr);

	OsPrintf("\n");
}



print_parent_vector(vector_ptr)
PVECTOR	*vector_ptr;
{
	PVECTOR	*ptr, vector_length;
	int		vector_size;

	ptr = vector_ptr;
	vector_length = (*ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ( (vector_length - 24) >> 5 )  + 2;

	OsPrintf("PGEN:parent bit vector = ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		OsPrintf("%x  %o\t", ptr, *ptr);

	OsPrintf("\n");
}


/*endif for PRIORITY*/
#endif
