#include <varargs.h>
#include "typedefs.h"
#include "macros.c"

#ifdef SHARED

OsAllocTermFunc(size,z) 
int size;
SLOT **z;

{   SLOT kk;
    extern LONG PURE_CODE_MARKER;
    void GarbageCollect(); 
    extern SPINLOCK memLock2;

    if (DEBUG &&  size > 100)
        OsPrint("term space - %d slots requested\n", size);
    if (size >= 45) { 
	OsSpinLock(memLock2);
	if ((kk = next_term+size) > maxTerm) { /*pcount[135]++;*/ 
	    OsPrint("nextterm is %d, PURE_CODE MARKER IS %dn",
			next_term,PURE_CODE_MARKER);
	    OsTermUsage();
	    perror("Termspace allocation error,system failed");
	    exit(1);
	}  
	*z = &term_space[next_term];   
	next_term = kk;
	OsSpinUnlock(memLock2);
	termMems[MyPenum][0][0]++; termMems[MyPenum][0][2] += size;
    } 
    else if (termMems[MyPenum][size][0] == NULL) 
    { 
	OsSpinLock(memLock2);
	if ((kk = next_term + size) > maxTerm)
	GarbageCollect(); 
	if (termMems[MyPenum][size][0] == NULL) { /*pcount[136]++;*/ 
	    if (kk > maxTerm) { 
		perror("Termspace allocation error,system failed");
		OsTermUsage();
		exit(1);
	    }
	    *z = &term_space[next_term];
	    next_term = kk;
	    OsSpinUnlock(memLock2);
	    termMems[MyPenum][size][2]++; termMems[MyPenum][size][3]++;
	}
    }
    else 
    { 
	OsSpinLock(memLock2); /* may not need it here */
	*z = &term_space[termMems[MyPenum][size][0]]; 
	OsSpinUnlock(memLock2);
   	termMems[MyPenum][size][0] = (SHORT) *( (SHORT *)*z); 
	termMems[MyPenum][size][2]++; termMems[MyPenum][size][1]--;
    }
    if (DEBUG)
        OsPrintf("Allocating ptr: %x, size(+1): %d \n", *z, size); 
}

#else

OsAllocTermFunc(size,z) 
int size;
SLOT **z;

{   SLOT kk;
    extern LONG PURE_CODE_MARKER;
    void GarbageCollect(); 

    if ( DEBUG &&  size > 100)
        OsPrint("term space - %d slots requested\n", size);
    if (size >= 45) { 
	if ((kk = next_term+size) > maxTerm) { 
	    OsPrint("nextterm is %d, PURE_CODE MARKER IS %dn",
			next_term,PURE_CODE_MARKER);
	    OsTermUsage();
	    perror("Termspace allocation error,system failed");
	    exit(1);
	}  
	*z = &term_space[next_term];   
	next_term = kk;
	termMems[0][0]++; termMems[0][2] += size;
    } 
    else if (termMems[size][0] == NULL) 
    { 
	if ((kk = next_term + size) > maxTerm)
	GarbageCollect(); 
	if (termMems[size][0] == NULL) { 
	    if (kk > maxTerm) { 
		perror("Termspace allocation error,system failed");
		OsTermUsage();
		exit(1);
	    }
	    *z = &term_space[next_term];
	    next_term = kk;
	    termMems[size][2]++; termMems[size][3]++;
	}
    }
    else 
    { 
	*z = &term_space[termMems[size][0]]; 
   	termMems[size][0] = (SHORT) *( (SHORT *)*z); 
	termMems[size][2]++; termMems[size][1]--;
    }
    if (DEBUG)
        OsPrintf("Allocating ptr: %x, size(+1): %d \n", *z, size); 
}

#endif

#ifdef SHARED

OsFreeTerm(ptr,size)
SHORT	size;
SLOT	*ptr;
{   
    if (DEBUG)
        OsPrintf("Freeing term of size: %d ptr: %x \n", size, ptr); 
    if (size >= 45) {
	termMems[MyPenum][0][1]++; 
	}
    else {
    	*((SHORT *)ptr) = termMems[MyPenum][size][0];
    	termMems[MyPenum][size][0] = (SHORT) (ptr - term_space);
    	termMems[MyPenum][size][1]++; 
    }
}

#else
OsFreeTerm(ptr,size)
SHORT	size;
SLOT	*ptr;
{   
    if (DEBUG)
        OsPrintf("Freeing term of size: %d ptr: %x \n", size, ptr); 
    if (size >= 45) {
	termMems[0][1]++; 
	}
    else {
    	*((SHORT *)ptr) = termMems[size][0];
    	termMems[size][0] = (SHORT) (ptr - term_space);
    	termMems[size][1]++; 
    }
}

#endif

#ifdef SHARED
	
OsTermUsage()
{
    SHORT i, j, k, penum, col;
    SHORT total[45][4];

    /* initialize total */
    for (i = 0; i < 45; i++) {
	for (j = 0; j < 4; j++)
	    total[i][j] = 0;  
    }
    OsPrintf("Termspace Usage: [size,free q len, #request, #allocated]\n");
    for (penum = 0; penum < MaxPe; penum++) 
    {
       col = 0;
       for (i = 1; i <= 40; i += 4) 
       {
	   for (j = 0; j < 4; j++) 
	   {
		if (termMems[penum][i+j][1] |termMems[penum][i+j][2] |
						termMems[penum][i+j][3]) {
	        	OsPrintf("[%d,%d,%d,%d] ",i+j,termMems[penum][i+j][1],
			      termMems[penum][i+j][2],termMems[penum][i+j][3]); 
			if((++col % 4) == 0) OsPrintf("\n"); else OsPrintf("\t");
		}
		for (k = 1; k < 4; k++)
	            total[i+j][k] += termMems[penum][i+j][k];
	   }
       }
       if (termMems[penum][0][0] |termMems[penum][0][2] |termMems[penum][0][1])
            OsPrintf("\n#request (size > 44) %d total size %d #free %d\n",
		termMems[penum][0][0],termMems[penum][0][2],termMems[penum][0][1]); 
       for (k = 0; k < 3; k++)
            total[0][k] += termMems[penum][0][k];
    }
    OsPrintf("\nTermspace Usage:%d [size,free q len, #request, #allocated]\n",next_term);
    OsPrintf("TOTAL usage (all processors) is : \n");
    col = 0;
    for (i = 1; i <= 40; i += 4) 
    {
	for (j = 0; j < 4; j++)
	  if( total[i+j][1] | total[i+j][2] | total[i+j][3] ) {
	     OsPrintf("[%d,%d,%d,%d] ",i+j,total[i+j][1],
		      total[i+j][2],total[i+j][3]);
	     if((++col % 4) == 0) OsPrintf("\n"); else OsPrintf("\t");
	  }
    }
    OsPrintf("\nTOTAL : #request (size > 44) %d total size %d #free %d\n",
	     total[0][0],total[0][2],total[0][1]);

}


#else

OsTermUsage()
{
    SHORT i, j, col;

    OsPrintf("Termspace usage for Processor %d\n",OsMyPeNum());
    OsPrintf("Termspace Usage: [size,free q len, #request, #allocated]\n");
    col = 0;
    for (i = 1; i <= 40; i += 4) 
    {
	for (j = 0; j < 4; j++)
	  if( termMems[i+j][1] | termMems[i+j][2] | termMems[i+j][3] ) {
	     OsPrintf("[%d,%d,%d,%d] ",i+j,termMems[i+j][1],
		      termMems[i+j][2],termMems[i+j][3]);
	     if((++col % 4) == 0) OsPrintf("\n"); else OsPrintf("\t");
	  }
    }
    OsPrintf("\nTOTAL : #request (size > 44) %d total size %d #free %d\n",
	     termMems[0][0],termMems[0][2],termMems[0][1]);

}


#endif

