/* This file contains the sequential unification and packing routines */

#include "typedefs.h"
#include "macros.c"
#include "be_macros.c"
#include "seq_macros.c"



/* Takes care of unification where term1 and term2 are not necessarily
   functors. It calls SeqUnify as necessary   */

BOOLEAN DoSeqUnification(term1, tuple1, term2, tuple2, thrumolecule, Stack, TR,StackLimit)
SLOT *term1;
SLOT *tuple1;
SLOT *term2;
SLOT *tuple2;
BOOLEAN thrumolecule;
LONG *Stack;
LONG ***TR;
LONG **StackLimit;
{
    BOOLEAN SeqUnify();
    MOLECULE_PTR *molecule;
    
    Deref_Term(term1, tuple1);
    if (TAG_IS_MOLECULE(term1))
    {
	molecule = MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
	thrumolecule |= TRUE;
    }
    else if (TAG_IS_SEQ_MOLECULE(term1))
    {
	molecule = SEQ_MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
    }
    Deref_Term(term2, tuple2);
    if (TAG_IS_MOLECULE(term2))
    {
	molecule = MOLECULE_ADDRESS(term2);
	term2 = TERMS(molecule);
	tuple2 = TUPLE(molecule);
	thrumolecule |= TRUE;
    }
    else if (TAG_IS_SEQ_MOLECULE(term2))
    {
	molecule = SEQ_MOLECULE_ADDRESS(term2);
	term2 = TERMS(molecule);
	tuple2 = TUPLE(molecule);
    }
    if (TAG_IS_TUPLE_INDEX_1(term1))
       term1 = &tuple1[INDEX(term1)];

    if (TAG_IS_TUPLE_INDEX_1(term2))
       term2 = &tuple2[INDEX(term2)];

    if (TAG_IS_FUNCTOR(term1) && TAG_IS_FUNCTOR(term2))
       return (SeqUnify(term1, tuple1, term2, tuple2, thrumolecule, Stack, TR,StackLimit));
    if (TAG_IS_UNBOUND(term1))
    {
	switch (SLOT_TAG(term2))
	{
	case UNBOUND_VAR:
	    if (term1 != term2)
	    {
		*(*TR)++ = term1;
		INSERT_ADDRESS(term1, term2);
	    }
	    break;
	case SEQ_MOLECULE:
	    *(*TR)++ = term1;
	    COPY_SEQ_MOLECULE(term1, term2,*StackLimit);
	    break;
	case CLOSED_TERM:
	    *(*TR)++ = term1;
	    if ( ARITY_IS_ZERO(term2))
	    COPY_ATOM(term1, term2);
	    else INSERT_ADDRESS(term1, term2);
	    break;
	case MOLECULE:
	    *(*TR)++ = term1;
	    molecule = MOLECULE_ADDRESS(term2);
	    COPY_MOLECULE(term1, term2, molecule);
	    break;
	case FUNCTOR:
	    *(*TR)++ = term1;
	    ALLOC_SEQ_MOLECULE(term1, molecule,*StackLimit);
	    INSERT_MOLEC_TERMS(molecule, term2);
	    INSERT_MOLEC_TUPLE(molecule, tuple2);
	    break;
	case INTEGER:
	case REAL:
	    *(*TR)++ = term1;
	    COPY_ATOM(term1, term2);
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in SeqBuiltinARG\n");
	}
	return TRUE;
    }

    if (TAG_IS_UNBOUND(term2))
    {
	switch (SLOT_TAG(term1))
	{
	case SEQ_MOLECULE:
	    *(*TR)++ = term2;
	    COPY_SEQ_MOLECULE(term2, term1,*StackLimit);
	    break;
	case CLOSED_TERM:
	    *(*TR)++ = term2;
	    if ( ARITY_IS_ZERO(term1))
	    COPY_ATOM(term2, term1);
	    else INSERT_ADDRESS(term2, term1);
	    break;
	case MOLECULE:
	    *(*TR)++ = term2;
	    molecule = MOLECULE_ADDRESS(term1);
	    COPY_MOLECULE(term2, term1, molecule);
	    break;
	case FUNCTOR:
	    *(*TR)++ = term2;
	    ALLOC_SEQ_MOLECULE(term2, molecule,*StackLimit);
	    INSERT_MOLEC_TERMS(molecule, term1);
	    INSERT_MOLEC_TUPLE(molecule, tuple1);
	    break;
	case INTEGER:
	case REAL:
	    *(*TR)++ = term2;
	    COPY_ATOM(term2, term1);
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in SeqBuiltinARG\n");
	}
	return TRUE;
    }
    if (TAG_IS_INTEGER(term1) && TAG_IS_INTEGER(term2))
        return (INTVALUE(term1) == INTVALUE(term2));

    if (TAG_IS_REAL(term1) && TAG_IS_REAL(term2))
        return (REALVALUE(term1) == REALVALUE(term2));
    
    return FALSE;     /* if you got this far, unification fails */
}



BOOLEAN SeqUnify(pterms, ptuple, cterms, ctuple, thrumolecule, Stack, TR,StackLimit)
SLOT *pterms;
SLOT *ptuple;
SLOT *cterms;
SLOT *ctuple;
BOOLEAN thrumolecule;
LONG *Stack;
LONG ***TR;
LONG **StackLimit;
{
    SHORT i;
    SHORT  arity, index;
    BOOLEAN pdone, cdone;
    MOLECULE_PTR *molecule1, *molecule2;
    SLOT *psubterm, *csubterm;
    SLOT   *workstack[WORKSTACKSIZE];
    SLOT   **stack;

    stack = workstack + 1;
    while (stack > workstack && (ptuple != ctuple || pterms != cterms))   
    { 
	if (stack > (workstack + WORKSTACKSIZE))
	{
	    OsPrint("SeqUnify: nesting level in term too deep - aborting execution\n");
	    OsKillSys();
	}
	if (!SAME_FUNCTOR_ARITY(pterms, cterms))
    	    return(FALSE);
	arity = ARITY(pterms);
	for(i=1; i <= arity; i++)
	{ 
	    psubterm = &pterms[i];
	    Deref_Term(psubterm, ptuple);
	    csubterm = &cterms[i];
	    Deref_Term(csubterm, ctuple);
	    
	    if (TAG_IS_FUNCTOR(psubterm) &&  TAG_IS_FUNCTOR(csubterm))
	    {
	    	if (!SAME_FUNCTOR_ARITY(psubterm, csubterm))
	    		return(FALSE);
		else if (!ARITY_IS_ZERO(psubterm))
		{   
		    *stack++ = psubterm;
		    *stack++ = ptuple;
		    *stack++ = csubterm;
		    *stack++ = ctuple;
		    *stack++ = (SLOT *)thrumolecule;
		}
	    }
	    else  /* both are not functors */
	    {
		pdone = FALSE;
		while (!pdone)
		switch (SLOT_TAG(psubterm))
		{ 
		case MOLECULE:
			molecule1 = MOLECULE_ADDRESS(psubterm);
			cdone= FALSE;
			while (!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case MOLECULE:
			    molecule2 = MOLECULE_ADDRESS(csubterm);
			    if (TERMS(molecule1) != TERMS(molecule2))
			    { 
				csubterm = TERMS(molecule2);
				ctuple = TUPLE(molecule2);
			    }
			    else cdone = TRUE;
			    break;
			case SEQ_MOLECULE:
			    molecule2 = SEQ_MOLECULE_ADDRESS(csubterm);
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = TERMS(molecule2);
			    *stack++ = TUPLE(molecule2);
			    *stack++ = (SLOT *)TRUE;
			    cdone = TRUE;
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = csubterm;
			    *stack++ = ctuple;
			    *stack++ = (SLOT *)TRUE;
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_1:
			    csubterm = &ctuple[INDEX(csubterm)];
			    /* fall into next case */
			case UNBOUND_VAR:
			    COPY_MOLECULE(csubterm, psubterm, molecule1);
			    *(*TR)++ = csubterm;
			    cdone= TRUE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		case SEQ_MOLECULE:
			molecule1 = SEQ_MOLECULE_ADDRESS(psubterm);
			cdone= FALSE;
			while (!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case MOLECULE:
			    molecule2 = MOLECULE_ADDRESS(csubterm);
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = TERMS(molecule2);
			    *stack++ = TUPLE(molecule2);
			    *stack++ = (SLOT *)TRUE;
			    cdone= TRUE;
			    break;
			case SEQ_MOLECULE:
			    molecule2 = SEQ_MOLECULE_ADDRESS(csubterm);
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = TERMS(molecule2);
			    *stack++ = TUPLE(molecule2);
			    *stack++ = (SLOT *) FALSE;
			    cdone= TRUE;
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = csubterm;
			    *stack++ = ctuple;
			    *stack++ = (SLOT *)thrumolecule;
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_1:
			    csubterm = &ctuple[INDEX(csubterm)];
			    /* fall into next case */
			case UNBOUND_VAR:
			    COPY_SEQ_MOLECULE(csubterm, psubterm, *StackLimit);
			    *(*TR)++ = csubterm;
			    cdone= TRUE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		case FUNCTOR:
		case CLOSED_TERM:
			cdone= FALSE;
			while (!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case MOLECULE:
			    molecule1 = MOLECULE_ADDRESS(csubterm);
			    *stack++ = psubterm;
			    *stack++ = ptuple;
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = (SLOT *)TRUE;
			    cdone= TRUE;
			    break;
			case SEQ_MOLECULE:
			    molecule1 = SEQ_MOLECULE_ADDRESS(csubterm);
			    *stack++ = psubterm;
			    *stack++ = ptuple;
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = (SLOT *) thrumolecule;
			    cdone= TRUE;
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    if (!SAME_FUNCTOR_ARITY(psubterm, csubterm))
			    	return(FALSE);
			    if (!ARITY_IS_ZERO(psubterm))
			    {
				*stack++ = psubterm;
				*stack++ = ptuple;
				*stack++ = csubterm;
				*stack++ = ctuple;
				*stack++ = (SLOT *)thrumolecule;
			    }
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_1:
			    csubterm = &ctuple[INDEX(csubterm)];
			    /* drop in to next case */
			case UNBOUND_VAR:
			    if (ARITY_IS_ZERO(psubterm))
			    	COPY_ATOM(csubterm, psubterm);
			    else if ((ptuple == ctuple) || TAG_IS_CLOSED_TERM(psubterm))
			    {
			    	INSERT_ADDRESS(csubterm,psubterm);
			    }
			    else
			    {
				if (thrumolecule)
				{ 
				    Malloc_Molecule(molecule1);
				    INSERT_MOLECULE(csubterm, molecule1);
				}
				else ALLOC_SEQ_MOLECULE(csubterm, molecule1,*StackLimit);
				INSERT_MOLEC_TERMS(molecule1, psubterm);
				INSERT_MOLEC_TUPLE(molecule1, ptuple);
			    }
			    *(*TR)++ = csubterm;
			    cdone= TRUE;
			    break;

			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		case TUPLE_INDEX_1:
			if (TAG_IS_TUPLE_INDEX_1(psubterm))
			   psubterm = &(ptuple[INDEX(psubterm)]);
			/* drop into next case */

		case UNBOUND_VAR:
			switch (SLOT_TAG(csubterm))
			{ 
			case MOLECULE:
			    molecule1 = MOLECULE_ADDRESS(csubterm);
			    COPY_MOLECULE(psubterm, csubterm, molecule1);
			    *(*TR)++ = psubterm;
			    break;
			case SEQ_MOLECULE:
			    molecule1 = SEQ_MOLECULE_ADDRESS(csubterm);
			    COPY_SEQ_MOLECULE(psubterm, csubterm, *StackLimit);
			    *(*TR)++ = psubterm;
			    break;
			case FUNCTOR:
			    ALLOC_SEQ_MOLECULE(psubterm, molecule1,*StackLimit);
			    INSERT_MOLEC_TERMS(molecule1, csubterm);
			    INSERT_MOLEC_TUPLE(molecule1, ctuple);
			    *(*TR)++ = psubterm;
			    break;
			case CLOSED_TERM:
			    if (ARITY_IS_ZERO(csubterm))
			    	 COPY_ATOM(psubterm, csubterm);
			    else INSERT_ADDRESS(psubterm, csubterm);
			    *(*TR)++ = psubterm;
			    break;
			case TUPLE_INDEX_1:
			    csubterm = &ctuple[INDEX(csubterm)];
			    /* fall into next case */
			case UNBOUND_VAR:
			    /* check whether they point to the same variable */
			    if (csubterm != psubterm)
			    {
				/* orient from child to parent */
				INSERT_ADDRESS(csubterm, psubterm);
				*(*TR)++ = csubterm;
			    }
			    break;
			case INTEGER:
			    COPY_INTEGER(psubterm,csubterm);
			    *(*TR)++ = psubterm;
			    break;
			case REAL:
			    COPY_REAL(psubterm, csubterm);
			    *(*TR)++ = psubterm;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		case INTEGER:
			cdone= FALSE;
			while (!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case TUPLE_INDEX_1:
			    csubterm = &ctuple[INDEX(csubterm)];
			    /* fall into next case */
			case UNBOUND_VAR:
			    COPY_INTEGER(csubterm, psubterm);
			    *(*TR)++ = csubterm;
			    cdone= TRUE;
			    break;
			case INTEGER:
			    if (INTVALUE(psubterm) != INTVALUE(csubterm))
			    return(FALSE);
			    cdone= TRUE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;
			
		case REAL:
			cdone= FALSE;
			while(!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case TUPLE_INDEX_1:
			    csubterm = &ctuple[INDEX(csubterm)];
			    /* fall into next case */
			case UNBOUND_VAR:
			    COPY_REAL(csubterm, psubterm);
			    *(*TR)++ = csubterm;
			    cdone= TRUE;
			    break;
			case REAL:
			    if (REALVALUE(psubterm) != REALVALUE(csubterm))
			    	return(FALSE);
			    cdone = TRUE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		default:
			return(FALSE);
		}  /* while switch */
	    } /* else */
	}  /* for */

	/* next term */
	thrumolecule = (BOOLEAN) *--stack;
	ctuple = *--stack;
	cterms = *--stack;
	ptuple = *--stack;
	pterms = *--stack;
    }   /* while */
    return(TRUE);
}


CreateRespForNonSeq(ptuple, ctuple, Y)
SLOT *ptuple;
SLOT *ctuple;
SLOT *Y;
{
    SLOT *oldterm, *newterm;
    SHORT i, tupsize = TUPLESIZE(ctuple);
    SHORT termsize, newsize = tupsize;
    MOLECULE_PTR *molecule;

    for (i = 1; i < tupsize; i++)
	if (ptuple[i] != ctuple[i])
	{
	    oldterm = &ctuple[i];
	    Deref_Term(oldterm, ctuple);
	    if (TAG_IS_SEQ_MOLECULE(oldterm))
	    {
		molecule = SEQ_MOLECULE_ADDRESS(oldterm);
		oldterm = TERMS(molecule);
		if (ARITY_IS_ZERO(oldterm))
		    COPY_SLOT(&Y[i], oldterm)
		else 
		{
		    termsize = TermSize(oldterm, TUPLE(molecule));
		    Malloc_Slots(newterm, termsize);
		    INSERT_ADDRESS(&Y[i], newterm); 
		    CopyTerm(oldterm, TUPLE(molecule), &newterm, &newsize);

		}
	    }
	    else if (TAG_IS_FUNCTOR(oldterm))
	    {
		if (ARITY_IS_ZERO(oldterm))
		    COPY_SLOT(&Y[i], oldterm)
		else 
		{
		    termsize = TermSize(oldterm, ctuple);
		    Malloc_Slots(newterm, termsize);
		    INSERT_ADDRESS(&Y[i], newterm);  
		    CopyTerm(oldterm, Y, &newterm, &newsize);

		}
	    }
	    else Y[i] = ctuple[i];
	}
	else Y[i] = ctuple[i];

    INSERT_TUPLE_SIZE(Y, newsize);
    if (newsize > tupsize)
       InitTuple((&Y[tupsize]), (newsize - tupsize));
}
