
/* This file contains all the ROPM process model routines for the compiler */

#ifdef PRIORITY
#define Priority
#endif

#include "typedefs.h"
#include "ropm.h"
#include "gen.h"
#include "macros.c"
#include "be_macros.c"

#define FAILKEY		/* doing failure detection	     */
#include "ropm_macros.c"

#ifdef PRIORITY
#include "priority_macros.c"
#endif

MESSAGE *RopmFirstMsg()

{ 
    MESSAGE  *ptrMsg;
    GOALSLOT *gSlot;
    ChareIDType mychareid;

    NewGoalSlot(gSlot,NULLPTR,0,0,NULL);
    MyChareID(&mychareid);
    NEWMSGGOALRESP(ptrMsg,MSGTYPE_GOAL,mychareid,(LONG)gSlot,NULL,0,0,0);
    ptrMsg->respEP = 0;

#ifdef PRIORITY
    ptrMsg->priority_vector = (PVECTOR *) OsAlloc(sizeof(PVECTOR));
    *ptrMsg->priority_vector = 0;
    if (DEBUG)
	OsPrintf("RopmFirstMsg priority_vector 0x%x, %o\n", ptrMsg->priority_vector, *ptrMsg->priority_vector);
#else
    ptrMsg->priority_vector = NULLPTR;
#endif

    return(ptrMsg);
}



QUERY *NewQuery(srcChareID,parentsGnum,nodeNum,arcNum,k, statusbits, respEP,msgPriority,clauseBits,clauseNum) 
ChareIDType	srcChareID;
LONG		parentsGnum;
SHORT 		nodeNum;
SHORT 		arcNum;
SHORT		k;
unsigned char   statusbits;
SHORT 		respEP;
PVECTOR		*msgPriority;
SHORT		clauseBits;
SHORT		clauseNum;
{ 
    char	*q;
    QUERY	*ptrQ;
    SHORT	i;
    SHORT	goal_vec_length, clause_vec_length;
    PVECTOR	*query_priority;

    Malloc_Block(ptrQ,k,QUERY);
    if (DEBUG)
        OsPrintf("allocated new query %x\n",ptrQ);
    OsCopyChareID( &(QUERYCHAREID(ptrQ)), &srcChareID);
    ptrQ->parentGnum  = parentsGnum;
    ptrQ->respNum = 0;
    ptrQ->nodeVec = 0; 
    ptrQ->statusbits = statusbits;
    ptrQ->respEP = respEP;
    ptrQ->activeTnum  = (SHORT *) (ptrQ + 1);

    for (i = 0; i < nodeNum; i++)
        ptrQ->activeTnum[i] = 0;

#ifdef PRIORITY
    /* get the priority vector for the Query */
	goal_vec_length = (*msgPriority >> 24);
	clause_vec_length =  goal_vec_length + clauseBits;
	if (clause_vec_length > 248)
		clause_vec_length = goal_vec_length;

	PGEN_GET_PVECTOR2(msgPriority,goal_vec_length,query_priority,clause_vec_length,clauseNum);
	ptrQ->priority_vector = query_priority;

    /* set the literal instance counter for 32 literals MAX to 0 */
    for ( i=0; i<32; i++ )
    	ptrQ->lit_start_count[i] = 0;

    if (DEBUG)
    {
	OsPrintf("NewQuery: clauseBits %d, clauseNum %d\n", clauseBits, clauseNum);
       OsPrintf("NewQuery: MsgPriority 0x%x, %o, new query Priority 0x%x, %o\n",
	 msgPriority,*msgPriority,query_priority,*query_priority);
    }
#endif

    return(ptrQ);
}




RopmRespCheck(ptrRespMsg, Dataptr)
MESSAGE *ptrRespMsg;
LocalArea *Dataptr;

{ 
    GOALSLOT *ptrGS = (GOALSLOT *) ptrRespMsg->goalSlot;
    QUERY *ptrQ = ptrGS->ptrQ; 

    if ( IS_RESP_CNUM(ptrRespMsg) || 
	(IS_RESP_DATA(ptrRespMsg) && (ptrQ->statusbits & STAT_DET))) 
    { 
        /* two possible cases: 						  */
        /* 1) MSGTYPE_RESPCNUM comes first,it must be init value '-1'	  */
        /* 2) MSGTYPE_RESPDONE comes first,it will be decreased only,<=-1 */
        if (ptrGS->clauseNum > -1) 
	    OsPrintf("ROPM: try to send more than one clause number\n");

        ptrGS->clauseNum += MSGCNUM(ptrRespMsg) + 1;
	if (DEBUG)
        OsPrintf("goal slot = %x, clauseNum =  %d, respRecv = %d\n",
	    ptrGS,ptrGS->clauseNum,ptrGS->respRecv);
        if (ptrQ->respEP == 0)  /* top level resp msg */
	    if (DEBUG)
	    OsPrintf("ROPM: top level resp msg, active clause # %d \n",
		   MSGCNUM(ptrRespMsg));
    }
    if (IS_RESP_RNUM(ptrRespMsg))
    { 
       	ptrGS->respRecv -= MSGRNUM(ptrRespMsg);
       	ptrGS->clauseNum--;
	if (DEBUG)
        OsPrintf("goal slot = %x, clauseNum = %d, respRecv = %d\n",
	    ptrGS,ptrGS->clauseNum,ptrGS->respRecv);
        if (ptrQ->respEP == 0)  /* top level resp msg */
	    if (DEBUG)
	    OsPrintf("ROPM: top level resp msg, resp # %d \n",
		    MSGRNUM(ptrRespMsg));
    }
    if (ptrGS->clauseNum == 0 && ptrGS->respRecv == 0)
    {
	CloseUpGoal(ptrGS, Dataptr, ptrRespMsg); 
	Free_Gslot(ptrGS);  
    }
}




CloseUpGoal(ptrGS, Dataptr, Msgptr)
GOALSLOT  *ptrGS;
LocalArea *Dataptr;
MESSAGE *Msgptr;

{ 
    QUERY	 *ptrQ = ptrGS->ptrQ;
    SHORT	 n = ptrGS->preNode;
    extern LONG  next_term;   /* for debugging information only */
    MESSAGE      *ptrMsg;
    PVECTOR	*resp_priority = NULLPTR;

    if (DEBUG)
        OsPrintf("Closing up goal slot %x, active tuples =  %d\n",ptrGS,
		 ptrQ->activeTnum[n]-1);
    if (--ptrQ->activeTnum[n] == 0) 
    { 
	/* this node is possibly done */
	ptrQ->nodeVec &= ~(1 << n);

  	if (ptrQ->nodeVec == 0) 
	{
	    if (ptrQ->respEP == 0) 
	    { 
		OsPrintf("\n@@@@@@@@@@@@@@@@ SYSTEM DONE @@@@@@@@@@@@@@\n");
#ifndef SHARED
		OsPrintf("\n%d ms elapsed time\n\n", OsGetSysClk());
#endif
		if (DEBUG)
		OsPrintf("Term space usage is %d slots\n",next_term);
		OsKillSys();
	    }
	    else 
	    {
		if (DEBUG)
		OsPrintf("closing query... \n");
		/* this query is done */
		if (!(ptrQ->statusbits & STAT_DET))
#ifdef PRIORITY
		PGEN_IDENTICAL_PVECTOR(ptrQ->priority_vector, resp_priority);
#endif
		    SendRespMsg(MSGTYPE_RESPRNUM, QUERYCHAREID(ptrQ), 
			    ptrQ->parentGnum, NULL, ptrQ->respNum, 0, 0,
			    resp_priority); 
		            	    /* entrypt = 0 for pure control msg */
	    }
	    Dataptr->querycount--;
	    if (Dataptr->querycount == 0)     /* chare is finished */
	        OsKillMyself();    
#ifdef PRIORITY
	    OsFree(ptrQ->priority_vector);
#endif
	    TrashGarbage(ptrQ); 
	}
    }
}







