#include "typedefs.h"
#include "be_macros.c"
#include "macros.c"


#define MIN(A,B)  ((A < B) ? A : B)

SLOT *BeJoinTuples(tuple1, tuple2, basesize, numchains,numbackptrs, numfwdptrs)
SLOT *tuple1;
SLOT *tuple2;
SHORT   basesize;
SHORT numchains;
SHORT numbackptrs, numfwdptrs;
{ 
    register    SHORT j;
    SHORT	min=0, max=1, nextslot;
    SLOT	*tAry[2], *DuplicateTuple();
    SLOT        *p1, *p2;
    void 	RenumberVars();
    SHORT       tsize1 = TUPLESIZE(tuple1);
    SHORT       tsize2 = TUPLESIZE(tuple2);
    SHORT 	minsize;

    tAry[0] = tuple1; tAry[1] = tuple2;
    if (tsize1 > tsize2) 
    {
	min = 1; 
	max = 0; 	/* exchange min and max */
    } 
    minsize = MIN(tsize1, tsize2) - basesize;
    tAry[max] = DuplicateTuple(tAry[max], minsize, numchains,
			       numbackptrs, numfwdptrs);
    nextslot = MAX(tsize1, tsize2);
    p1 = &tAry[max][0]; 
    p2 = &tAry[min][0];
    for (j = 1; j < basesize; j++)
    {
	if (!TAG_IS_UNBOUND(&(p2[j])))
	    if ( TAG_IS_UNBOUND(&(p1[j])))
	    {
		COPY_SLOT(&(p1[j]),&(p2[j]));
		if (TUPLESIZE(tAry[min]) > basesize)
		    RenumberVars(p1, &p2[j], p2, nextslot, basesize);
	    }
    }
    return(tAry[max]);
}





void RenumberVars(Ptuple, term, Ctuple, nextslot, basesize)
SLOT *Ptuple;
SLOT *term;
SLOT *Ctuple;
SHORT nextslot;
SHORT basesize;

{ 
    register SHORT j;
    SLOT *subterm;
    SHORT arity;
    
    Chase_Term(term, Ctuple);
    if (TAG_IS_TUPLE_INDEX_1(term))
    { 
	if (INDEX(term) >= basesize)
	{
	    COPY_SLOT(&(Ptuple[nextslot + INDEX(term) - basesize]), 
		      &(Ctuple[INDEX(term)]));
	    INSERT_INDEX(term, nextslot + INDEX(term) - basesize, 
			 TUPLE_INDEX_1);
	}
    }
    else if (TAG_IS_FUNCTOR(term))
    { 
	arity = ARITY(term);
	for (j = 1; j <= arity; j++)
	{
	    subterm = &term[j];
	    RenumberVars(Ptuple,subterm,Ctuple, nextslot, basesize);
	}
    }
}




SLOT *DuplicateTuple(ptrOld, appendSze, chainnum, bptrnum, fptrnum)
SLOT  *ptrOld;
SHORT appendSze;
SHORT chainnum;
SHORT bptrnum, fptrnum;
{ 
    register SHORT  i;
    SHORT  size= TUPLESIZE(ptrOld);
    SLOT   *ptrNew;

    if (size + appendSze == 1)
    	ptrNew = NULL;
    else
    {
	Malloc_NodeTuple(ptrNew, size + appendSze, chainnum, bptrnum, fptrnum);
	INSERT_TUPLE_SIZE(ptrNew, size+appendSze);
	CopyTuple(ptrNew, ptrOld);
	InitTuple((ptrNew + size), appendSze);
    }
    return(ptrNew);
}









