#ifndef INCLUDE_HOST
#define INCLUDE_HOST
/*
 *	machine.h - interface to portable (unix) uniprocessor version
 */

/*	MaxPe is the maximum number of parallel processes the system
 *	will support.  it must be a constant. 
 */
#define MaxPe 1

/*	MyPenum is a unique integer index between 0 and MaxPe-1 associated
 *	with each parallel process.  This is used as an array index to
 *	allow data to be local to a process on machines, such as the max,
 *	which don't otherwise support local data!
 */
#define MyPenum 0
#define MaxMem 1000000

#define SHARED 1
#define NULLPTR 0L
typedef unsigned char BYTE;	/* this defn is m/c dependent. 
				   It must be 8 bits */
typedef short SHORT;		/* this defn is m/c dependent. 
				   It must be 16 bits */
typedef long LONG;	     	/* this defn is m/c dependent. 
				   It must be 32 bits */
typedef unsigned char BOOLEAN;
typedef unsigned int PVECTOR;

/*	OsSpinInit, OsSpinLock and OsSpinUnlock
 *	initialize, reserve and release a spin lock, respectively.
 *	the argument to each of these functions is a variable of type
 *	LOCK, which is typedef'd appropriately.  (Spin locks are implemented
 *	variously as pointers or structures.)
 */
typedef int * SPINLOCK;   /* locks are unused in uniprocessor version */
#define OsSpinInit(l) 
#define OsSpinLock(l) 
#define OsSpinUnlock(l) 

/*	OsMalloc is the system's native malloc */

#define OsSharedMalloc(l) malloc(l)
#define OsSharedMfree(l) free(l)

/* 	OsAllocMsg and OsAlloc are the same on the max.
	OsFreeMsg and OsFree are the same on the max.
*/

#define OsAllocMsg(n)  OsAlloc(n)
#define OsFreeMsg(p)   OsFree(p)

/*	private and shared are special C declarators which designate variables
 *	residing in private or shared memory.  if the system doesn't have a
 *	way to distinguish these, #define them to null.  currently only
 *	shared is used.
 */
#define private
#define shared

#define OsMyid MyPenum

#ifndef NULL
#define NULL 0
#endif

#endif
