
#include "host.h"
#include "cksys.h"

#include "qs_bitvec.h"
#include "qs_bitvec_macros.c"

#define TRACEQS(p)
#define MaxChares 20000 
#define MaxResps  20000 

#define		QSEMPTYRESPONSES(Penum)	RespHeapTop[Penum] < 0
#define		QSEMPTYCHARES		ChareHeapTop < 0
#define		QSLOCKCHARES()		OsSpinLock( chareLock )
#define		QSUNLOCKCHARES()	OsSpinUnlock( chareLock )
#define		QSLOCKRESPONSES(Penum)	OsSpinLock( respLock[Penum] )
#define		QSUNLOCKRESPONSES(Penum)	OsSpinUnlock( respLock[Penum] )

SPINLOCK chareLock;
SPINLOCK respLock[MaxPe];

int	PrintQueStat = FALSE;
extern  shared	int numPe;
shared	int MaxVectorLength;

int	ChareStackLength = 0;
int	MaxChareStackLength = 0;
int	RespStackLength[MaxPe];
int	MaxRespStackLength = 0;
int	MaxStackLength[MaxPe];


int 	ChareHeapTop;
SYSMSG	*ChareHeap[MaxChares];

int 	RespHeapTop[MaxPe];
SYSMSG	*RespHeap[MaxPe][MaxResps];


QSInit()
{
	int i, j, Penum;

	OsSpinInit(chareLock);
	ChareHeapTop = -1;

	for (Penum=0; Penum < MaxPe; Penum++)
	{
 		OsSpinInit(respLock[Penum]);
		RespHeapTop[Penum] = -1;
 		RespStackLength[Penum] = 0;
 		MaxStackLength[Penum] = 0;
	}

	for (i=0; i < MaxChares; i++)
		ChareHeap[i] = NULLPTR;

	for(j=0; j < MaxPe; j++)
	   for (i=0; i < MaxResps; i++)
		RespHeap[j][i] = NULLPTR;
}


QSEmptyResponses(Penum)
int Penum;
{
	return( RespHeapTop[Penum] < 0 );
}

QSEmptyChares()
{
	return( ChareHeapTop < 0 );
}


QSEnQueueChare(EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect CreateChare() call, use CreateChareGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueResponse(Penum,EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect SendMsg() call, use SendMsgGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueChareGen(EP,Msg,MsgSize,AR,Prio,NeedToPack)
unsigned *Prio;
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueChareGen: CHARE"));
TRACEQS(qs_print_bit_vector(Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, Prio, SYSMSGTYPE_CHAR);

	QsLockChares();
	QmEnQueueChareMsg(mPtr);
	QsUnlockChares();
}


QSEnQueueResponseGen(Penum,EP,Msg,MsgSize,AR,Prio,NeedToPack)
unsigned *Prio;
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueResponseGen:PE %d, RESPMSG:",Penum));
TRACEQS(qs_print_bit_vector(Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, Prio, SYSMSGTYPE_RESP);

	QsLockResponses(Penum);
	QmEnQueueRespMsg(mPtr, Penum);
	QsUnlockResponses(Penum);
}


PickNextMsg(MsgType, CurrentAR,  CurrentMsg,  CurrentEP)
 int *CurrentAR,  *CurrentMsg,  *CurrentEP;
 JOBTYPE *MsgType;
     /* First check if there is any response for local chares
	(note: this assumes anchoring, and so avoid the need to lock chares)
	If empty, check the global pool of CreateChare messages */
{ 
  unsigned 	*resp_priority;

  QSLOCKRESPONSES(MyPenum);
  if (QSEMPTYRESPONSES(MyPenum))
  {
     QSUNLOCKRESPONSES(MyPenum);
     QSLOCKCHARES();
     if (QSEMPTYCHARES) {QSUNLOCKCHARES(); return(NULL); }
       else 
       { QSDeQueueChare(MsgType, CurrentAR,CurrentMsg,CurrentEP); 
	      QSUNLOCKCHARES(); }
  }
  else
  {
     resp_priority = RespHeap[MyPenum][0]->sysMsgPVector;
     QSUNLOCKRESPONSES(MyPenum);

     QSLOCKCHARES();
     if (QSEMPTYCHARES)
	{ 
	   QSUNLOCKCHARES();
  	   QSLOCKRESPONSES(MyPenum);
     	   QSDeQueueResponse(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     	   QSUNLOCKRESPONSES(MyPenum);
	}
	else
	{
	   if (GreaterThanEqual(ChareHeap[0]->sysMsgPVector,resp_priority))
	   {
		QSUNLOCKCHARES();
  		QSLOCKRESPONSES(MyPenum);
     		QSDeQueueResponse(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     		QSUNLOCKRESPONSES(MyPenum);
	   }
	   else
	   {
       		QSDeQueueChare(MsgType,CurrentAR,CurrentMsg,CurrentEP); 
		QSUNLOCKCHARES();
	   }
	}
    }
	
return(1);
}


QSDeQueueChare(MsgType,CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueChareMsg();

	mPtr = QmDeQueueChareMsg();

	*MsgType    = JOBTYPE_CHARE;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}



QSDeQueueResponse(Penum, MsgType, CurrentAR, CurrentMsg, CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
int Penum;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueRespMsg();

	mPtr = QmDeQueueRespMsg(Penum);

	*MsgType    = JOBTYPE_RESP;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}


QmEnQueueChareMsg(mPtr)
SYSMSG	*mPtr;
{
	int 	parent, child;

	ChareHeapTop++;

	if ( ChareHeapTop > MaxChares )
	{
		OsPrintf("ChareHeap Overflow: Heap Size set to %d\n",MaxChares);
		OsKillSys();
		exit(1);
	}

	if ( PrintQueStat == TRUE )
	{
		ChareStackLength++;
		if ( ChareStackLength > MaxChareStackLength)
			MaxChareStackLength = ChareStackLength;
	}

	if ( (*(mPtr->sysMsgPVector) >> 24) > MaxVectorLength )
		MaxVectorLength = *(mPtr->sysMsgPVector) >> 24;

	child = ChareHeapTop;
	if (child > 0)
		parent = (ChareHeapTop-1) >> 1; /* array starts at zero */
	else
		parent = 0;

	/* while child >0 & parent priority > mPtr->priority */
	while ( (child > 0) && 
		GreaterThan(ChareHeap[parent]->sysMsgPVector, mPtr->sysMsgPVector) )
	{

		ChareHeap[child] = ChareHeap[parent];
		ChareHeap[child]->sysMsgPVector = ChareHeap[parent]->sysMsgPVector;

		child = parent;
		parent = (parent-1) >> 1; /* array starts at zero */
	}
	ChareHeap[child] = mPtr;
}


SYSMSG 	*QmDeQueueChareMsg()
{
	SYSMSG		*mPtr = NULLPTR;

     if (ChareHeap[0] != NULLPTR)
     {
	mPtr = ChareHeap[0];
	ChareHeap[0] = NULLPTR;
	mPtr->sysMsgNextPtr = NULLPTR;

	if ( PrintQueStat == TRUE ) ChareStackLength--;

	/* Restore the ChareHeap */
	QmRestoreChareHeap();
     }
     return(mPtr);
}


/* reorganize the heap */
QmRestoreChareHeap()
{

	SYSMSG		*temp_stack_ptr;
	PVECTOR		*temp_priority;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = ChareHeapTop;
   	ChareHeapTop--;

	switch (last_item)
	{
	case 0 :
	   	ChareHeap[0] = NULLPTR;
		break;

	case 1 :
		ChareHeap[0] = ChareHeap[1];
	   	ChareHeap[1] = NULLPTR;
		break;

	default :
	   temp_stack_ptr = ChareHeap[last_item];
	   temp_priority = ChareHeap[last_item]->sysMsgPVector;
	   ChareHeap[last_item] = NULLPTR;

	   while ( child1 <= ChareHeapTop && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= ChareHeapTop) && 
		   GreaterThan(ChareHeap[child1]->sysMsgPVector, ChareHeap[child2]->sysMsgPVector))
		   min = child2;

		if (GreaterThan(temp_priority, ChareHeap[min]->sysMsgPVector)) 
		{
		   ChareHeap[parent] = ChareHeap[min];

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   ChareHeap[parent] = temp_stack_ptr;

	} /* switch */
}


QmEnQueueRespMsg(mPtr,Penum)
SYSMSG	*mPtr;
int	Penum;
{
	int 	parent, child;
	int	j, TotStackLength = 0;

	RespHeapTop[Penum]++;

	if ( RespHeapTop[Penum] > MaxResps )
	{
		OsPrintf("ResponseHeap Overflow for PE %d: Heap Size set to %d\n", Penum, MaxResps);
		OsKillSys();
		exit(1);
	}

	if ( PrintQueStat == TRUE )
	{
	   RespStackLength[Penum]++;
	   for (j=0; j<numPe; j++) 
 		TotStackLength += RespStackLength[j];

	   if( TotStackLength > MaxRespStackLength )
		MaxRespStackLength = TotStackLength;

	   TotStackLength += ChareStackLength;

	   if( TotStackLength > MaxStackLength[Penum] )
		MaxStackLength[Penum] = TotStackLength;
	}

	if ( (*(mPtr->sysMsgPVector) >> 24) > MaxVectorLength )
		MaxVectorLength = *(mPtr->sysMsgPVector) >> 24;

	child = RespHeapTop[Penum];
	if (child > 0)
		parent = (RespHeapTop[Penum]-1) > 1; /* array starts at zero */
	else
		parent = 0;

	/* while child >0 & parent priority > mPtr->priority */
	while ( (child > 0) && 
		GreaterThan(RespHeap[Penum][parent]->sysMsgPVector, mPtr->sysMsgPVector) )
	{
		RespHeap[Penum][child] = RespHeap[Penum][parent];

		child = parent;
		parent = (parent-1) > 1; /* array starts at zero */
	}
	RespHeap[Penum][child] = mPtr;

}


SYSMSG 	*QmDeQueueRespMsg(Penum)
int	Penum;
{
	SYSMSG		*mPtr = NULLPTR;

     if (RespHeap[Penum][0] != NULLPTR)
     {
	mPtr = RespHeap[Penum][0];
	RespHeap[Penum][0] = NULLPTR;
	mPtr->sysMsgNextPtr = NULLPTR;

	if ( PrintQueStat == TRUE ) RespStackLength[Penum]--;

	/* Restore the Heap */
	QmRestoreRespHeap(Penum);
     }
     return(mPtr);
}


/* Restore Response Heap */
QmRestoreRespHeap(Penum)
int	Penum;
{

	SYSMSG		*temp_stack_ptr;
	PVECTOR		*temp_priority;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = RespHeapTop[Penum];
   	RespHeapTop[Penum]--;

	switch (last_item)
	{
	case 0 :
	   	RespHeap[Penum][0] = NULLPTR;
		break;

	case 1 :
		RespHeap[Penum][0] = RespHeap[Penum][1];
	   	RespHeap[Penum][1] = NULLPTR;
		break;

	default :
	   temp_stack_ptr = RespHeap[Penum][last_item];
	   temp_priority = RespHeap[Penum][last_item]->sysMsgPVector;
	   RespHeap[Penum][last_item] = NULLPTR;

	   while ( child1 <= RespHeapTop[Penum] && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= RespHeapTop[Penum]) && 
		   GreaterThan(RespHeap[Penum][child1]->sysMsgPVector, RespHeap[Penum][child2]->sysMsgPVector))
		   min = child2;

		if (GreaterThan(temp_priority, RespHeap[Penum][min]->sysMsgPVector)) 
		{
		   RespHeap[Penum][parent] = RespHeap[Penum][min];

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   RespHeap[Penum][parent] = temp_stack_ptr;

	} /* switch */
}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int GreaterThan(p, q)
unsigned *p, *q;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) > (*q & 0x0ffffff) )
		return(TRUE);

	if ( (*p & 0x0ffffff) < (*q & 0x0ffffff) )
		return(FALSE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
	{
		if ( *p_ptr > *q_ptr )
			return(TRUE);
		else
			return(FALSE);
	}
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		else
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(FALSE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int GreaterThanEqual(p, q)
unsigned *p, *q;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) < (*q & 0x0ffffff) )
		return(FALSE);

	/* Proceed since the first words are >= */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
	{
		if ( *p_ptr > *q_ptr )
			return(TRUE);
		else
			return(FALSE);
	}
	else
	{
	    if ( count > max_size )
		return(TRUE);
	    else
	    {
		if ( max_size == p_size )
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		else
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(FALSE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}

		if ( count > max_size )
			return(TRUE);
	    }

	}

}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int NotEqual(p, q)
unsigned *p, *q;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) != (*q & 0x0ffffff) )
		return(TRUE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
		return(TRUE);
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
		{
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		}
		else
		{
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(TRUE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}
		}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}


int	qs_vector_size( vector_ptr )
unsigned	*vector_ptr;
{
	int	k;

	if ( (*vector_ptr >> 24) > 24 )
		k = (((*vector_ptr >> 24) - 25) >> 5) + 2;
	else
		k = 1;

	return(k);
}


qs_copy_vector(vector1_ptr, vector2_ptr)
unsigned 	*vector1_ptr, *vector2_ptr;
{
	unsigned	vector1_length, *p_ptr, *c_ptr;
	int		vector1_size;

	p_ptr = vector1_ptr;
	c_ptr = vector2_ptr;
	vector1_length = (*p_ptr >> 24) & 0x0ff;

	if ( vector1_length > 24 )
		vector1_size = ((vector1_length-25) >> 5) + 2;
	else
		vector1_size = 1;

        for (p_ptr=vector1_ptr;p_ptr<(vector1_ptr+vector1_size);p_ptr++,c_ptr++)
		*c_ptr = *p_ptr;
}



qs_print_sys_vector(vector_ptr)
unsigned	*vector_ptr;
{
	unsigned	*ptr, vector_length;
	int		vector_size;

	vector_length = (*vector_ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ((vector_length - 25) >> 5) + 2;

	OsPrintf("QS:SysVec Length = %d, Size = %d\n",vector_length,vector_size);
	OsPrintf("QS:SysVec: ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		OsPrintf("%x %o\t", ptr, *ptr);

	OsPrintf("\n");
}


qs_print_bit_vector(vector_ptr)
unsigned	*vector_ptr;
{
	unsigned	*ptr, vector_length;
	int		vector_size;

	vector_length = (*vector_ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ((vector_length - 25) >> 5) + 2;

	OsPrintf("Priority = ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		OsPrintf("%o\t", *ptr);

	OsPrintf("\n");
}


QsLockChares()
{
    OsSpinLock( chareLock );
}


QsUnlockChares()
{
    OsSpinUnlock( chareLock );
}


QsLockResponses(Penum)
int Penum;
{
    OsSpinLock( respLock[Penum] );
}


QsUnlockResponses(Penum)
int Penum;
{
    OsSpinUnlock( respLock[Penum] );
}


QueueStatus()
{
	int i, max_stack_length = 0;

   if ( PrintQueStat == TRUE )
   {
	for ( i=0; i<numPe; i++)
		if ( MaxStackLength[i] > max_stack_length )
			max_stack_length = MaxStackLength[i];

	OsPrintf("Queue Status:\n");
	OsPrintf("MaxStackLength %d, MaxChareStack %d, MaxRespStack %d, MaxVectorLength %d\n",
	max_stack_length, MaxChareStackLength, MaxRespStackLength, MaxVectorLength);
   }
}


