#include <stdio.h>

typedef unsigned char BYTE; /* this defn. is m/c dep.  It must be 8 bits */
typedef short SHORT;	/* this defn is m/c dependent. It must be 16 bits */
typedef int LONG;	/* this defn is m/c dependent. It must be 32 bits */
typedef unsigned char BOOLEAN;

#define MEM_SPACE(x) mem_space
#define MEM_TBL(x)   mem_tbl
#define MEM_PTR(x)   mem_ptr

/* definition of constants */
#define FALSE		0
#define TRUE		!FALSE
#define NULLPTR		0L
#define DUMMY		-9999	
#define MAXINT		0x7FFFFFFF  /* machine dept, vax int = 4 bytes	*/
#define MAXNUM		0xFFFFFFFF  /* machine dept, vax int = 4 bytes	*/


#define MAXMEMSIZE	8000

extern int *mem_space;
extern int mem_ptr;
extern int maxMem;
extern int mem_tbl[][4];


#define HashChare(EP,pMsg,Msize,CDsize,KEY)\
		OsHashChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,NULLPTR,DUMMY,KEY)
#define CreateChare(EP,pMsg,Msize,CDsize)\
		OsCreateChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,NULLPTR,DUMMY,0x0000)
#define CreateChareGen(EP,pMsg,Msize,CDsize,Priority,NeedToPack)\
		OsCreateChare(EP,pMsg,Msize,Priority,NeedToPack,\
			CDsize,NULLPTR,DUMMY,0x0000)
#define CreateChareLogic(EP,pMsg,Msize,CDsize,ID)\
		OsCreateChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,NULLPTR,DUMMY,ID)
#define CreateChareIDback(EP,pMsg,Msize,CDsize,idPtr)\
		OsCreateChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,idPtr,DUMMY,0x0000)
#define CreateChareIDbackAtPE(EP,pMsg,Msize,CDsize,idPtr,PE)\
		OsCreateChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,idPtr,PE,0x0000)

#define FirstChare(EP,pMsg,Msize,CDsize)\
		OsFirstChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,NULLPTR,DUMMY,0x0000)
#define FirstChareLogic(EP,pMsg,Msize,CDsize,ID)\
		OsFirstChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,NULLPTR,DUMMY,ID)
#define FirstChareAtPE(EP,pMsg,Msize,CDsize,PE)\
		OsFirstChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,NULLPTR,PE,0x0000)
#define FirstChareAtPELogic(EP,pMsg,Msize,CDsize,PE,ID)\
		OsFirstChare(EP,pMsg,Msize,0,FALSE,\
			CDsize,NULLPTR,PE,ID)

#define SendResult(EP, pMsg, mSize, idPtr)\
		OsSendResult(EP,pMsg,mSize,0,FALSE,idPtr)
#define SendMsg(EP, pMsg, mSize, idPtr)\
		OsSendMsg(EP,pMsg,mSize,0,FALSE,idPtr)
#define SendMsgGen(EP, pMsg, mSize, idPtr, Priority, NeedToPack)\
		OsSendMsg(EP,pMsg,mSize,Priority,NeedToPack,idPtr)

typedef struct str_usr3 {
    int		pe;
    int	       	ch;
} ChareIDType;

