/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * sys_sub.c
 *
 * Foreign procedures used by sys.pcn
 */

#include "sys_internal.h"

/*
 * Set 'substring' to be the substring of 'string' starting at position
 * 'start' and of 'len' characters.  If 'len' is -1, then get that
 * substring that starts at 'start' and goes through the end
 * of the 'string'
 *
 * It is assumed that 'substring'
 * is big enough to hold the 
 */
void _p_sys_substring(string, start, len, substring)
char_t *string;
int_t *start, *len;
char_t *substring;
{
    if (*len < 0)
	strcpy(substring, string + *start);
    else
    {
	strncpy(substring, string + *start, (int) *len);
	substring[*len] = '\0';
    }
}

