/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * sys_find_sub.c
 *
 * Foreign procedures used by sys.pcn
 */

#include "sys_internal.h"

/*
 * Set 'idx' to be the position of the first occurance of 'substring'
 * in 'string'.
 */
void _p_sys_find_substring(string, substring, idx)
char_t *string;
char_t *substring;
int_t *idx;
{
    char *s;
    int sublen;

    sublen = strlen(substring);

    s = string;
    while ((s = strchr(s, *substring)) != (char *) NULL)
    {
	if (strncmp(s, substring, sublen) == 0)
	{
	    *idx = (int_t) (s - string);
	    return;
	}
	else
	{
	    s++;
	}
    }
    *idx = -1;
}
