/*
 * PCN System Linker -- pcnlink
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * link_reply.c		- Support routines for link_reply.pcn
 *
 * Foreign procedures used for procedure information generation
 * into the custom info file.
 */

#include "link_internal.h"


/*
 * _p_link_reply_proc_externs()
 */
void _p_link_reply_proc_externs(buf, buf_len, file_number, module_number,
				proc_number)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "EPH _p_%ld_%ld_%ld;\n",
	    (long) *file_number, (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_proc_externs(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_proc_externs() */


/*
 * _p_link_reply_for_extern()
 */
void _p_link_reply_for_extern(buf, buf_len, for_string)
char_t *buf;
int_t *buf_len;
char_t *for_string;
{
    sprintf((char *) buf,
	    "EF %s();\n",
	    (char *) for_string);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_for_extern(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_for_extern() */


/*
 * _p_link_reply_for_table()
 */
void _p_link_reply_for_table(buf, buf_len, for_string)
char_t *buf;
int_t *buf_len;
char_t *for_string;
{
    sprintf((char *) buf,
	    "{\"%s\",FC %s},\n",
	    (char *) for_string, (char *) for_string);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_for_table(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_for_table() */


/*
 * _p_link_reply_constants()
 */
_p_link_reply_constants(buf, buf_len, def_string, string_len, type_string,
			file_number, module_number,
			proc_number, cnt, quote_string, const_string)
char_t *buf;
int_t *buf_len;
char_t *def_string;
int_t *string_len;
char_t *type_string;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
int_t *cnt;
char_t *quote_string;
char_t *const_string;
{
    sprintf((char *) buf,
	    "%s(%ld, %s_%ld_%ld_%ld_%ld, %s%s%s);\n",
	    (char *) def_string, (long) *string_len, (char *) type_string,
	    (long) *file_number, (long) *module_number,
	    (long) *proc_number, (long) *cnt,
	    (char *) quote_string, (char *) const_string,
	    (char *) quote_string);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_constants(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_constants() */


/*
 * _p_link_reply_counters()
 */
void _p_link_reply_counters(buf1, buf1_len, buf2, buf2_len,
			    file_number, module_number,
			    proc_number, n_counters, n_timers)
char_t *buf1;
int_t *buf1_len;
char_t *buf2;
int_t *buf2_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
int_t *n_counters;
int_t *n_timers;
{
    sprintf((char *) buf1,
	    "SI cnt_%ld_%ld_%ld[%ld];\n",
	    (long) *file_number, (long) *module_number, (long) *proc_number,
	    (long) *n_counters);
    sprintf((char *) buf2,
	    "SI tm_%ld_%ld_%ld[%ld];\n",
	    (long) *file_number, (long) *module_number, (long) *proc_number,
	    (long) *n_timers * 2);
#ifdef DEBUG_BUF_OVERFLOW
    if ((strlen((char *) buf1) >= *buf1_len)
	|| (strlen((char *) buf2) >= *buf2_len))
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_reply_counters(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_counters() */


/*
 * _p_link_reply_proc_headers_1()
 */
void _p_link_reply_proc_headers_1(buf, buf_len, module_name, proc_name, arity,
				  file_number, module_number, proc_number)
char_t *buf;
int_t *buf_len;
char_t *module_name;
char_t *proc_name;
int_t *arity;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "PH _p_%ld_%ld_%ld={\"%s\",\"%s\",%ld,pc_%ld_%ld_%ld,\n",
	    (long) *file_number, (long) *module_number, (long) *proc_number,
	    (char *) module_name, (char *) proc_name, (long) *arity,
	    (long) *file_number, (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_proc_headers_1(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_proc_headers_1() */


/*
 * _p_link_reply_proc_headers_2()
 */
void _p_link_reply_proc_headers_2(buf, buf_len, file_number, module_number,
				  proc_number, n_counters, n_timers)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
int_t *n_counters;
int_t *n_timers;
{
    sprintf((char *) buf,
	    "#ifdef GAUGE\ntm_%ld_%ld_%ld,%ld,cnt_%ld_%ld_%ld,%ld,tm_%ld_%ld_%ld,",
	    (long) *file_number, (long) *module_number, (long) *proc_number,
	    (long) *n_counters,
	    (long) *file_number, (long) *module_number, (long) *proc_number,
	    (long) *n_timers,
	    (long) *file_number, (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_proc_headers_2(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_proc_headers_2() */


/*
 * _p_link_reply_proc_headers_3()
 */
void _p_link_reply_proc_headers_3(buf, buf_len, file_number, module_number,
				  proc_number)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "&_p_%ld_%ld_%ld,\n",
	    (long) *file_number, (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_proc_headers_3(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_proc_headers_3() */


/*
 * _p_link_reply_proc_headers_model_1()
 */
void _p_link_reply_proc_headers_model_1(buf, buf_len, file_number,
					module_number, proc_number)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "model_%ld_%ld_%ld,",
	    (long) *file_number, (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_proc_headers_model_1(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_proc_headers_model_1() */


/*
 * _p_link_reply_proc_headers_model_2()
 */
void _p_link_reply_proc_headers_model_2(buf, buf_len, file_number,
					module_number, proc_number)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "SCH *model_%ld_%ld_%ld[]={",
	    (long) *file_number, (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_reply_proc_headers_model_2(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_reply_proc_headers_model_2() */


