/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * pcn_upshot.h
 *
 * These are some convenient definitions for using Upshot with PCN (and
 * with C procedures that are called by PCN).  To use them:
 *
 *	- Include this file in your code with #include "pcn_upshot.h"
 *	- Insert LOG_EVENT(), LOG_TASK_EVENT(), and/or LOG_TASK_EVENT_DATA()
 *		calls into your PCN or C code
 *	- Compile your code with "pcncomp -profile", or add
 *		a -DUPSHOT flag to your compile line.
 *
 * Then when you no longer want the upshot calls in your code, just
 * leave the -DUPSHOT off the compile line and they will go away.
 */

#ifndef _PCN_INCLUDE_PCN_UPSHOT_H
#define _PCN_INCLUDE_PCN_UPSHOT_H

#if defined(UPSHOT) || defined(PCN_PROFILE)

#ifdef PCN

#define LOG_EVENT(event_type) \
    pcn_log_event(event_type)
#define LOG_TASK_EVENT(task_id, event_type) \
    pcn_log_task_event(task_id, event_type)
#define LOG_TASK_EVENT_DATA(task_id, event_type, data_val) \
    pcn_log_task_event_data(task_id, event_type, data_val)

#else /* PCN */

extern void c_log_event(
#ifndef PCN_NO_PROTOTYPES			
			int
#endif			
			);
extern void c_log_task_event(
#ifndef PCN_NO_PROTOTYPES			
			int, int
#endif			
			);
extern void c_log_task_event_data(
#ifndef PCN_NO_PROTOTYPES			
			int, int, int
#endif			
			);

#define LOG_EVENT(event_type) \
    c_log_event(event_type)
#define LOG_TASK_EVENT(task_id, event_type) \
    c_log_task_event(task_id, event_type)
#define LOG_TASK_EVENT_DATA(task_id, event_type, data_val) \
    c_log_task_event_data(task_id, event_type, data_val)

#endif /* PCN */

#else /* UPSHOT || PCN_PROFILE */

#define LOG_EVENT(event_type)
#define LOG_TASK_EVENT(task_id, event_type)
#define LOG_TASK_EVENT_DATA(task_id, event_type, data_val)

#endif /* UPSHOT || PCN_PROFILE */    

#endif /* _PCN_INCLUDE_PCN_UPSHOT_H */
