/*
 * PCN System Linker -- pcnlink
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * pcn_linker.h
 *
 * Miscellaneous header information needed by the linker.
 */

#ifndef _PCN_INCLUDE_PCN_LINKER_H
#define _PCN_INCLUDE_PCN_LINKER_H

#define LINKER_NAME "pcnlink"

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif


/*
 * Used for communication from the procedure handler to the
 * node driver to tell the node driver if the procedure
 * handler has terminated or is continuing execution as
 * a result of the latest request.
 */
#define PROC_TERMINATE	0
#define PROC_CONTINUE	1


/*
 * Procedure table message types.
 */
#define PROC_TABLE_NOT_FOUND	-1


/*
 * Some debugging stuff
 */
/*
#ifndef DEBUG
#define DEBUG 1
#define DEBUG_BUF_OVERFLOW 1
#endif
*/

#define DG_G_DRIVER		1
#define DG_N_DRIVER		2
#define DG_FILES		3
#define DG_PROC			4
#define DG_TABLE		5
#define DG_CALLS		6
#define DG_WRITE		7
#define DG_CODE			8


/*
 * Requests that the procedure handler will receive.
 */
#define REQUEST_CALLED_BY	1
#define REQUEST_STOP_IF_UNUSED	2
#define REQUEST_RESOLVE_CALLS	3
#define REQUEST_PROC_EXTERNS	4
#define REQUEST_FOR_EXTERNS	5
#define REQUEST_FOR_TABLE	6
#define REQUEST_CONSTANTS	7
#define REQUEST_COUNTERS	8
#define REQUEST_CODE		9
#define REQUEST_PROC_HEADERS	10
#define REQUEST_TERMINATE	11


/*
 * Reply codes to requests...
 */
#define REPLY_OUTPUT		101
#define REPLY_OUTPUT_LIST	102
#define REPLY_MESSAGE		103
#define REPLY_ERROR_BAD_CALL	104


/*
 * The 'params' tuple is passed around to everything and contains
 * parameters that define the specific actions of the run.  It is
 * just a tuple containing all of the parameters.  The
 * following macros can be used to access the various parameters
 * by name.
 */
#define params_boot_mod				params[0]
#define params_boot_proc			params[1]
#define params_main_mod				params[2]
#define params_main_proc			params[3]
#define params_verbose				params[4]
#define params_strip_trailing_underscore	params[5]
#define params_pdb				params[6]
#define params_profile				params[7]
#define params_link_all				params[8]
#define params_dg_g_driver_level		params[9]
#define params_dg_n_driver_level		params[10]
#define params_dg_files_level			params[11]
#define params_dg_proc_level			params[12]
#define params_dg_table_level			params[13]
#define params_dg_calls_level			params[14]
#define params_dg_write_level			params[15]
#define params_dg_code_level			params[16]

#define PARAMS_TUPLE_SIZE		17
    
/*
 * Default values for the params
 */
#define DEFAULT_BOOT_MOD			"boot"
#define DEFAULT_BOOT_PROC			"boot"
#define DEFAULT_MAIN_MOD			"main"
#define DEFAULT_MAIN_PROC			"main"
#define DEFAULT_VERBOSE				FALSE
#define DEFAULT_STRIP_TRAILING_UNDERSCORE	FALSE
#define DEFAULT_PDB				FALSE
#define DEFAULT_PROFILE				FALSE
#define DEFAULT_LINK_ALL			FALSE
#define DEFAULT_DG_G_DRIVER_LEVEL		0
#define DEFAULT_DG_N_DRIVER_LEVEL		0
#define DEFAULT_DG_FILES_LEVEL			0
#define DEFAULT_DG_PROC_LEVEL			0
#define DEFAULT_DG_TABLE_LEVEL			0
#define DEFAULT_DG_CALLS_LEVEL			0
#define DEFAULT_DG_WRITE_LEVEL			0
#define DEFAULT_DG_CODE_LEVEL			0


/*
 * Default values for the resulting executable
 */
#define exe_defaults_user_banner		exe_defaults[0]
#define exe_defaults_nodes			exe_defaults[1]
#define exe_defaults_heap_size			exe_defaults[2]
#define exe_defaults_heap_inc_proximity		exe_defaults[3]
#define exe_defaults_heap_increment		exe_defaults[4]
#define exe_defaults_heap_free_after_gc		exe_defaults[5]
#define exe_defaults_heap_lowat			exe_defaults[6]
#define exe_defaults_heap_hiwat			exe_defaults[7]
#define exe_defaults_gc_slack			exe_defaults[8]
#define exe_defaults_irt_size			exe_defaults[9]
#define exe_defaults_irt_increment		exe_defaults[10]
#define exe_defaults_gsq_interval		exe_defaults[11]

#define EXE_DEFAULTS_TUPLE_SIZE		12

#define DEFAULT_USER_BANNER			""
#define DEFAULT_NODES				-1
#define DEFAULT_HEAP_SIZE			-1
#define DEFAULT_HEAP_INC_PROXIMITY		-1
#define DEFAULT_HEAP_INCREMENT			-1
#define DEFAULT_HEAP_FREE_AFTER_GC		-1
#define DEFAULT_HEAP_LOWAT			-1
#define DEFAULT_HEAP_HIWAT			-1
#define DEFAULT_GC_SLACK			-1
#define DEFAULT_IRT_SIZE			0
#define DEFAULT_IRT_INCREMENT			0
#define DEFAULT_GSQ_INTERVAL			-1

    
/*
 * A tuple is used by the procedure handler (link_proc, link_reply, link_code)
 * to store and pass around static information about the procedure.
 * These #defines are used to access the various parts of this
 * tuple by name.
 */
#define pinfo_file_number	pinfo[0]
#define pinfo_module_number	pinfo[1]
#define pinfo_proc_number	pinfo[2]
#define pinfo_module_name	pinfo[3]
#define pinfo_proc_name		pinfo[4]
#define pinfo_arity		pinfo[5]
#define pinfo_exported		pinfo[6]
#define pinfo_n_counters	pinfo[7]
#define pinfo_n_timers		pinfo[8]
#define pinfo_n_subsects	pinfo[9]
#define pinfo_profile		pinfo[10]
  

/*
 * Maximum length of compile and link commands
 */
#define MAX_COMMAND_LENGTH 4096

/*
 * Maximum length of any path
 */
#define MAX_PATH_LENGTH 1024

/*
 * Estimated number of entries in the exported (global) table
 */
#define	EXPORTED_TABLE_ENTRIES	1024

#endif /* _PCN_INCLUDE_PCN_LINKER_H */
